/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftMonster;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftMagicNumbers;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.material.MaterialData;

public class CraftEnderman
extends CraftMonster
implements Enderman {
    public CraftEnderman(CraftServer server, EntityEnderman entity) {
        super(server, entity);
    }

    public MaterialData getCarriedMaterial() {
        IBlockData blockData = this.getHandle().gu();
        return blockData == null ? Material.AIR.getNewData((byte)0) : CraftMagicNumbers.getMaterial(blockData);
    }

    public BlockData getCarriedBlock() {
        IBlockData blockData = this.getHandle().gu();
        return blockData == null ? null : CraftBlockData.fromData(blockData);
    }

    public void setCarriedMaterial(MaterialData data) {
        this.getHandle().c(CraftMagicNumbers.getBlock(data));
    }

    public void setCarriedBlock(BlockData blockData) {
        this.getHandle().c(blockData == null ? null : ((CraftBlockData)blockData).getState());
    }

    @Override
    public EntityEnderman getHandle() {
        return (EntityEnderman)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderman";
    }

    public boolean teleport() {
        return this.getHandle().u();
    }

    public boolean teleportTowards(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"entity cannot be null");
        return this.getHandle().b(((CraftEntity)entity).getHandle());
    }
}

