/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import java.util.Random;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftProjectile;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CraftFirework
extends CraftProjectile
implements Firework {
    private final Random random = new Random();
    private final CraftItemStack item;

    public CraftFirework(CraftServer server, EntityFireworks entity) {
        super(server, entity);
        ItemStack item = this.getHandle().ar().a(EntityFireworks.a);
        if (item.f()) {
            item = new ItemStack(Items.vE);
            this.getHandle().ar().a(EntityFireworks.a, item);
        }
        this.item = CraftItemStack.asCraftMirror(item);
        if (this.item.getType() != Material.FIREWORK_ROCKET) {
            this.item.setType(Material.FIREWORK_ROCKET);
        }
    }

    @Override
    public EntityFireworks getHandle() {
        return (EntityFireworks)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFirework";
    }

    public FireworkMeta getFireworkMeta() {
        return (FireworkMeta)this.item.getItemMeta();
    }

    public void setFireworkMeta(FireworkMeta meta) {
        this.item.setItemMeta((ItemMeta)meta);
        this.getHandle().h = 10 * (1 + meta.getPower()) + this.random.nextInt(6) + this.random.nextInt(7);
        this.getHandle().ar().markDirty(EntityFireworks.a);
    }

    public boolean setAttachedTo(LivingEntity entity) {
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().i = entity != null ? ((CraftLivingEntity)entity).getHandle() : null;
        return true;
    }

    public LivingEntity getAttachedTo() {
        EntityLiving entity = this.getHandle().i;
        return entity != null ? (LivingEntity)entity.getBukkitEntity() : null;
    }

    public boolean setLife(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be greater than or equal to 0");
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().g = ticks;
        return true;
    }

    public int getLife() {
        return this.getHandle().g;
    }

    public boolean setMaxLife(int ticks) {
        Preconditions.checkArgument((ticks > 0 ? 1 : 0) != 0, (Object)"ticks must be greater than 0");
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().h = ticks;
        return true;
    }

    public int getMaxLife() {
        return this.getHandle().h;
    }

    public void detonate() {
        this.setLife(this.getMaxLife() + 1);
    }

    public boolean isDetonated() {
        return this.getHandle().g > this.getHandle().h;
    }

    public boolean isShotAtAngle() {
        return this.getHandle().f();
    }

    public void setShotAtAngle(boolean shotAtAngle) {
        this.getHandle().ar().a(EntityFireworks.c, shotAtAngle);
    }
}

