/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftAbstractCow;
import org.bukkit.craftbukkit.v1_21_R4.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R4.potion.CraftPotionUtil;
import org.bukkit.entity.MushroomCow;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftMushroomCow
extends CraftAbstractCow
implements MushroomCow {
    public CraftMushroomCow(CraftServer server, EntityMushroomCow entity) {
        super(server, entity);
    }

    public boolean hasEffectsForNextStew() {
        SuspiciousStewEffects stewEffects = this.getHandle().bM;
        return stewEffects != null && !stewEffects.a().isEmpty();
    }

    public List<PotionEffect> getEffectsForNextStew() {
        SuspiciousStewEffects stewEffects = this.getHandle().bM;
        if (stewEffects != null) {
            return stewEffects.a().stream().map(recordSuspiciousEffect -> CraftPotionUtil.toBukkit(recordSuspiciousEffect.a())).toList();
        }
        return ImmutableList.of();
    }

    public boolean addEffectToNextStew(PotionEffect potionEffect, boolean overwrite) {
        Preconditions.checkArgument((potionEffect != null ? 1 : 0) != 0, (Object)"PotionEffect cannot be null");
        MobEffect minecraftPotionEffect = CraftPotionUtil.fromBukkit(potionEffect);
        if (!overwrite && this.hasEffectForNextStew(potionEffect.getType())) {
            return false;
        }
        SuspiciousStewEffects stewEffects = this.getHandle().bM;
        if (stewEffects == null) {
            stewEffects = SuspiciousStewEffects.a;
        }
        SuspiciousStewEffects.a recordSuspiciousEffect = new SuspiciousStewEffects.a(minecraftPotionEffect.c(), minecraftPotionEffect.d());
        this.removeEffectFromNextStew(potionEffect.getType());
        this.getHandle().bM = stewEffects.a(recordSuspiciousEffect);
        return true;
    }

    public boolean removeEffectFromNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        if (!this.hasEffectForNextStew(potionEffectType)) {
            return false;
        }
        SuspiciousStewEffects stewEffects = this.getHandle().bM;
        if (stewEffects == null) {
            return false;
        }
        Holder<MobEffectList> minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraftHolder(potionEffectType);
        this.getHandle().bM = new SuspiciousStewEffects(stewEffects.a().stream().filter(effect -> !effect.b().equals(minecraftPotionEffectType)).toList());
        return true;
    }

    public boolean hasEffectForNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        SuspiciousStewEffects stewEffects = this.getHandle().bM;
        if (stewEffects == null) {
            return false;
        }
        Holder<MobEffectList> minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraftHolder(potionEffectType);
        return stewEffects.a().stream().anyMatch(recordSuspiciousEffect -> recordSuspiciousEffect.b().equals(minecraftPotionEffectType));
    }

    public void clearEffectsForNextStew() {
        this.getHandle().bM = null;
    }

    @Override
    public EntityMushroomCow getHandle() {
        return (EntityMushroomCow)this.entity;
    }

    public MushroomCow.Variant getVariant() {
        return MushroomCow.Variant.values()[this.getHandle().p().ordinal()];
    }

    public void setVariant(MushroomCow.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"Variant cannot be null");
        this.getHandle().a(EntityMushroomCow.Type.values()[variant.ordinal()]);
    }

    @Override
    public String toString() {
        return "CraftMushroomCow";
    }
}

