/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.EntityPanda;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftAnimals;
import org.bukkit.entity.Panda;

public class CraftPanda
extends CraftAnimals
implements Panda {
    public CraftPanda(CraftServer server, EntityPanda entity) {
        super(server, entity);
    }

    @Override
    public EntityPanda getHandle() {
        return (EntityPanda)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftPanda";
    }

    public Panda.Gene getMainGene() {
        return CraftPanda.fromNms(this.getHandle().gx());
    }

    public void setMainGene(Panda.Gene gene) {
        this.getHandle().a(CraftPanda.toNms(gene));
    }

    public Panda.Gene getHiddenGene() {
        return CraftPanda.fromNms(this.getHandle().gy());
    }

    public void setHiddenGene(Panda.Gene gene) {
        this.getHandle().b(CraftPanda.toNms(gene));
    }

    public boolean isRolling() {
        return this.getHandle().gG();
    }

    public void setRolling(boolean flag) {
        this.getHandle().A(flag);
    }

    public boolean isSneezing() {
        return this.getHandle().p();
    }

    public void setSneezing(boolean flag) {
        this.getHandle().z(flag);
    }

    public boolean isSitting() {
        return this.getHandle().u();
    }

    public void setSitting(boolean flag) {
        this.getHandle().w(flag);
    }

    public boolean isOnBack() {
        return this.getHandle().gu();
    }

    public void setOnBack(boolean flag) {
        this.getHandle().x(flag);
    }

    public boolean isEating() {
        return this.getHandle().gv();
    }

    public void setEating(boolean flag) {
        this.getHandle().y(flag);
    }

    public boolean isScared() {
        return this.getHandle().gO();
    }

    public int getUnhappyTicks() {
        return this.getHandle().m();
    }

    public static Panda.Gene fromNms(EntityPanda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return Panda.Gene.values()[gene.ordinal()];
    }

    public static EntityPanda.Gene toNms(Panda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return EntityPanda.Gene.values()[gene.ordinal()];
    }
}

