/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.raid.EntityRaider;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R4.CraftRaid;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.CraftSound;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftMonster;
import org.bukkit.entity.Raider;

public abstract class CraftRaider
extends CraftMonster
implements Raider {
    public CraftRaider(CraftServer server, EntityRaider entity) {
        super(server, entity);
    }

    @Override
    public EntityRaider getHandle() {
        return (EntityRaider)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftRaider";
    }

    public void setRaid(Raid raid) {
        this.getHandle().a(raid != null ? ((CraftRaid)raid).getHandle() : null);
    }

    public Raid getRaid() {
        return this.getHandle().gI() == null ? null : new CraftRaid(this.getHandle().gI(), this.getHandle().dV());
    }

    public void setWave(int wave) {
        Preconditions.checkArgument((wave >= 0 ? 1 : 0) != 0, (Object)"wave must be >= 0");
        this.getHandle().b(wave);
    }

    public int getWave() {
        return this.getHandle().gM();
    }

    public Block getPatrolTarget() {
        return this.getHandle().gw() == null ? null : CraftBlock.at(this.getHandle().dV(), this.getHandle().gw());
    }

    public void setPatrolTarget(Block block) {
        if (block == null) {
            this.getHandle().h((BlockPosition)null);
        } else {
            Preconditions.checkArgument((boolean)block.getWorld().equals((Object)this.getWorld()), (Object)"Block must be in same world");
            this.getHandle().h(((CraftBlock)block).getPosition());
        }
    }

    public boolean isPatrolLeader() {
        return this.getHandle().gy();
    }

    public void setPatrolLeader(boolean leader) {
        this.getHandle().w(leader);
    }

    public boolean isCanJoinRaid() {
        return this.getHandle().gH();
    }

    public void setCanJoinRaid(boolean join) {
        this.getHandle().z(join);
    }

    public boolean isCelebrating() {
        return this.getHandle().gN();
    }

    public void setCelebrating(boolean celebrating) {
        this.getHandle().A(celebrating);
    }

    public int getTicksOutsideRaid() {
        return this.getHandle().gO();
    }

    public void setTicksOutsideRaid(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().c(ticks);
    }

    public Sound getCelebrationSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().af_());
    }
}

