/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.monster.EntityVex;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftMonster;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Vex;

public class CraftVex
extends CraftMonster
implements Vex {
    public CraftVex(CraftServer server, EntityVex entity) {
        super(server, entity);
    }

    @Override
    public EntityVex getHandle() {
        return (EntityVex)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftVex";
    }

    public boolean isCharging() {
        return this.getHandle().gv();
    }

    public void setCharging(boolean charging) {
        this.getHandle().w(charging);
    }

    public Location getBound() {
        BlockPosition blockPosition = this.getHandle().gu();
        return blockPosition == null ? null : CraftLocation.toBukkit(blockPosition, this.getWorld());
    }

    public void setBound(Location location) {
        if (location == null) {
            this.getHandle().h((BlockPosition)null);
        } else {
            Preconditions.checkArgument((boolean)this.getWorld().equals((Object)location.getWorld()), (Object)"The bound world cannot be different to the entity's world.");
            this.getHandle().h(CraftLocation.toBlockPosition(location));
        }
    }

    public int getLifeTicks() {
        return this.getHandle().bJ;
    }

    public void setLifeTicks(int lifeTicks) {
        this.getHandle().b(lifeTicks);
        if (lifeTicks < 0) {
            this.getHandle().bI = false;
        }
    }

    public boolean hasLimitedLife() {
        return this.getHandle().bI;
    }
}

