/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.EntityWither;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftMonster;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Wither;

public class CraftWither
extends CraftMonster
implements Wither {
    private BossBar bossBar;

    public CraftWither(CraftServer server, EntityWither entity) {
        super(server, entity);
        if (entity.bQ != null) {
            this.bossBar = new CraftBossBar(entity.bQ);
        }
    }

    @Override
    public EntityWither getHandle() {
        return (EntityWither)this.entity;
    }

    @Override
    public String toString() {
        return "CraftWither";
    }

    public BossBar getBossBar() {
        return this.bossBar;
    }

    public void setTarget(Wither.Head head, LivingEntity livingEntity) {
        Preconditions.checkArgument((head != null ? 1 : 0) != 0, (Object)"head cannot be null");
        int entityId = livingEntity != null ? livingEntity.getEntityId() : 0;
        this.getHandle().a(head.ordinal(), entityId);
    }

    public LivingEntity getTarget(Wither.Head head) {
        Preconditions.checkArgument((head != null ? 1 : 0) != 0, (Object)"head cannot be null");
        int entityId = this.getHandle().c(head.ordinal());
        if (entityId == 0) {
            return null;
        }
        Entity target = this.getHandle().dV().a(entityId);
        return target != null ? (LivingEntity)target.getBukkitEntity() : null;
    }

    public int getInvulnerabilityTicks() {
        return this.getHandle().gv();
    }

    public void setInvulnerabilityTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >=0");
        this.getHandle().b(ticks);
    }
}

