/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.generator;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R4.generator.CraftBiomeParameterPoint;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;

public class CustomWorldChunkManager
extends WorldChunkManager {
    private final WorldInfo worldInfo;
    private final BiomeProvider biomeProvider;
    private final IRegistry<BiomeBase> registry;

    private static List<Holder<BiomeBase>> biomeListToBiomeBaseList(List<Biome> biomes, IRegistry<BiomeBase> registry) {
        ArrayList<Holder<BiomeBase>> biomeBases = new ArrayList<Holder<BiomeBase>>();
        for (Biome biome : biomes) {
            Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot use the biome %s", (Object)biome);
            biomeBases.add(CraftBiome.bukkitToMinecraftHolder(biome));
        }
        return biomeBases;
    }

    public CustomWorldChunkManager(WorldInfo worldInfo, BiomeProvider biomeProvider, IRegistry<BiomeBase> registry) {
        this.worldInfo = worldInfo;
        this.biomeProvider = biomeProvider;
        this.registry = registry;
    }

    @Override
    protected MapCodec<? extends WorldChunkManager> a() {
        throw new UnsupportedOperationException("Cannot serialize CustomWorldChunkManager");
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int x2, int y2, int z2, Climate.Sampler sampler) {
        Biome biome = this.biomeProvider.getBiome(this.worldInfo, x2 << 2, y2 << 2, z2 << 2, CraftBiomeParameterPoint.createBiomeParameterPoint(sampler, sampler.a(x2, y2, z2)));
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        return CraftBiome.bukkitToMinecraftHolder(biome);
    }

    @Override
    protected Stream<Holder<BiomeBase>> b() {
        return CustomWorldChunkManager.biomeListToBiomeBaseList(this.biomeProvider.getBiomes(this.worldInfo), this.registry).stream();
    }
}

