/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CraftInventoryPlayer
extends CraftInventory
implements PlayerInventory,
EntityEquipment {
    public CraftInventoryPlayer(net.minecraft.world.entity.player.PlayerInventory inventory) {
        super(inventory);
    }

    @Override
    public net.minecraft.world.entity.player.PlayerInventory getInventory() {
        return (net.minecraft.world.entity.player.PlayerInventory)this.inventory;
    }

    @Override
    public ItemStack[] getStorageContents() {
        return this.asCraftMirror(this.getInventory().i());
    }

    public ItemStack getItemInMainHand() {
        return CraftItemStack.asCraftMirror(this.getInventory().g());
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItem(this.getHeldItemSlot(), item);
    }

    public void setItemInMainHand(ItemStack item, boolean silent) {
        this.setItemInMainHand(item);
    }

    public ItemStack getItemInOffHand() {
        return CraftItemStack.asCraftMirror(this.getInventory().a(40));
    }

    public void setItemInOffHand(ItemStack item) {
        ItemStack[] extra = this.getExtraContents();
        extra[0] = item;
        this.setExtraContents(extra);
    }

    public void setItemInOffHand(ItemStack item, boolean silent) {
        this.setItemInOffHand(item);
    }

    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    @Override
    public void setItem(int index, ItemStack item) {
        super.setItem(index, item);
        if (this.getHolder() == null) {
            return;
        }
        EntityPlayer player = ((CraftPlayer)this.getHolder()).getHandle();
        if (player.f == null) {
            return;
        }
        if (index < net.minecraft.world.entity.player.PlayerInventory.h()) {
            index += 36;
        } else if (index > 39) {
            index += 5;
        } else if (index > 35) {
            index = 8 - (index - 36);
        }
        player.f.b(new PacketPlayOutSetSlot(player.bQ.l, player.bQ.k(), index, CraftItemStack.asNMSCopy(item)));
    }

    public void setItem(EquipmentSlot slot, ItemStack item) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        switch (slot) {
            case HAND: {
                this.setItemInMainHand(item);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(item);
                break;
            }
            case FEET: {
                this.setBoots(item);
                break;
            }
            case LEGS: {
                this.setLeggings(item);
                break;
            }
            case CHEST: {
                this.setChestplate(item);
                break;
            }
            case HEAD: {
                this.setHelmet(item);
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not set slot " + String.valueOf(slot) + " - not a valid slot for PlayerInventory");
            }
        }
    }

    public void setItem(EquipmentSlot slot, ItemStack item, boolean silent) {
        this.setItem(slot, item);
    }

    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        switch (slot) {
            case HAND: {
                return this.getItemInMainHand();
            }
            case OFF_HAND: {
                return this.getItemInOffHand();
            }
            case FEET: {
                return this.getBoots();
            }
            case LEGS: {
                return this.getLeggings();
            }
            case CHEST: {
                return this.getChestplate();
            }
            case HEAD: {
                return this.getHelmet();
            }
        }
        throw new IllegalArgumentException("Could not get slot " + String.valueOf(slot) + " - not a valid slot for PlayerInventory");
    }

    public int getHeldItemSlot() {
        return this.getInventory().f();
    }

    public void setHeldItemSlot(int slot) {
        Preconditions.checkArgument((slot >= 0 && slot < net.minecraft.world.entity.player.PlayerInventory.h() ? 1 : 0) != 0, (String)"Slot (%s) is not between 0 and %s inclusive", (int)slot, (int)(net.minecraft.world.entity.player.PlayerInventory.h() - 1));
        this.getInventory().c(slot);
        ((CraftPlayer)this.getHolder()).getHandle().f.b(new PacketPlayOutHeldItemSlot(slot));
    }

    public ItemStack getHelmet() {
        return this.getItem(this.getSize() - 2);
    }

    public ItemStack getChestplate() {
        return this.getItem(this.getSize() - 3);
    }

    public ItemStack getLeggings() {
        return this.getItem(this.getSize() - 4);
    }

    public ItemStack getBoots() {
        return this.getItem(this.getSize() - 5);
    }

    public void setHelmet(ItemStack helmet) {
        this.setItem(this.getSize() - 2, helmet);
    }

    public void setHelmet(ItemStack helmet, boolean silent) {
        this.setHelmet(helmet);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setItem(this.getSize() - 3, chestplate);
    }

    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.setChestplate(chestplate);
    }

    public void setLeggings(ItemStack leggings) {
        this.setItem(this.getSize() - 4, leggings);
    }

    public void setLeggings(ItemStack leggings, boolean silent) {
        this.setLeggings(leggings);
    }

    public void setBoots(ItemStack boots) {
        this.setItem(this.getSize() - 5, boots);
    }

    public void setBoots(ItemStack boots, boolean silent) {
        this.setBoots(boots);
    }

    public ItemStack[] getArmorContents() {
        return this.asCraftMirror(this.getInventory().getArmorContents());
    }

    private void setSlots(ItemStack[] items, int baseSlot, int length) {
        if (items == null) {
            items = new ItemStack[length];
        }
        Preconditions.checkArgument((items.length <= length ? 1 : 0) != 0, (String)"items.length must be <= %s", (int)length);
        for (int i2 = 0; i2 < length; ++i2) {
            if (i2 >= items.length) {
                this.setItem(baseSlot + i2, null);
                continue;
            }
            this.setItem(baseSlot + i2, items[i2]);
        }
    }

    @Override
    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        this.setSlots(items, 0, 36);
    }

    public void setArmorContents(ItemStack[] items) {
        this.setSlots(items, 36, 4);
    }

    public ItemStack[] getExtraContents() {
        return new ItemStack[]{this.getItemInOffHand()};
    }

    public void setExtraContents(ItemStack[] items) {
        this.setSlots(items, 40, 1);
    }

    public HumanEntity getHolder() {
        return (HumanEntity)this.inventory.getOwner();
    }

    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    public float getItemInMainHandDropChance() {
        return 1.0f;
    }

    public void setItemInMainHandDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getItemInOffHandDropChance() {
        return 1.0f;
    }

    public void setItemInOffHandDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getHelmetDropChance() {
        return 1.0f;
    }

    public void setHelmetDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getChestplateDropChance() {
        return 1.0f;
    }

    public void setChestplateDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getLeggingsDropChance() {
        return 1.0f;
    }

    public void setLeggingsDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getBootsDropChance() {
        return 1.0f;
    }

    public void setBootsDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }
}

