/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.component.FireworkExplosion;
import org.bukkit.FireworkEffect;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R4.inventory.SerializableMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaCharge
extends CraftMetaItem
implements FireworkEffectMeta {
    static final CraftMetaItem.ItemMetaKeyType<FireworkExplosion> EXPLOSION = new CraftMetaItem.ItemMetaKeyType<FireworkExplosion>(DataComponents.ai, "firework-effect");
    private FireworkEffect effect;

    CraftMetaCharge(CraftMetaItem meta) {
        super(meta);
        if (meta instanceof CraftMetaCharge) {
            this.effect = ((CraftMetaCharge)meta).effect;
        }
    }

    CraftMetaCharge(Map<String, Object> map) {
        super(map);
        this.setEffect(SerializableMeta.getObject(FireworkEffect.class, map, CraftMetaCharge.EXPLOSION.BUKKIT, true));
    }

    CraftMetaCharge(DataComponentPatch tag) {
        super(tag);
        CraftMetaCharge.getOrEmpty(tag, EXPLOSION).ifPresent(f2 -> {
            try {
                this.effect = CraftMetaFirework.getEffect(f2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    public void setEffect(FireworkEffect effect) {
        this.effect = effect;
    }

    public boolean hasEffect() {
        return this.effect != null;
    }

    public FireworkEffect getEffect() {
        return this.effect;
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator itemTag) {
        super.applyToItem(itemTag);
        if (this.hasEffect()) {
            itemTag.put(EXPLOSION, CraftMetaFirework.getExplosion(this.effect));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && !this.hasChargeMeta();
    }

    boolean hasChargeMeta() {
        return this.hasEffect();
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaCharge) {
            CraftMetaCharge that = (CraftMetaCharge)meta;
            return this.hasEffect() ? that.hasEffect() && this.effect.equals((Object)that.effect) : !that.hasEffect();
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaCharge || !this.hasChargeMeta());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasEffect()) {
            hash = 61 * hash + this.effect.hashCode();
        }
        return hash != original ? CraftMetaCharge.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaCharge clone() {
        return (CraftMetaCharge)super.clone();
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasEffect()) {
            builder.put((Object)CraftMetaCharge.EXPLOSION.BUKKIT, (Object)this.effect);
        }
        return builder;
    }
}

