/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.inventory.components.consumable.effects;

import java.util.Map;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ClearAllStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.consume_effects.PlaySoundConsumeEffect;
import net.minecraft.world.item.consume_effects.RemoveStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.TeleportRandomlyConsumeEffect;
import org.bukkit.craftbukkit.v1_21_R4.inventory.components.consumable.effects.CraftConsumableApplyEffects;
import org.bukkit.craftbukkit.v1_21_R4.inventory.components.consumable.effects.CraftConsumableClearEffects;
import org.bukkit.craftbukkit.v1_21_R4.inventory.components.consumable.effects.CraftConsumablePlaySound;
import org.bukkit.craftbukkit.v1_21_R4.inventory.components.consumable.effects.CraftConsumableRemoveEffect;
import org.bukkit.craftbukkit.v1_21_R4.inventory.components.consumable.effects.CraftConsumableTeleportRandomly;
import org.bukkit.inventory.meta.components.consumable.effects.ConsumableEffect;

public abstract class CraftConsumableEffect<T extends ConsumeEffect>
implements ConsumableEffect {
    T handle;

    public static <T extends CraftConsumableEffect<?>> T minecraftToBukkitSpecific(ConsumeEffect effect) {
        if (effect instanceof ApplyStatusEffectsConsumeEffect) {
            ApplyStatusEffectsConsumeEffect nmsEffect = (ApplyStatusEffectsConsumeEffect)effect;
            return (T)new CraftConsumableApplyEffects(nmsEffect);
        }
        if (effect instanceof RemoveStatusEffectsConsumeEffect) {
            RemoveStatusEffectsConsumeEffect nmsEffect = (RemoveStatusEffectsConsumeEffect)effect;
            return (T)new CraftConsumableRemoveEffect(nmsEffect);
        }
        if (effect instanceof ClearAllStatusEffectsConsumeEffect) {
            ClearAllStatusEffectsConsumeEffect nmsEffect = (ClearAllStatusEffectsConsumeEffect)effect;
            return (T)new CraftConsumableClearEffects(nmsEffect);
        }
        if (effect instanceof TeleportRandomlyConsumeEffect) {
            TeleportRandomlyConsumeEffect nmsEffect = (TeleportRandomlyConsumeEffect)effect;
            return (T)new CraftConsumableTeleportRandomly(nmsEffect);
        }
        if (effect instanceof PlaySoundConsumeEffect) {
            PlaySoundConsumeEffect nmsEffect = (PlaySoundConsumeEffect)effect;
            return (T)new CraftConsumablePlaySound(nmsEffect);
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(effect.a()));
    }

    public static <T extends ConsumeEffect> T bukkitToMinecraftSpecific(CraftConsumableEffect<T> effect) {
        return effect.getHandle();
    }

    public CraftConsumableEffect(T consumeEffect) {
        this.handle = consumeEffect;
    }

    public CraftConsumableEffect(CraftConsumableEffect<T> consumeEffect) {
        this.handle = consumeEffect.handle;
    }

    public CraftConsumableEffect(Map<String, Object> map) {
    }

    public T getHandle() {
        return this.handle;
    }
}

