/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.inventory.view.builder;

import com.google.common.base.Preconditions;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.trading.IMerchant;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R4.inventory.view.builder.CraftAbstractInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.view.builder.MerchantInventoryViewBuilder;

public class CraftMerchantInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractInventoryViewBuilder<V>
implements MerchantInventoryViewBuilder<V> {
    private IMerchant merchant;

    public CraftMerchantInventoryViewBuilder(Containers<?> handle) {
        super(handle);
    }

    @Override
    public MerchantInventoryViewBuilder<V> title(String title) {
        return (MerchantInventoryViewBuilder)super.title(title);
    }

    public MerchantInventoryViewBuilder<V> merchant(Merchant merchant) {
        this.merchant = ((CraftMerchant)merchant).getMerchant();
        return this;
    }

    public MerchantInventoryViewBuilder<V> checkReachable(boolean checkReachable) {
        this.checkReachable = checkReachable;
        return this;
    }

    @Override
    public V build(HumanEntity player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((this.title != null ? 1 : 0) != 0, (Object)"The given title must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof EntityPlayer), (Object)"The given player must be an EntityPlayer");
        EntityPlayer serverPlayer = (EntityPlayer)craftHuman.getHandle();
        ContainerMerchant container = this.merchant == null ? new ContainerMerchant(serverPlayer.nextContainerCounter(), serverPlayer.gj(), new CraftMerchantCustom(this.title).getMerchant()) : new ContainerMerchant(serverPlayer.nextContainerCounter(), serverPlayer.gj(), this.merchant);
        container.checkReachable = this.checkReachable;
        container.setTitle(CraftChatMessage.fromString(this.title)[0]);
        return (V)container.getBukkitView();
    }

    @Override
    protected Container buildContainer(EntityPlayer player) {
        throw new UnsupportedOperationException("buildContainer is not supported for CraftMerchantInventoryViewBuilder");
    }

    public MerchantInventoryViewBuilder<V> copy() {
        CraftMerchantInventoryViewBuilder<V> copy = new CraftMerchantInventoryViewBuilder<V>(this.handle);
        copy.checkReachable = this.checkReachable;
        copy.merchant = this.merchant;
        copy.title = this.title;
        return copy;
    }
}

