/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.completer.CompletionHandler;
import org.bukkit.craftbukkit.v1_21_R4.util.TerminalConsoleWriterThread;

public class TerminalCompletionHandler
implements CompletionHandler {
    private final TerminalConsoleWriterThread writerThread;
    private final CompletionHandler delegate;

    public TerminalCompletionHandler(TerminalConsoleWriterThread writerThread, CompletionHandler delegate) {
        this.writerThread = writerThread;
        this.delegate = delegate;
    }

    public boolean complete(ConsoleReader reader, List<CharSequence> candidates, int position) throws IOException {
        if (candidates.size() <= reader.getAutoprintThreshold()) {
            return this.delegate.complete(reader, candidates, position);
        }
        HashSet<CharSequence> distinct = new HashSet<CharSequence>(candidates);
        if (distinct.size() <= reader.getAutoprintThreshold()) {
            return this.delegate.complete(reader, candidates, position);
        }
        this.writerThread.setCompletion(distinct.size());
        boolean result = this.delegate.complete(reader, candidates, position);
        this.writerThread.setCompletion(-1);
        reader.drawLine();
        reader.flush();
        return result;
    }
}

