/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ambient.EntityAmbient;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sheep.EntitySheep;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R4.SpigotTimings;
import org.spigotmc.SpigotWorldConfig;

public class ActivationRange {
    static AxisAlignedBB maxBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public static ActivationType initializeEntityActivationType(Entity entity) {
        if (entity instanceof EntityRaider) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof EntityMonster || entity instanceof EntitySlime) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof EntityCreature || entity instanceof EntityAmbient) {
            return ActivationType.ANIMAL;
        }
        return ActivationType.MISC;
    }

    public static boolean initializeEntityActivationState(Entity entity, SpigotWorldConfig config) {
        if (config == null) {
            return false;
        }
        return entity.activationType == ActivationType.MISC && config.miscActivationRange == 0 || entity.activationType == ActivationType.RAIDER && config.raiderActivationRange == 0 || entity.activationType == ActivationType.ANIMAL && config.animalActivationRange == 0 || entity.activationType == ActivationType.MONSTER && config.monsterActivationRange == 0 || entity instanceof EntityHuman || entity instanceof EntityProjectile || entity instanceof EntityEnderDragon || entity instanceof EntityComplexPart || entity instanceof EntityWither || entity instanceof EntityFireball || entity instanceof EntityLightning || entity instanceof EntityTNTPrimed || entity instanceof EntityEnderCrystal || entity instanceof EntityFireworks || entity instanceof EntityThrownTrident;
    }

    public static void activateEntities(World world) {
        SpigotTimings.entityActivationCheckTimer.startTiming();
        int miscActivationRange = world.spigotConfig.miscActivationRange;
        int raiderActivationRange = world.spigotConfig.raiderActivationRange;
        int animalActivationRange = world.spigotConfig.animalActivationRange;
        int monsterActivationRange = world.spigotConfig.monsterActivationRange;
        int maxRange = Math.max(monsterActivationRange, animalActivationRange);
        maxRange = Math.max(maxRange, raiderActivationRange);
        maxRange = Math.max(maxRange, miscActivationRange);
        maxRange = Math.min((world.spigotConfig.simulationDistance << 4) - 8, maxRange);
        for (EntityHuman entityHuman : world.z()) {
            entityHuman.activatedTick = MinecraftServer.currentTick;
            if (world.spigotConfig.ignoreSpectatorActivation && entityHuman.ak()) continue;
            maxBB = entityHuman.cR().c(maxRange, 256.0, maxRange);
            ActivationType.MISC.boundingBox = entityHuman.cR().c(miscActivationRange, 256.0, miscActivationRange);
            ActivationType.RAIDER.boundingBox = entityHuman.cR().c(raiderActivationRange, 256.0, raiderActivationRange);
            ActivationType.ANIMAL.boundingBox = entityHuman.cR().c(animalActivationRange, 256.0, animalActivationRange);
            ActivationType.MONSTER.boundingBox = entityHuman.cR().c(monsterActivationRange, 256.0, monsterActivationRange);
            world.H().a(maxBB, ActivationRange::activateEntity);
        }
        SpigotTimings.entityActivationCheckTimer.stopTiming();
    }

    private static void activateEntity(Entity entity) {
        if ((long)MinecraftServer.currentTick > entity.activatedTick) {
            if (entity.defaultActivationState) {
                entity.activatedTick = MinecraftServer.currentTick;
                return;
            }
            if (entity.activationType.boundingBox.c(entity.cR())) {
                entity.activatedTick = MinecraftServer.currentTick;
            }
        }
    }

    public static boolean checkEntityImmunities(Entity entity) {
        if (entity.ag || entity.aE() > 0) {
            return true;
        }
        if (!(entity instanceof EntityArrow) ? !entity.aH() || !entity.u.isEmpty() || entity.bY() : !((EntityArrow)entity).e()) {
            return true;
        }
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            if (living.aN > 0 || living.bH.size() > 0) {
                return true;
            }
            if (entity instanceof EntityCreature && ((EntityCreature)entity).e() != null) {
                return true;
            }
            if (entity instanceof EntityVillager && ((EntityVillager)entity).X_()) {
                return true;
            }
            if (entity instanceof EntityAnimal) {
                EntityAnimal animal = (EntityAnimal)entity;
                if (animal.e_() || animal.gE()) {
                    return true;
                }
                if (entity instanceof EntitySheep && ((EntitySheep)entity).u()) {
                    return true;
                }
            }
            if (entity instanceof EntityCreeper && ((EntityCreeper)entity).gu()) {
                return true;
            }
        }
        return entity instanceof EntityExperienceOrb;
    }

    public static boolean checkIfActive(Entity entity) {
        boolean isActive;
        SpigotTimings.checkIfActiveTimer.startTiming();
        if (entity instanceof EntityFireworks || entity instanceof EntityItem && (entity.af + entity.ao() + 1) % 4 == 0) {
            SpigotTimings.checkIfActiveTimer.stopTiming();
            return true;
        }
        boolean bl = isActive = entity.activatedTick >= (long)MinecraftServer.currentTick || entity.defaultActivationState;
        if (!isActive) {
            if (((long)MinecraftServer.currentTick - entity.activatedTick - 1L) % 20L == 0L) {
                if (ActivationRange.checkEntityImmunities(entity)) {
                    entity.activatedTick = MinecraftServer.currentTick + 20;
                }
                isActive = true;
            }
        } else if (!entity.defaultActivationState && entity.af % 4 == 0 && !ActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        SpigotTimings.checkIfActiveTimer.stopTiming();
        return isActive;
    }

    public static enum ActivationType {
        MONSTER,
        ANIMAL,
        RAIDER,
        MISC;

        AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

