/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public interface CollectionContentsPredicate<T, P extends Predicate<T>>
extends Predicate<Iterable<T>> {
    public List<P> unpack();

    public static <T, P extends Predicate<T>> Codec<CollectionContentsPredicate<T, P>> codec(Codec<P> var0) {
        return var0.listOf().xmap(CollectionContentsPredicate::of, CollectionContentsPredicate::unpack);
    }

    @SafeVarargs
    public static <T, P extends Predicate<T>> CollectionContentsPredicate<T, P> of(P ... var0) {
        return CollectionContentsPredicate.of(List.of(var0));
    }

    public static <T, P extends Predicate<T>> CollectionContentsPredicate<T, P> of(List<P> var0) {
        return switch (var0.size()) {
            case 0 -> new Zero();
            case 1 -> new Single((Predicate)var0.getFirst());
            default -> new Multiple(var0);
        };
    }

    public static class Zero<T, P extends Predicate<T>>
    implements CollectionContentsPredicate<T, P> {
        @Override
        public boolean test(Iterable<T> var0) {
            return true;
        }

        @Override
        public List<P> unpack() {
            return List.of();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Iterable)object);
        }
    }

    public record Single<T, P extends Predicate<T>>(P test) implements CollectionContentsPredicate<T, P>
    {
        @Override
        public boolean test(Iterable<T> var0) {
            for (T var2 : var0) {
                if (!this.test.test(var2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<P> unpack() {
            return List.of(this.test);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Iterable)object);
        }
    }

    public record Multiple<T, P extends Predicate<T>>(List<P> tests) implements CollectionContentsPredicate<T, P>
    {
        @Override
        public boolean test(Iterable<T> var0) {
            ArrayList<P> var12 = new ArrayList<P>(this.tests);
            for (Object var3 : var0) {
                var12.removeIf(var1 -> var1.test(var3));
                if (!var12.isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<P> unpack() {
            return this.tests;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Iterable)object);
        }
    }
}

