/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;

public class KilledByArrowTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer var0, Collection<Entity> var1, @Nullable ItemStack var2) {
        ArrayList var32 = Lists.newArrayList();
        HashSet var4 = Sets.newHashSet();
        for (Entity var6 : var1) {
            var4.add(var6.getType());
            var32.add(EntityPredicate.createContext(var0, var6));
        }
        this.trigger(var0, var3 -> var3.matches(var32, var4.size(), var2));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, List<ContextAwarePredicate> victims, MinMaxBounds.Ints uniqueEntityTypes, Optional<ItemPredicate> firedFromWeapon) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.listOf().optionalFieldOf("victims", List.of()).forGetter(TriggerInstance::victims), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("unique_entity_types", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::uniqueEntityTypes), (App)ItemPredicate.CODEC.optionalFieldOf("fired_from_weapon").forGetter(TriggerInstance::firedFromWeapon)).apply((Applicative)var0, TriggerInstance::new));

        public static Criterion<TriggerInstance> crossbowKilled(HolderGetter<Item> var0, EntityPredicate.Builder ... var1) {
            return CriteriaTriggers.KILLED_BY_ARROW.createCriterion(new TriggerInstance(Optional.empty(), EntityPredicate.wrap(var1), MinMaxBounds.Ints.ANY, Optional.of(ItemPredicate.Builder.item().of(var0, Items.CROSSBOW).build())));
        }

        public static Criterion<TriggerInstance> crossbowKilled(HolderGetter<Item> var0, MinMaxBounds.Ints var1) {
            return CriteriaTriggers.KILLED_BY_ARROW.createCriterion(new TriggerInstance(Optional.empty(), List.of(), var1, Optional.of(ItemPredicate.Builder.item().of(var0, Items.CROSSBOW).build())));
        }

        public boolean matches(Collection<LootContext> var0, int var1, @Nullable ItemStack var2) {
            if (this.firedFromWeapon.isPresent() && (var2 == null || !this.firedFromWeapon.get().test(var2))) {
                return false;
            }
            if (!this.victims.isEmpty()) {
                ArrayList var3 = Lists.newArrayList(var0);
                for (ContextAwarePredicate var5 : this.victims) {
                    boolean var6 = false;
                    Iterator var7 = var3.iterator();
                    while (var7.hasNext()) {
                        LootContext var8 = (LootContext)var7.next();
                        if (!var5.matches(var8)) continue;
                        var7.remove();
                        var6 = true;
                        break;
                    }
                    if (var6) continue;
                    return false;
                }
            }
            return this.uniqueEntityTypes.matches(var1);
        }

        @Override
        public void validate(CriterionValidator var0) {
            SimpleCriterionTrigger.SimpleInstance.super.validate(var0);
            var0.validateEntities(this.victims, "victims");
        }
    }
}

