/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.datafixers.DataFixUtils;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.HashedPatchMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface HashedStack {
    public static final HashedStack EMPTY = new HashedStack(){

        public String toString() {
            return "<empty>";
        }

        @Override
        public boolean matches(ItemStack var0, HashedPatchMap.HashGenerator var1) {
            return var0.isEmpty();
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, HashedStack> STREAM_CODEC = ByteBufCodecs.optional(ActualItem.STREAM_CODEC).map(var0 -> (HashedStack)DataFixUtils.orElse((Optional)var0, (Object)EMPTY), var0 -> {
        Optional<Object> optional;
        if (var0 instanceof ActualItem) {
            ActualItem var1 = (ActualItem)var0;
            optional = Optional.of(var1);
        } else {
            optional = Optional.empty();
        }
        return optional;
    });

    public boolean matches(ItemStack var1, HashedPatchMap.HashGenerator var2);

    public static HashedStack create(ItemStack var0, HashedPatchMap.HashGenerator var1) {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        return new ActualItem(var0.getItemHolder(), var0.getCount(), HashedPatchMap.create(var0.getComponentsPatch(), var1));
    }

    public record ActualItem(Holder<Item> item, int count, HashedPatchMap components) implements HashedStack
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, ActualItem> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.ITEM), ActualItem::item, ByteBufCodecs.VAR_INT, ActualItem::count, HashedPatchMap.STREAM_CODEC, ActualItem::components, ActualItem::new);

        @Override
        public boolean matches(ItemStack var0, HashedPatchMap.HashGenerator var1) {
            if (this.count != var0.getCount()) {
                return false;
            }
            if (!this.item.equals(var0.getItemHolder())) {
                return false;
            }
            return this.components.matches(var0.getComponentsPatch(), var1);
        }
    }
}

