/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.level.ServerPlayer;

public interface OutgoingChatMessage {
    public Component content();

    public void sendToPlayer(ServerPlayer var1, boolean var2, ChatType.Bound var3);

    public static OutgoingChatMessage create(PlayerChatMessage var0) {
        if (var0.isSystem()) {
            return new Disguised(var0.decoratedContent());
        }
        return new Player(var0);
    }

    public record Disguised(Component content) implements OutgoingChatMessage
    {
        @Override
        public void sendToPlayer(ServerPlayer var0, boolean var1, ChatType.Bound var2) {
            var0.connection.sendDisguisedChatMessage(this.content, var2);
        }
    }

    public record Player(PlayerChatMessage message) implements OutgoingChatMessage
    {
        @Override
        public Component content() {
            return this.message.decoratedContent();
        }

        @Override
        public void sendToPlayer(ServerPlayer var0, boolean var1, ChatType.Bound var2) {
            PlayerChatMessage var3 = this.message.filter(var1);
            if (!var3.isFullyFiltered()) {
                var0.connection.sendPlayerChatMessage(var3, var2);
            }
        }
    }
}

