/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public record ClientboundChunksBiomesPacket(List<ChunkBiomeData> chunkBiomeData) implements Packet<ClientGamePacketListener>
{
    public static final StreamCodec<FriendlyByteBuf, ClientboundChunksBiomesPacket> STREAM_CODEC = Packet.codec(ClientboundChunksBiomesPacket::write, ClientboundChunksBiomesPacket::new);
    private static final int TWO_MEGABYTES = 0x200000;

    private ClientboundChunksBiomesPacket(FriendlyByteBuf var0) {
        this(var0.readList(ChunkBiomeData::new));
    }

    public static ClientboundChunksBiomesPacket forChunks(List<LevelChunk> var0) {
        return new ClientboundChunksBiomesPacket(var0.stream().map(ChunkBiomeData::new).toList());
    }

    private void write(FriendlyByteBuf var02) {
        var02.writeCollection(this.chunkBiomeData, (var0, var1) -> var1.write((FriendlyByteBuf)((Object)var0)));
    }

    @Override
    public PacketType<ClientboundChunksBiomesPacket> type() {
        return GamePacketTypes.CLIENTBOUND_CHUNKS_BIOMES;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleChunksBiomes(this);
    }

    public record ChunkBiomeData(ChunkPos pos, byte[] buffer) {
        public ChunkBiomeData(LevelChunk var0) {
            this(var0.getPos(), new byte[ChunkBiomeData.calculateChunkSize(var0)]);
            ChunkBiomeData.extractChunkData(new FriendlyByteBuf(this.getWriteBuffer()), var0);
        }

        public ChunkBiomeData(FriendlyByteBuf var0) {
            this(var0.readChunkPos(), var0.readByteArray(0x200000));
        }

        private static int calculateChunkSize(LevelChunk var0) {
            int var1 = 0;
            for (LevelChunkSection var5 : var0.getSections()) {
                var1 += var5.getBiomes().getSerializedSize();
            }
            return var1;
        }

        public FriendlyByteBuf getReadBuffer() {
            return new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.buffer));
        }

        private ByteBuf getWriteBuffer() {
            ByteBuf var0 = Unpooled.wrappedBuffer((byte[])this.buffer);
            var0.writerIndex(0);
            return var0;
        }

        public static void extractChunkData(FriendlyByteBuf var0, LevelChunk var1) {
            for (LevelChunkSection var5 : var1.getSections()) {
                var5.getBiomes().write(var0);
            }
            if (var0.writerIndex() != var0.capacity()) {
                throw new IllegalStateException("Didn't fill biome buffer: expected " + var0.capacity() + " bytes, got " + var0.writerIndex());
            }
        }

        public void write(FriendlyByteBuf var0) {
            var0.writeChunkPos(this.pos);
            var0.writeByteArray(this.buffer);
        }
    }
}

