/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardSaveData;
import net.minecraft.world.waypoints.WaypointTransmitter;

public class ServerScoreboard
extends Scoreboard {
    public static final SavedDataType<ScoreboardSaveData> TYPE = new SavedDataType<ScoreboardSaveData>("scoreboard", persistentbase_a -> persistentbase_a.levelOrThrow().getScoreboard().createData(), persistentbase_a -> {
        ServerScoreboard scoreboardserver = persistentbase_a.levelOrThrow().getScoreboard();
        Codec<ScoreboardSaveData.Packed> codec = ScoreboardSaveData.Packed.CODEC;
        Objects.requireNonNull(scoreboardserver);
        return codec.xmap(scoreboardserver::createData, ScoreboardSaveData::pack);
    }, DataFixTypes.SAVED_DATA_SCOREBOARD);
    private final MinecraftServer server;
    private final Set<Objective> trackedObjectives = Sets.newHashSet();
    private final List<Runnable> dirtyListeners = Lists.newArrayList();

    public ServerScoreboard(MinecraftServer minecraftserver) {
        this.server = minecraftserver;
    }

    @Override
    protected void onScoreChanged(ScoreHolder scoreholder, Objective scoreboardobjective, Score scoreboardscore) {
        super.onScoreChanged(scoreholder, scoreboardobjective, scoreboardscore);
        if (this.trackedObjectives.contains(scoreboardobjective)) {
            this.broadcastAll(new ClientboundSetScorePacket(scoreholder.getScoreboardName(), scoreboardobjective.getName(), scoreboardscore.value(), Optional.ofNullable(scoreboardscore.display()), Optional.ofNullable(scoreboardscore.numberFormat())));
        }
        this.setDirty();
    }

    @Override
    protected void onScoreLockChanged(ScoreHolder scoreholder, Objective scoreboardobjective) {
        super.onScoreLockChanged(scoreholder, scoreboardobjective);
        this.setDirty();
    }

    @Override
    public void onPlayerRemoved(ScoreHolder scoreholder) {
        super.onPlayerRemoved(scoreholder);
        this.broadcastAll(new ClientboundResetScorePacket(scoreholder.getScoreboardName(), null));
        this.setDirty();
    }

    @Override
    public void onPlayerScoreRemoved(ScoreHolder scoreholder, Objective scoreboardobjective) {
        super.onPlayerScoreRemoved(scoreholder, scoreboardobjective);
        if (this.trackedObjectives.contains(scoreboardobjective)) {
            this.broadcastAll(new ClientboundResetScorePacket(scoreholder.getScoreboardName(), scoreboardobjective.getName()));
        }
        this.setDirty();
    }

    @Override
    public void setDisplayObjective(DisplaySlot displayslot, @Nullable Objective scoreboardobjective) {
        Objective scoreboardobjective1 = this.getDisplayObjective(displayslot);
        super.setDisplayObjective(displayslot, scoreboardobjective);
        if (scoreboardobjective1 != scoreboardobjective && scoreboardobjective1 != null) {
            if (this.getObjectiveDisplaySlotCount(scoreboardobjective1) > 0) {
                this.broadcastAll(new ClientboundSetDisplayObjectivePacket(displayslot, scoreboardobjective));
            } else {
                this.stopTrackingObjective(scoreboardobjective1);
            }
        }
        if (scoreboardobjective != null) {
            if (this.trackedObjectives.contains(scoreboardobjective)) {
                this.broadcastAll(new ClientboundSetDisplayObjectivePacket(displayslot, scoreboardobjective));
            } else {
                this.startTrackingObjective(scoreboardobjective);
            }
        }
        this.setDirty();
    }

    @Override
    public boolean addPlayerToTeam(String s, PlayerTeam scoreboardteam) {
        if (super.addPlayerToTeam(s, scoreboardteam)) {
            this.broadcastAll(ClientboundSetPlayerTeamPacket.createPlayerPacket(scoreboardteam, s, ClientboundSetPlayerTeamPacket.Action.ADD));
            this.updatePlayerWaypoint(s);
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public void removePlayerFromTeam(String s, PlayerTeam scoreboardteam) {
        super.removePlayerFromTeam(s, scoreboardteam);
        this.broadcastAll(ClientboundSetPlayerTeamPacket.createPlayerPacket(scoreboardteam, s, ClientboundSetPlayerTeamPacket.Action.REMOVE));
        this.updatePlayerWaypoint(s);
        this.setDirty();
    }

    @Override
    public void onObjectiveAdded(Objective scoreboardobjective) {
        super.onObjectiveAdded(scoreboardobjective);
        this.setDirty();
    }

    @Override
    public void onObjectiveChanged(Objective scoreboardobjective) {
        super.onObjectiveChanged(scoreboardobjective);
        if (this.trackedObjectives.contains(scoreboardobjective)) {
            this.broadcastAll(new ClientboundSetObjectivePacket(scoreboardobjective, 2));
        }
        this.setDirty();
    }

    @Override
    public void onObjectiveRemoved(Objective scoreboardobjective) {
        super.onObjectiveRemoved(scoreboardobjective);
        if (this.trackedObjectives.contains(scoreboardobjective)) {
            this.stopTrackingObjective(scoreboardobjective);
        }
        this.setDirty();
    }

    @Override
    public void onTeamAdded(PlayerTeam scoreboardteam) {
        super.onTeamAdded(scoreboardteam);
        this.broadcastAll(ClientboundSetPlayerTeamPacket.createAddOrModifyPacket(scoreboardteam, true));
        this.setDirty();
    }

    @Override
    public void onTeamChanged(PlayerTeam scoreboardteam) {
        super.onTeamChanged(scoreboardteam);
        this.broadcastAll(ClientboundSetPlayerTeamPacket.createAddOrModifyPacket(scoreboardteam, false));
        this.updateTeamWaypoints(scoreboardteam);
        this.setDirty();
    }

    @Override
    public void onTeamRemoved(PlayerTeam scoreboardteam) {
        super.onTeamRemoved(scoreboardteam);
        this.broadcastAll(ClientboundSetPlayerTeamPacket.createRemovePacket(scoreboardteam));
        this.updateTeamWaypoints(scoreboardteam);
        this.setDirty();
    }

    public void addDirtyListener(Runnable runnable) {
        this.dirtyListeners.add(runnable);
    }

    protected void setDirty() {
        for (Runnable runnable : this.dirtyListeners) {
            runnable.run();
        }
    }

    public List<Packet<?>> getStartTrackingPackets(Objective scoreboardobjective) {
        ArrayList list = Lists.newArrayList();
        list.add(new ClientboundSetObjectivePacket(scoreboardobjective, 0));
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.getDisplayObjective(displayslot) != scoreboardobjective) continue;
            list.add(new ClientboundSetDisplayObjectivePacket(displayslot, scoreboardobjective));
        }
        for (PlayerScoreEntry playerscoreentry : this.listPlayerScores(scoreboardobjective)) {
            list.add(new ClientboundSetScorePacket(playerscoreentry.owner(), scoreboardobjective.getName(), playerscoreentry.value(), Optional.ofNullable(playerscoreentry.display()), Optional.ofNullable(playerscoreentry.numberFormatOverride())));
        }
        return list;
    }

    public void startTrackingObjective(Objective scoreboardobjective) {
        List<Packet<?>> list = this.getStartTrackingPackets(scoreboardobjective);
        for (ServerPlayer entityplayer : this.server.getPlayerList().getPlayers()) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : list) {
                entityplayer.connection.send(packet);
            }
        }
        this.trackedObjectives.add(scoreboardobjective);
    }

    public List<Packet<?>> getStopTrackingPackets(Objective scoreboardobjective) {
        ArrayList list = Lists.newArrayList();
        list.add(new ClientboundSetObjectivePacket(scoreboardobjective, 1));
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.getDisplayObjective(displayslot) != scoreboardobjective) continue;
            list.add(new ClientboundSetDisplayObjectivePacket(displayslot, scoreboardobjective));
        }
        return list;
    }

    public void stopTrackingObjective(Objective scoreboardobjective) {
        List<Packet<?>> list = this.getStopTrackingPackets(scoreboardobjective);
        for (ServerPlayer entityplayer : this.server.getPlayerList().getPlayers()) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : list) {
                entityplayer.connection.send(packet);
            }
        }
        this.trackedObjectives.remove(scoreboardobjective);
    }

    public int getObjectiveDisplaySlotCount(Objective scoreboardobjective) {
        int i = 0;
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.getDisplayObjective(displayslot) != scoreboardobjective) continue;
            ++i;
        }
        return i;
    }

    private ScoreboardSaveData createData() {
        ScoreboardSaveData persistentscoreboard = new ScoreboardSaveData(this);
        Objects.requireNonNull(persistentscoreboard);
        this.addDirtyListener(persistentscoreboard::setDirty);
        return persistentscoreboard;
    }

    private ScoreboardSaveData createData(ScoreboardSaveData.Packed persistentscoreboard_a) {
        ScoreboardSaveData persistentscoreboard = this.createData();
        persistentscoreboard.loadFrom(persistentscoreboard_a);
        return persistentscoreboard;
    }

    private void updatePlayerWaypoint(String s) {
        ServerLevel worldserver;
        ServerPlayer entityplayer = this.server.getPlayerList().getPlayerByName(s);
        if (entityplayer != null && (worldserver = entityplayer.level()) instanceof ServerLevel) {
            worldserver.getWaypointManager().remakeConnections(entityplayer);
        }
    }

    private void updateTeamWaypoints(PlayerTeam scoreboardteam) {
        for (ServerLevel worldserver : this.server.getAllLevels()) {
            scoreboardteam.getPlayers().stream().map(s -> this.server.getPlayerList().getPlayerByName((String)s)).filter(Objects::nonNull).forEach(entityplayer -> worldserver.getWaypointManager().remakeConnections((WaypointTransmitter)entityplayer));
        }
    }

    private void broadcastAll(Packet packet) {
        for (ServerPlayer entityplayer : this.server.getPlayerList().players) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            entityplayer.connection.send(packet);
        }
    }
}

