/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.GameRules;

public class GameRuleCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher, CommandBuildContext commandbuildcontext) {
        final LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)Commands.literal("gamerule").requires(Commands.hasPermission(2));
        new GameRules(commandbuildcontext.enabledFeatures()).visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            @Override
            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> gamerules_gamerulekey, GameRules.Type<T> gamerules_gameruledefinition) {
                LiteralArgumentBuilder<CommandSourceStack> literalargumentbuilder1 = Commands.literal(gamerules_gamerulekey.getId());
                literalargumentbuilder.then(((LiteralArgumentBuilder)literalargumentbuilder1.executes(commandcontext -> GameRuleCommand.queryRule((CommandSourceStack)commandcontext.getSource(), gamerules_gamerulekey))).then(gamerules_gameruledefinition.createArgument("value").executes(commandcontext -> GameRuleCommand.setRule((CommandContext<CommandSourceStack>)commandcontext, gamerules_gamerulekey))));
            }
        });
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)literalargumentbuilder);
    }

    static <T extends GameRules.Value<T>> int setRule(CommandContext<CommandSourceStack> commandcontext, GameRules.Key<T> gamerules_gamerulekey) {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)commandcontext.getSource();
        Object t0 = commandlistenerwrapper.getLevel().getGameRules().getRule(gamerules_gamerulekey);
        ((GameRules.Value)t0).setFromArgument(commandcontext, "value");
        commandlistenerwrapper.getServer().onGameRuleChanged(gamerules_gamerulekey.getId(), (GameRules.Value<?>)t0);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.gamerule.set", gamerules_gamerulekey.getId(), t0.toString()), true);
        return ((GameRules.Value)t0).getCommandResult();
    }

    static <T extends GameRules.Value<T>> int queryRule(CommandSourceStack commandlistenerwrapper, GameRules.Key<T> gamerules_gamerulekey) {
        Object t0 = commandlistenerwrapper.getLevel().getGameRules().getRule(gamerules_gamerulekey);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.gamerule.query", gamerules_gamerulekey.getId(), t0.toString()), false);
        return ((GameRules.Value)t0).getCommandResult();
    }
}

