/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportType;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerEntityGetter;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.ProgressListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.LevelDebugSynchronizers;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalForcer;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapIndex;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTicks;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R6.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R6.util.WorldUUID;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.map.MapView;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;

public class ServerLevel
extends Level
implements ServerEntityGetter,
WorldGenLevel {
    public static final BlockPos END_SPAWN_POINT = new BlockPos(100, 50, 0);
    public static final IntProvider RAIN_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider RAIN_DURATION = UniformInt.of(12000, 24000);
    private static final IntProvider THUNDER_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider THUNDER_DURATION = UniformInt.of(3600, 15600);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EMPTY_TIME_NO_TICK = 300;
    private static final int MAX_SCHEDULED_TICKS_PER_TICK = 65536;
    final List<ServerPlayer> players = Lists.newArrayList();
    private final ServerChunkCache chunkSource;
    private final MinecraftServer server;
    public final PrimaryLevelData J;
    final EntityTickList entityTickList = new EntityTickList();
    private final ServerWaypointManager waypointManager;
    public final PersistentEntitySectionManager<Entity> entityManager;
    private final GameEventDispatcher gameEventDispatcher;
    public boolean noSave;
    private final SleepStatus sleepStatus;
    private int emptyTime;
    private final PortalForcer portalForcer;
    private final LevelTicks<Block> blockTicks = new LevelTicks(this::isPositionTickingWithEntitiesLoaded);
    private final LevelTicks<Fluid> fluidTicks = new LevelTicks(this::isPositionTickingWithEntitiesLoaded);
    private final PathTypeCache pathTypesByPosCache = new PathTypeCache();
    final Set<Mob> navigatingMobs = new ObjectOpenHashSet();
    volatile boolean isUpdatingNavigations;
    protected final Raids raids;
    private final ObjectLinkedOpenHashSet<BlockEventData> blockEvents = new ObjectLinkedOpenHashSet();
    private final List<BlockEventData> blockEventsToReschedule = new ArrayList<BlockEventData>(64);
    private boolean handlingTick;
    private final List<CustomSpawner> customSpawners;
    @Nullable
    private EndDragonFight dragonFight;
    final Int2ObjectMap<EnderDragonPart> dragonParts = new Int2ObjectOpenHashMap();
    private final StructureManager structureManager;
    private final StructureCheck structureCheck;
    private final boolean tickTime;
    private final RandomSequences randomSequences;
    final LevelDebugSynchronizers debugSynchronizers = new LevelDebugSynchronizers(this);
    public final LevelStorageSource.LevelStorageAccess convertable;
    public final UUID uuid;

    public LevelChunk getChunkIfLoaded(int x, int z) {
        return this.chunkSource.getChunk(x, z, false);
    }

    @Override
    public ResourceKey<LevelStem> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public ServerLevel(MinecraftServer minecraftserver, Executor executor, LevelStorageSource.LevelStorageAccess convertable_conversionsession, PrimaryLevelData iworlddataserver, ResourceKey<Level> resourcekey, LevelStem worlddimension, boolean flag, long i, List<CustomSpawner> list, boolean flag1, @Nullable RandomSequences randomsequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, minecraftserver.registryAccess(), worlddimension.type(), false, flag, i, minecraftserver.getMaxChainedNeighborUpdates(), gen, biomeProvider, env);
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.levelDirectory.path().toFile());
        this.tickTime = flag1;
        this.server = minecraftserver;
        this.customSpawners = list;
        this.J = iworlddataserver;
        ChunkGenerator chunkgenerator = worlddimension.generator();
        this.J.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, (Registry<Biome>)this.server.registryAccess().lookupOrThrow(Registries.BIOME));
            if (chunkgenerator instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator cga = (NoiseBasedChunkGenerator)chunkgenerator;
                chunkgenerator = new NoiseBasedChunkGenerator((BiomeSource)worldChunkManager, cga.settings);
            } else if (chunkgenerator instanceof FlatLevelSource) {
                FlatLevelSource cpf = (FlatLevelSource)chunkgenerator;
                chunkgenerator = new FlatLevelSource(cpf.settings(), worldChunkManager);
            }
        }
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.forceSynchronousWrites();
        DataFixer datafixer = minecraftserver.getFixerUpper();
        EntityStorage entitypersistentstorage = new EntityStorage(new SimpleRegionStorage(new RegionStorageInfo(convertable_conversionsession.getLevelId(), resourcekey, "entities"), convertable_conversionsession.getDimensionPath(resourcekey).resolve("entities"), datafixer, flag2, DataFixTypes.ENTITY_CHUNK), this, minecraftserver);
        this.entityManager = new PersistentEntitySectionManager<Entity>(Entity.class, new EntityCallbacks(), entitypersistentstorage);
        StructureTemplateManager structuretemplatemanager = minecraftserver.getStructureManager();
        int j = this.spigotConfig.viewDistance;
        int k = this.spigotConfig.simulationDistance;
        PersistentEntitySectionManager<Entity> persistententitysectionmanager = this.entityManager;
        Objects.requireNonNull(this.entityManager);
        this.chunkSource = new ServerChunkCache(this, convertable_conversionsession, datafixer, structuretemplatemanager, executor, chunkgenerator, j, k, flag2, persistententitysectionmanager::updateChunkStatus, () -> minecraftserver.overworld().getDataStorage());
        this.chunkSource.getGeneratorState().ensureStructuresGenerated();
        this.portalForcer = new PortalForcer(this);
        this.updateSkyBrightness();
        this.prepareWeather();
        this.raids = this.getDataStorage().computeIfAbsent(Raids.getType(this.dimensionTypeRegistration()));
        if (!minecraftserver.isSingleplayer()) {
            iworlddataserver.setGameType(minecraftserver.getDefaultGameType());
        }
        long l = minecraftserver.getWorldData().worldGenOptions().seed();
        this.structureCheck = new StructureCheck(this.chunkSource.chunkScanner(), this.registryAccess(), minecraftserver.getStructureManager(), resourcekey, chunkgenerator, this.chunkSource.randomState(), this, chunkgenerator.getBiomeSource(), l, datafixer);
        this.structureManager = new StructureManager(this, this.J.worldGenOptions(), this.structureCheck);
        this.dragonFight = this.dimension() == Level.END && this.dimensionTypeRegistration().is(BuiltinDimensionTypes.END) || env == World.Environment.THE_END ? new EndDragonFight(this, this.J.worldGenOptions().seed(), this.J.endDragonFightData()) : null;
        this.sleepStatus = new SleepStatus();
        this.gameEventDispatcher = new GameEventDispatcher(this);
        this.randomSequences = Objects.requireNonNullElseGet(randomsequences, () -> this.getDataStorage().computeIfAbsent(RandomSequences.TYPE));
        this.waypointManager = new ServerWaypointManager();
        this.getCraftServer().addWorld(this.getWorld());
    }

    @Deprecated
    @VisibleForTesting
    public void setDragonFight(@Nullable EndDragonFight enderdragonbattle) {
        this.dragonFight = enderdragonbattle;
    }

    public void setWeatherParameters(int i, int j, boolean flag, boolean flag1) {
        this.J.setClearWeatherTime(i);
        this.J.setRainTime(j);
        this.J.setThunderTime(j);
        this.J.setRaining(flag);
        this.J.setThundering(flag1);
    }

    @Override
    public Holder<Biome> getUncachedNoiseBiome(int i, int j, int k) {
        return this.getChunkSource().getGenerator().getBiomeSource().getNoiseBiome(i, j, k, this.getChunkSource().randomState().sampler());
    }

    public StructureManager structureManager() {
        return this.structureManager;
    }

    public void tick(BooleanSupplier booleansupplier) {
        int i;
        ProfilerFiller gameprofilerfiller = Profiler.get();
        this.handlingTick = true;
        TickRateManager tickratemanager = this.tickRateManager();
        boolean flag = tickratemanager.runsNormally();
        if (flag) {
            gameprofilerfiller.push("world border");
            this.getWorldBorder().tick();
            gameprofilerfiller.popPush("weather");
            this.advanceWeatherCycle();
            gameprofilerfiller.pop();
        }
        if (this.sleepStatus.areEnoughSleeping(i = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE)) && this.sleepStatus.areEnoughDeepSleeping(i, this.players)) {
            TimeSkipEvent event = null;
            if (this.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
                long j = this.levelData.getDayTime() + 24000L;
                event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j - j % 24000L - this.getDayTime());
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.setDayTime(this.getDayTime() + event.getSkipAmount());
                }
            }
            if (event == null || !event.isCancelled()) {
                this.wakeUpAllPlayers();
            }
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE) && this.isRaining()) {
                this.resetWeatherCycle();
            }
        }
        this.updateSkyBrightness();
        if (flag) {
            this.tickTime();
        }
        gameprofilerfiller.push("tickPending");
        this.timings.doTickPending.startTiming();
        if (!this.isDebug() && flag) {
            long k = this.getGameTime();
            gameprofilerfiller.push("blockTicks");
            this.blockTicks.tick(k, 65536, this::tickBlock);
            gameprofilerfiller.popPush("fluidTicks");
            this.fluidTicks.tick(k, 65536, this::tickFluid);
            gameprofilerfiller.pop();
        }
        this.timings.doTickPending.stopTiming();
        gameprofilerfiller.popPush("raid");
        if (flag) {
            this.raids.tick(this);
        }
        gameprofilerfiller.popPush("chunkSource");
        this.getChunkSource().tick(booleansupplier, true);
        gameprofilerfiller.popPush("blockEvents");
        if (flag) {
            this.timings.doSounds.startTiming();
            this.runBlockEvents();
            this.timings.doSounds.stopTiming();
        }
        this.handlingTick = false;
        gameprofilerfiller.pop();
        boolean flag1 = true;
        if (flag1) {
            this.resetEmptyTime();
        }
        if (flag) {
            ++this.emptyTime;
        }
        if (this.emptyTime < 300) {
            gameprofilerfiller.push("entities");
            this.timings.tickEntities.startTiming();
            if (this.dragonFight != null && flag) {
                gameprofilerfiller.push("dragonFight");
                this.dragonFight.tick();
                gameprofilerfiller.pop();
            }
            ActivationRange.activateEntities(this);
            this.timings.entityTick.startTiming();
            this.entityTickList.forEach(entity -> {
                if (!entity.isRemoved() && !tickratemanager.isEntityFrozen((Entity)entity)) {
                    gameprofilerfiller.push("checkDespawn");
                    entity.checkDespawn();
                    gameprofilerfiller.pop();
                    if (entity instanceof ServerPlayer || this.chunkSource.chunkMap.getDistanceManager().inEntityTickingRange(entity.chunkPosition().toLong())) {
                        Entity entity1 = entity.getVehicle();
                        if (entity1 != null) {
                            if (!entity1.isRemoved() && entity1.hasPassenger((Entity)entity)) {
                                return;
                            }
                            entity.stopRiding();
                        }
                        gameprofilerfiller.push("tick");
                        this.guardEntityTick(this::tickNonPassenger, entity);
                        gameprofilerfiller.pop();
                    }
                }
            });
            this.timings.entityTick.stopTiming();
            this.timings.tickEntities.stopTiming();
            gameprofilerfiller.popPush("blockEntities");
            this.tickBlockEntities();
            gameprofilerfiller.pop();
        }
        gameprofilerfiller.push("entityManagement");
        this.entityManager.tick();
        gameprofilerfiller.pop();
        gameprofilerfiller.push("debugSynchronizers");
        if (this.debugSynchronizers.hasAnySubscriberFor(DebugSubscriptions.NEIGHBOR_UPDATES)) {
            this.neighborUpdater.setDebugListener(blockposition -> this.debugSynchronizers.broadcastEventToTracking((BlockPos)blockposition, DebugSubscriptions.NEIGHBOR_UPDATES, blockposition));
        } else {
            this.neighborUpdater.setDebugListener(null);
        }
        this.debugSynchronizers.tick(this.server.debugSubscribers());
        gameprofilerfiller.pop();
    }

    @Override
    public boolean shouldTickBlocksAt(long i) {
        return this.chunkSource.chunkMap.getDistanceManager().inBlockTickingRange(i);
    }

    protected void tickTime() {
        if (this.tickTime) {
            long i = this.levelData.getGameTime() + 1L;
            this.J.setGameTime(i);
            Profiler.get().push("scheduledFunctions");
            this.J.getScheduledEvents().tick(this.server, i);
            Profiler.get().pop();
            if (this.J.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
                this.setDayTime(this.levelData.getDayTime() + 1L);
            }
        }
    }

    public void setDayTime(long i) {
        this.J.setDayTime(i);
    }

    public void tickCustomSpawners(boolean flag) {
        for (CustomSpawner mobspawner : this.customSpawners) {
            mobspawner.tick(this, flag);
        }
    }

    private void wakeUpAllPlayers() {
        this.sleepStatus.removeAllSleepers();
        this.players.stream().filter(LivingEntity::isSleeping).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.stopSleepInBed(false, false));
    }

    public void tickChunk(LevelChunk chunk, int i) {
        ChunkPos chunkcoordintpair = chunk.getPos();
        int j = chunkcoordintpair.getMinBlockX();
        int k = chunkcoordintpair.getMinBlockZ();
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("iceandsnow");
        for (int l = 0; l < i; ++l) {
            if (this.random.nextInt(48) != 0) continue;
            this.tickPrecipitation(this.getBlockRandomPos(j, 0, k, 15));
        }
        gameprofilerfiller.popPush("tickBlocks");
        if (i > 0) {
            LevelChunkSection[] achunksection = chunk.getSections();
            for (int i1 = 0; i1 < achunksection.length; ++i1) {
                LevelChunkSection chunksection = achunksection[i1];
                if (!chunksection.isRandomlyTicking()) continue;
                int j1 = chunk.getSectionYFromSectionIndex(i1);
                int k1 = SectionPos.sectionToBlockCoord(j1);
                for (int l1 = 0; l1 < i; ++l1) {
                    FluidState fluid;
                    BlockPos blockposition = this.getBlockRandomPos(j, k1, k, 15);
                    gameprofilerfiller.push("randomTick");
                    BlockState iblockdata = chunksection.getBlockState(blockposition.getX() - j, blockposition.getY() - k1, blockposition.getZ() - k);
                    if (iblockdata.isRandomlyTicking()) {
                        iblockdata.randomTick(this, blockposition, this.random);
                    }
                    if ((fluid = iblockdata.getFluidState()).isRandomlyTicking()) {
                        fluid.randomTick(this, blockposition, this.random);
                    }
                    gameprofilerfiller.pop();
                }
            }
        }
        gameprofilerfiller.pop();
    }

    public void tickThunder(LevelChunk chunk) {
        BlockPos blockposition;
        ChunkPos chunkcoordintpair = chunk.getPos();
        boolean flag = this.isRaining();
        int i = chunkcoordintpair.getMinBlockX();
        int j = chunkcoordintpair.getMinBlockZ();
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("thunder");
        if (flag && this.isThundering() && this.spigotConfig.thunderChance > 0 && this.random.nextInt(this.spigotConfig.thunderChance) == 0 && this.isRainingAt(blockposition = this.findLightningTargetAround(this.getBlockRandomPos(i, 0, j, 15)))) {
            LightningBolt entitylightning;
            SkeletonHorse entityhorseskeleton;
            boolean flag1;
            DifficultyInstance difficultydamagescaler = this.getCurrentDifficultyAt(blockposition);
            boolean bl = flag1 = this.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && this.random.nextDouble() < (double)difficultydamagescaler.getEffectiveDifficulty() * 0.01 && !this.getBlockState(blockposition.below()).is(BlockTags.LIGHTNING_RODS);
            if (flag1 && (entityhorseskeleton = EntityType.SKELETON_HORSE.create(this, EntitySpawnReason.EVENT)) != null) {
                entityhorseskeleton.setTrap(true);
                entityhorseskeleton.setAge(0);
                entityhorseskeleton.setPos(blockposition.getX(), blockposition.getY(), blockposition.getZ());
                this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            }
            if ((entitylightning = EntityType.LIGHTNING_BOLT.create(this, EntitySpawnReason.EVENT)) != null) {
                entitylightning.snapTo(Vec3.atBottomCenterOf(blockposition));
                entitylightning.setVisualOnly(flag1);
                this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        gameprofilerfiller.pop();
    }

    @VisibleForTesting
    public void tickPrecipitation(BlockPos blockposition) {
        BlockPos blockposition1 = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockposition);
        BlockPos blockposition2 = blockposition1.below();
        Biome biomebase = this.getBiome(blockposition1).value();
        if (biomebase.shouldFreeze(this, blockposition2)) {
            CraftEventFactory.handleBlockFormEvent((Level)this, blockposition2, Blocks.ICE.defaultBlockState(), null);
        }
        if (this.isRaining()) {
            Biome.Precipitation biomebase_precipitation;
            int i = this.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
            if (i > 0 && biomebase.shouldSnow(this, blockposition1)) {
                BlockState iblockdata = this.getBlockState(blockposition1);
                if (iblockdata.is(Blocks.SNOW)) {
                    int j = iblockdata.getValue(SnowLayerBlock.LAYERS);
                    if (j < Math.min(i, 8)) {
                        BlockState iblockdata1 = (BlockState)iblockdata.setValue(SnowLayerBlock.LAYERS, j + 1);
                        Block.pushEntitiesUp(iblockdata, iblockdata1, this, blockposition1);
                        CraftEventFactory.handleBlockFormEvent((Level)this, blockposition1, iblockdata1, null);
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent((Level)this, blockposition1, Blocks.SNOW.defaultBlockState(), null);
                }
            }
            if ((biomebase_precipitation = biomebase.getPrecipitationAt(blockposition2, this.getSeaLevel())) != Biome.Precipitation.NONE) {
                BlockState iblockdata2 = this.getBlockState(blockposition2);
                iblockdata2.getBlock().handlePrecipitation(iblockdata2, this, blockposition2, biomebase_precipitation);
            }
        }
    }

    private Optional<BlockPos> findLightningRod(BlockPos blockposition) {
        Optional<BlockPos> optional = this.getPoiManager().findClosest(holder -> holder.is(PoiTypes.LIGHTNING_ROD), blockposition1 -> blockposition1.getY() == this.getHeight(Heightmap.Types.WORLD_SURFACE, blockposition1.getX(), blockposition1.getZ()) - 1, blockposition, 128, PoiManager.Occupancy.ANY);
        return optional.map(blockposition1 -> blockposition1.above(1));
    }

    protected BlockPos findLightningTargetAround(BlockPos blockposition) {
        BlockPos blockposition1 = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockposition);
        Optional<BlockPos> optional = this.findLightningRod(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AABB axisalignedbb = AABB.encapsulatingFullBlocks(blockposition1, blockposition1.atY(this.getMaxY() + 1)).inflate(3.0);
        List<LivingEntity> list = this.getEntitiesOfClass(LivingEntity.class, axisalignedbb, entityliving -> entityliving != null && entityliving.isAlive() && this.canSeeSky(entityliving.blockPosition()));
        if (!list.isEmpty()) {
            return list.get(this.random.nextInt(list.size())).blockPosition();
        }
        if (blockposition1.getY() == this.getMinY() - 1) {
            blockposition1 = blockposition1.above(2);
        }
        return blockposition1;
    }

    public boolean isHandlingTick() {
        return this.handlingTick;
    }

    public boolean canSleepThroughNights() {
        return this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE) <= 100;
    }

    private void announceSleepStatus() {
        if (this.canSleepThroughNights() && (!this.getServer().isSingleplayer() || this.getServer().isPublished())) {
            int i = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE);
            MutableComponent ichatbasecomponent = this.sleepStatus.areEnoughSleeping(i) ? Component.translatable("sleep.skipping_night") : Component.translatable("sleep.players_sleeping", this.sleepStatus.amountSleeping(), this.sleepStatus.sleepersNeeded(i));
            for (ServerPlayer entityplayer : this.players) {
                entityplayer.displayClientMessage(ichatbasecomponent, true);
            }
        }
    }

    public void updateSleepingPlayerList() {
        if (!this.players.isEmpty() && this.sleepStatus.update(this.players)) {
            this.announceSleepStatus();
        }
    }

    @Override
    public ServerScoreboard getScoreboard() {
        return this.server.getScoreboard();
    }

    public ServerWaypointManager getWaypointManager() {
        return this.waypointManager;
    }

    private void advanceWeatherCycle() {
        int idx;
        boolean flag = this.isRaining();
        if (this.dimensionType().hasSkyLight()) {
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE)) {
                int i = this.J.getClearWeatherTime();
                int j = this.J.getThunderTime();
                int k = this.J.getRainTime();
                boolean flag1 = this.levelData.isThundering();
                boolean flag2 = this.levelData.isRaining();
                if (i > 0) {
                    --i;
                    j = flag1 ? 0 : 1;
                    k = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j > 0) {
                        if (--j == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j = flag1 ? THUNDER_DURATION.sample(this.random) : THUNDER_DELAY.sample(this.random);
                    }
                    if (k > 0) {
                        if (--k == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k = flag2 ? RAIN_DURATION.sample(this.random) : RAIN_DELAY.sample(this.random);
                    }
                }
                this.J.setThunderTime(j);
                this.J.setRainTime(k);
                this.J.setClearWeatherTime(i);
                this.J.setThundering(flag1);
                this.J.setRaining(flag2);
            }
            this.oThunderLevel = this.thunderLevel;
            this.thunderLevel = this.levelData.isThundering() ? (this.thunderLevel += 0.01f) : (this.thunderLevel -= 0.01f);
            this.thunderLevel = Mth.clamp(this.thunderLevel, 0.0f, 1.0f);
            this.oRainLevel = this.rainLevel;
            this.rainLevel = this.levelData.isRaining() ? (this.rainLevel += 0.01f) : (this.rainLevel -= 0.01f);
            this.rainLevel = Mth.clamp(this.rainLevel, 0.0f, 1.0f);
        }
        for (idx = 0; idx < this.players.size(); ++idx) {
            if (this.players.get(idx).level() != this) continue;
            this.players.get(idx).tickWeather();
        }
        if (flag != this.isRaining()) {
            for (idx = 0; idx < this.players.size(); ++idx) {
                if (this.players.get(idx).level() != this) continue;
                this.players.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (idx = 0; idx < this.players.size(); ++idx) {
            if (this.players.get(idx).level() != this) continue;
            this.players.get(idx).updateWeather(this.oRainLevel, this.rainLevel, this.oThunderLevel, this.thunderLevel);
        }
    }

    @VisibleForTesting
    public void resetWeatherCycle() {
        this.J.setRaining(false);
        if (!this.J.isRaining()) {
            this.J.setRainTime(0);
        }
        this.J.setThundering(false);
        if (!this.J.isThundering()) {
            this.J.setThunderTime(0);
        }
    }

    public void resetEmptyTime() {
        this.emptyTime = 0;
    }

    private void tickFluid(BlockPos blockposition, Fluid fluidtype) {
        BlockState iblockdata = this.getBlockState(blockposition);
        FluidState fluid = iblockdata.getFluidState();
        if (fluid.is(fluidtype)) {
            fluid.tick(this, blockposition, iblockdata);
        }
    }

    private void tickBlock(BlockPos blockposition, Block block) {
        BlockState iblockdata = this.getBlockState(blockposition);
        if (iblockdata.is(block)) {
            iblockdata.tick(this, blockposition, this.random);
        }
    }

    public void tickNonPassenger(Entity entity) {
        if (!ActivationRange.checkIfActive(entity)) {
            ++entity.tickCount;
            entity.inactiveTick();
            return;
        }
        entity.tickTimer.startTiming();
        entity.setOldPosAndRot();
        ProfilerFiller gameprofilerfiller = Profiler.get();
        ++entity.tickCount;
        gameprofilerfiller.push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()).toString());
        gameprofilerfiller.incrementCounter("tickNonPassenger");
        entity.tick();
        entity.postTick();
        gameprofilerfiller.pop();
        for (Entity entity1 : entity.getPassengers()) {
            this.tickPassenger(entity, entity1);
        }
        entity.tickTimer.stopTiming();
    }

    private void tickPassenger(Entity entity, Entity entity1) {
        if (!entity1.isRemoved() && entity1.getVehicle() == entity) {
            if (entity1 instanceof Player || this.entityTickList.contains(entity1)) {
                entity1.setOldPosAndRot();
                ++entity1.tickCount;
                ProfilerFiller gameprofilerfiller = Profiler.get();
                gameprofilerfiller.push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(entity1.getType()).toString());
                gameprofilerfiller.incrementCounter("tickPassenger");
                entity1.rideTick();
                entity1.postTick();
                gameprofilerfiller.pop();
                for (Entity entity2 : entity1.getPassengers()) {
                    this.tickPassenger(entity1, entity2);
                }
            }
        } else {
            entity1.stopRiding();
        }
    }

    public void updateNeighboursOnBlockSet(BlockPos blockposition, BlockState iblockdata) {
        boolean flag;
        BlockState iblockdata1 = this.getBlockState(blockposition);
        Block block = iblockdata1.getBlock();
        boolean bl = flag = !iblockdata.is(block);
        if (flag) {
            iblockdata.affectNeighborsAfterRemoval(this, blockposition, false);
        }
        this.updateNeighborsAt(blockposition, iblockdata1.getBlock());
        if (iblockdata1.hasAnalogOutputSignal()) {
            this.updateNeighbourForOutputSignal(blockposition, block);
        }
    }

    @Override
    public boolean mayInteract(Entity entity, BlockPos blockposition) {
        Player entityhuman;
        if (entity instanceof Player && (this.server.isUnderSpawnProtection(this, blockposition, entityhuman = (Player)entity) || !this.getWorldBorder().isWithinBounds(blockposition))) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    public void save(@Nullable ProgressListener iprogressupdate, boolean flag, boolean flag1) {
        ServerChunkCache chunkproviderserver = this.getChunkSource();
        if (!flag1) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (iprogressupdate != null) {
                iprogressupdate.progressStartNoAbort(Component.translatable("menu.savingLevel"));
            }
            this.saveLevelData(flag);
            if (iprogressupdate != null) {
                iprogressupdate.progressStage(Component.translatable("menu.savingChunks"));
            }
            chunkproviderserver.save(flag);
            if (flag) {
                this.entityManager.saveAll();
            } else {
                this.entityManager.autoSave();
            }
        }
        this.J.setCustomBossEvents(this.server.getCustomBossEvents().save(this.registryAccess()));
        this.convertable.saveDataTag(this.server.registryAccess(), this.J, this.server.getPlayerList().getSingleplayerData());
    }

    private void saveLevelData(boolean flag) {
        if (this.dragonFight != null) {
            this.J.setEndDragonFightData(this.dragonFight.saveData());
        }
        DimensionDataStorage worldpersistentdata = this.getChunkSource().getDataStorage();
        if (flag) {
            worldpersistentdata.saveAndJoin();
        } else {
            worldpersistentdata.scheduleSave();
        }
    }

    public <T extends Entity> List<? extends T> getEntities(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.getEntities(entitytypetest, predicate, list);
        return list;
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list) {
        this.getEntities(entitytypetest, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list, int i) {
        this.getEntities().get(entitytypetest, entity -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i) {
                    return AbortableIterationConsumer.Continuation.ABORT;
                }
            }
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
    }

    public List<? extends EnderDragon> getDragons() {
        return this.getEntities(EntityType.ENDER_DRAGON, LivingEntity::isAlive);
    }

    public List<ServerPlayer> getPlayers(Predicate<? super ServerPlayer> predicate) {
        return this.getPlayers(predicate, Integer.MAX_VALUE);
    }

    public List<ServerPlayer> getPlayers(Predicate<? super ServerPlayer> predicate, int i) {
        ArrayList list = Lists.newArrayList();
        for (ServerPlayer entityplayer : this.players) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
            if (list.size() < i) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public ServerPlayer getRandomPlayer() {
        List<ServerPlayer> list = this.getPlayers(LivingEntity::isAlive);
        return list.isEmpty() ? null : list.get(this.random.nextInt(list.size()));
    }

    @Override
    public boolean addFreshEntity(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean addWithUUID(Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void addDuringTeleport(Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            this.addPlayer(entityplayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void addNewPlayer(ServerPlayer entityplayer) {
        this.addPlayer(entityplayer);
    }

    public void addRespawnedPlayer(ServerPlayer entityplayer) {
        this.addPlayer(entityplayer);
    }

    private void addPlayer(ServerPlayer entityplayer) {
        Entity entity = this.getEntity(entityplayer.getUUID());
        if (entity != null) {
            LOGGER.warn("Force-added player with duplicate UUID {}", (Object)entityplayer.getUUID());
            entity.unRide();
            this.removePlayerImmediately((ServerPlayer)entity, Entity.RemovalReason.DISCARDED);
        }
        this.entityManager.addNewEntity(entityplayer);
    }

    private boolean addEntity(Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        AsyncCatcher.catchOp("entity add");
        if (entity.isRemoved()) {
            return false;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.entityManager.addNewEntity(entity);
    }

    public boolean tryAddFreshEntityWithPassengers(Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        Stream<UUID> stream = entity.getSelfAndPassengers().map(Entity::getUUID);
        PersistentEntitySectionManager<Entity> persistententitysectionmanager = this.entityManager;
        Objects.requireNonNull(this.entityManager);
        if (stream.anyMatch(persistententitysectionmanager::isLoaded)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void unload(LevelChunk chunk) {
        for (BlockEntity tileentity : chunk.getBlockEntities().values()) {
            if (!(tileentity instanceof Container)) continue;
            for (HumanEntity h : Lists.newArrayList(((Container)((Object)tileentity)).getViewers())) {
                h.closeInventory();
            }
        }
        chunk.clearAllBlockEntities();
        chunk.unregisterTickContainerFromLevel(this);
        this.debugSynchronizers.dropChunk(chunk.getPos());
    }

    public void removePlayerImmediately(ServerPlayer entityplayer, Entity.RemovalReason entity_removalreason) {
        entityplayer.remove(entity_removalreason, null);
    }

    public boolean strikeLightning(Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.addFreshEntity(entitylightning);
    }

    @Override
    public void destroyBlockProgress(int i, BlockPos blockposition, int j) {
        Player entityhuman = null;
        Entity entity = this.getEntity(i);
        if (entity instanceof Player) {
            entityhuman = (Player)entity;
        }
        for (ServerPlayer entityplayer : this.server.getPlayerList().getPlayers()) {
            if (entityplayer == null || entityplayer.level() != this || entityplayer.getId() == i) continue;
            double d0 = (double)blockposition.getX() - entityplayer.getX();
            double d1 = (double)blockposition.getY() - entityplayer.getY();
            double d2 = (double)blockposition.getZ() - entityplayer.getZ();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.connection.send(new ClientboundBlockDestructionPacket(i, blockposition, j));
        }
    }

    @Override
    public void playSeededSound(@Nullable Entity entity, double d0, double d1, double d2, Holder<SoundEvent> holder, SoundSource soundcategory, float f, float f1, long i) {
        Player entityhuman1;
        PlayerList playerlist = this.server.getPlayerList();
        Player entityhuman = entity instanceof Player ? (entityhuman1 = (Player)entity) : null;
        playerlist.broadcast(entityhuman, d0, d1, d2, holder.value().getRange(f), this.dimension(), new ClientboundSoundPacket(holder, soundcategory, d0, d1, d2, f, f1, i));
    }

    @Override
    public void playSeededSound(@Nullable Entity entity, Entity entity1, Holder<SoundEvent> holder, SoundSource soundcategory, float f, float f1, long i) {
        Player entityhuman1;
        PlayerList playerlist = this.server.getPlayerList();
        Player entityhuman = entity instanceof Player ? (entityhuman1 = (Player)entity) : null;
        playerlist.broadcast(entityhuman, entity1.getX(), entity1.getY(), entity1.getZ(), holder.value().getRange(f), this.dimension(), new ClientboundSoundEntityPacket(holder, soundcategory, entity1, f, f1, i));
    }

    @Override
    public void globalLevelEvent(int i, BlockPos blockposition, int j) {
        if (this.getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS)) {
            this.server.getPlayerList().getPlayers().forEach(entityplayer -> {
                Vec3 vec3d;
                if (entityplayer.level() == this) {
                    Vec3 vec3d1 = Vec3.atCenterOf(blockposition);
                    if (entityplayer.distanceToSqr(vec3d1) < (double)Mth.square(32)) {
                        vec3d = vec3d1;
                    } else {
                        Vec3 vec3d2 = vec3d1.subtract(entityplayer.position()).normalize();
                        vec3d = entityplayer.position().add(vec3d2.scale(32.0));
                    }
                } else {
                    vec3d = entityplayer.position();
                }
                entityplayer.connection.send(new ClientboundLevelEventPacket(i, BlockPos.containing(vec3d), j, true));
            });
        } else {
            this.levelEvent(null, i, blockposition, j);
        }
    }

    @Override
    public void levelEvent(@Nullable Entity entity, int i, BlockPos blockposition, int j) {
        Player entityhuman1;
        PlayerList playerlist = this.server.getPlayerList();
        Player entityhuman = entity instanceof Player ? (entityhuman1 = (Player)entity) : null;
        playerlist.broadcast(entityhuman, blockposition.getX(), blockposition.getY(), blockposition.getZ(), 64.0, this.dimension(), new ClientboundLevelEventPacket(i, blockposition, j, false));
    }

    public int getLogicalHeight() {
        return this.dimensionType().logicalHeight();
    }

    @Override
    public void gameEvent(Holder<GameEvent> holder, Vec3 vec3d, GameEvent.Context gameevent_a) {
        this.gameEventDispatcher.post(holder, vec3d, gameevent_a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBlockUpdated(BlockPos blockposition, BlockState iblockdata, BlockState iblockdata1, int i) {
        if (this.isUpdatingNavigations) {
            String s = "recursive call to sendBlockUpdated";
            Util.logAndPauseIfInIde("recursive call to sendBlockUpdated", new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.getChunkSource().blockChanged(blockposition);
        this.pathTypesByPosCache.invalidate(blockposition);
        VoxelShape voxelshape = iblockdata.getCollisionShape(this, blockposition);
        VoxelShape voxelshape1 = iblockdata1.getCollisionShape(this, blockposition);
        if (Shapes.joinIsNotEmpty(voxelshape, voxelshape1, BooleanOp.NOT_SAME)) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<Mob> iterator = this.navigatingMobs.iterator();
            while (iterator.hasNext()) {
                Mob entityinsentient;
                try {
                    entityinsentient = iterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    this.sendBlockUpdated(blockposition, iblockdata, iblockdata1, i);
                    return;
                }
                PathNavigation navigationabstract = entityinsentient.getNavigation();
                if (!navigationabstract.shouldRecomputePath(blockposition)) continue;
                list.add(navigationabstract);
            }
            try {
                this.isUpdatingNavigations = true;
                for (PathNavigation navigationabstract1 : list) {
                    navigationabstract1.recomputePath();
                }
            }
            finally {
                this.isUpdatingNavigations = false;
            }
        }
    }

    @Override
    public void updateNeighborsAt(BlockPos blockposition, Block block) {
        this.updateNeighborsAt(blockposition, block, ExperimentalRedstoneUtils.initialOrientation(this, null, null));
    }

    @Override
    public void updateNeighborsAt(BlockPos blockposition, Block block, @Nullable Orientation orientation) {
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(blockposition, block, null, orientation);
    }

    @Override
    public void updateNeighborsAtExceptFromFacing(BlockPos blockposition, Block block, Direction enumdirection, @Nullable Orientation orientation) {
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(blockposition, block, enumdirection, orientation);
    }

    @Override
    public void neighborChanged(BlockPos blockposition, Block block, @Nullable Orientation orientation) {
        this.neighborUpdater.neighborChanged(blockposition, block, orientation);
    }

    @Override
    public void neighborChanged(BlockState iblockdata, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        this.neighborUpdater.neighborChanged(iblockdata, blockposition, block, orientation, flag);
    }

    @Override
    public void broadcastEntityEvent(Entity entity, byte b0) {
        this.getChunkSource().sendToTrackingPlayersAndSelf(entity, new ClientboundEntityEventPacket(entity, b0));
    }

    @Override
    public void broadcastDamageEvent(Entity entity, DamageSource damagesource) {
        this.getChunkSource().sendToTrackingPlayersAndSelf(entity, new ClientboundDamageEventPacket(entity, damagesource));
    }

    @Override
    public ServerChunkCache getChunkSource() {
        return this.chunkSource;
    }

    @Override
    public void explode(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f, boolean flag, Level.ExplosionInteraction world_a, ParticleOptions particleparam, ParticleOptions particleparam1, WeightedList<ExplosionParticleInfo> weightedlist, Holder<SoundEvent> holder) {
        this.explode0(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f, flag, world_a, particleparam, particleparam1, weightedlist, holder);
    }

    public ServerExplosion explode0(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f, boolean flag, Level.ExplosionInteraction world_a, ParticleOptions particleparam, ParticleOptions particleparam1, WeightedList<ExplosionParticleInfo> weightedlist, Holder<SoundEvent> holder) {
        Explosion.BlockInteraction explosion_effect1 = switch (world_a) {
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> this.getDestroyType(GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.MOB -> this.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) ? this.getDestroyType(GameRules.RULE_MOB_EXPLOSION_DROP_DECAY) : Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.TNT -> this.getDestroyType(GameRules.RULE_TNT_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.TRIGGER -> Explosion.BlockInteraction.TRIGGER_BLOCK;
            case Level.ExplosionInteraction.STANDARD -> Explosion.BlockInteraction.DESTROY;
            default -> throw new MatchException(null, null);
        };
        Vec3 vec3d = new Vec3(d0, d1, d2);
        ServerExplosion serverexplosion = new ServerExplosion(this, entity, damagesource, explosiondamagecalculator, vec3d, f, flag, explosion_effect1);
        int i = serverexplosion.explode();
        if (serverexplosion.wasCanceled) {
            return serverexplosion;
        }
        ParticleOptions particleparam2 = serverexplosion.isSmall() ? particleparam : particleparam1;
        for (ServerPlayer entityplayer : this.players) {
            if (!(entityplayer.distanceToSqr(vec3d) < 4096.0)) continue;
            Optional<Vec3> optional = Optional.ofNullable(serverexplosion.getHitPlayers().get(entityplayer));
            entityplayer.connection.send(new ClientboundExplodePacket(vec3d, f, i, optional, particleparam2, holder, weightedlist));
        }
        return serverexplosion;
    }

    private Explosion.BlockInteraction getDestroyType(GameRules.Key<GameRules.BooleanValue> gamerules_gamerulekey) {
        return this.getGameRules().getBoolean(gamerules_gamerulekey) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    @Override
    public void blockEvent(BlockPos blockposition, Block block, int i, int j) {
        this.blockEvents.add((Object)new BlockEventData(blockposition, block, i, j));
    }

    private void runBlockEvents() {
        this.blockEventsToReschedule.clear();
        while (!this.blockEvents.isEmpty()) {
            BlockEventData blockactiondata = (BlockEventData)this.blockEvents.removeFirst();
            if (this.shouldTickBlocksAt(blockactiondata.pos())) {
                if (!this.doBlockEvent(blockactiondata)) continue;
                this.server.getPlayerList().broadcast(null, blockactiondata.pos().getX(), blockactiondata.pos().getY(), blockactiondata.pos().getZ(), 64.0, this.dimension(), new ClientboundBlockEventPacket(blockactiondata.pos(), blockactiondata.block(), blockactiondata.paramA(), blockactiondata.paramB()));
                continue;
            }
            this.blockEventsToReschedule.add(blockactiondata);
        }
        this.blockEvents.addAll(this.blockEventsToReschedule);
    }

    private boolean doBlockEvent(BlockEventData blockactiondata) {
        BlockState iblockdata = this.getBlockState(blockactiondata.pos());
        return iblockdata.is(blockactiondata.block()) ? iblockdata.triggerEvent(this, blockactiondata.pos(), blockactiondata.paramA(), blockactiondata.paramB()) : false;
    }

    public LevelTicks<Block> getBlockTicks() {
        return this.blockTicks;
    }

    public LevelTicks<Fluid> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    @Nonnull
    public MinecraftServer getServer() {
        return this.server;
    }

    public PortalForcer getPortalForcer() {
        return this.portalForcer;
    }

    public StructureTemplateManager getStructureManager() {
        return this.server.getStructureManager();
    }

    public <T extends ParticleOptions> int sendParticles(T t0, double d0, double d1, double d2, int i, double d3, double d4, double d5, double d6) {
        return this.sendParticlesSource(null, t0, false, false, d0, d1, d2, i, d3, d4, d5, d6);
    }

    public <T extends ParticleOptions> int sendParticles(T t0, boolean flag, boolean flag1, double d0, double d1, double d2, int i, double d3, double d4, double d5, double d6) {
        return this.sendParticlesSource(null, t0, flag, flag1, d0, d1, d2, i, d3, d4, d5, d6);
    }

    public <T extends ParticleOptions> int sendParticlesSource(ServerPlayer sender, T t0, boolean flag, boolean flag1, double d0, double d1, double d2, int i, double d3, double d4, double d5, double d6) {
        ClientboundLevelParticlesPacket packetplayoutworldparticles = new ClientboundLevelParticlesPacket(t0, flag, flag1, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i);
        int j = 0;
        for (int k = 0; k < this.players.size(); ++k) {
            ServerPlayer entityplayer = this.players.get(k);
            if (sender != null && !entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.sendParticles(entityplayer, flag, d0, d1, d2, packetplayoutworldparticles)) continue;
            ++j;
        }
        return j;
    }

    public <T extends ParticleOptions> boolean sendParticles(ServerPlayer entityplayer, T t0, boolean flag, boolean flag1, double d0, double d1, double d2, int i, double d3, double d4, double d5, double d6) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(t0, flag, flag1, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i);
        return this.sendParticles(entityplayer, flag, d0, d1, d2, packet);
    }

    private boolean sendParticles(ServerPlayer entityplayer, boolean flag, double d0, double d1, double d2, Packet<?> packet) {
        if (entityplayer.level() != this) {
            return false;
        }
        BlockPos blockposition = entityplayer.blockPosition();
        if (blockposition.closerToCenterThan(new Vec3(d0, d1, d2), flag ? 512.0 : 32.0)) {
            entityplayer.connection.send(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity getEntity(int i) {
        return this.getEntities().get(i);
    }

    @Override
    @Nullable
    public Entity getEntityInAnyDimension(UUID uuid) {
        Entity entity = this.getEntity(uuid);
        if (entity != null) {
            return entity;
        }
        for (ServerLevel worldserver : this.getServer().getAllLevels()) {
            Entity entity1;
            if (worldserver == this || (entity1 = worldserver.getEntity(uuid)) == null) continue;
            return entity1;
        }
        return null;
    }

    @Override
    @Nullable
    public Player getPlayerInAnyDimension(UUID uuid) {
        return this.getServer().getPlayerList().getPlayer(uuid);
    }

    @Deprecated
    @Nullable
    public Entity getEntityOrPart(int i) {
        Entity entity = this.getEntities().get(i);
        return entity != null ? entity : (Entity)this.dragonParts.get(i);
    }

    @Override
    public Collection<EnderDragonPart> dragonParts() {
        return this.dragonParts.values();
    }

    @Nullable
    public BlockPos findNearestMapStructure(TagKey<Structure> tagkey, BlockPos blockposition, int i, boolean flag) {
        if (!this.J.worldGenOptions().generateStructures()) {
            return null;
        }
        Optional optional = this.registryAccess().lookupOrThrow(Registries.STRUCTURE).get(tagkey);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPos, Holder<Structure>> pair = this.getChunkSource().getGenerator().findNearestMapStructure(this, (HolderSet)optional.get(), blockposition, i, flag);
        return pair != null ? (BlockPos)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPos, Holder<Biome>> findClosestBiome3d(Predicate<Holder<Biome>> predicate, BlockPos blockposition, int i, int j, int k) {
        return this.getChunkSource().getGenerator().getBiomeSource().findClosestBiome3d(blockposition, i, j, k, predicate, this.getChunkSource().randomState().sampler(), this);
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.getDataStorage().computeIfAbsent(WorldBorder.TYPE);
    }

    @Override
    public RecipeManager recipeAccess() {
        return this.server.getRecipeManager();
    }

    @Override
    public TickRateManager tickRateManager() {
        return this.server.tickRateManager();
    }

    @Override
    public boolean noSave() {
        return this.noSave;
    }

    public DimensionDataStorage getDataStorage() {
        return this.getChunkSource().getDataStorage();
    }

    @Override
    @Nullable
    public MapItemSavedData getMapData(MapId mapid) {
        MapItemSavedData worldmap = this.getServer().overworld().getDataStorage().get(MapItemSavedData.type(mapid));
        if (worldmap != null) {
            worldmap.id = mapid;
        }
        return worldmap;
    }

    public void setMapData(MapId mapid, MapItemSavedData worldmap) {
        worldmap.id = mapid;
        MapInitializeEvent event = new MapInitializeEvent((MapView)worldmap.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.getServer().overworld().getDataStorage().set(MapItemSavedData.type(mapid), worldmap);
    }

    public MapId getFreeMapId() {
        return this.getServer().overworld().getDataStorage().computeIfAbsent(MapIndex.TYPE).getNextMapId();
    }

    @Override
    public void setRespawnData(LevelData.RespawnData worlddata_a) {
        this.getServer().setRespawnData(worlddata_a, this);
    }

    @Override
    public LevelData.RespawnData getRespawnData() {
        return this.J.getRespawnData();
    }

    public LongSet getForceLoadedChunks() {
        return this.chunkSource.getForceLoadedChunks();
    }

    public boolean setChunkForced(int i, int j, boolean flag) {
        boolean flag1 = this.chunkSource.updateChunkForced(new ChunkPos(i, j), flag);
        if (flag && flag1) {
            this.getChunk(i, j);
        }
        return flag1;
    }

    public List<ServerPlayer> players() {
        return this.players;
    }

    @Override
    public void updatePOIOnBlockStateChange(BlockPos blockposition, BlockState iblockdata, BlockState iblockdata1) {
        Optional<Holder<PoiType>> optional1;
        Optional<Holder<PoiType>> optional = PoiTypes.forState(iblockdata);
        if (!Objects.equals(optional, optional1 = PoiTypes.forState(iblockdata1))) {
            BlockPos blockposition1 = blockposition.immutable();
            optional.ifPresent(holder -> this.getServer().execute(() -> {
                this.getPoiManager().remove(blockposition1);
                this.debugSynchronizers.dropPoi(blockposition1);
            }));
            optional1.ifPresent(holder -> this.getServer().execute(() -> {
                PoiRecord villageplacerecord = this.getPoiManager().add(blockposition1, (Holder<PoiType>)holder);
                if (villageplacerecord != null) {
                    this.debugSynchronizers.registerPoi(villageplacerecord);
                }
            }));
        }
    }

    public PoiManager getPoiManager() {
        return this.getChunkSource().getPoiManager();
    }

    public boolean isVillage(BlockPos blockposition) {
        return this.isCloseToVillage(blockposition, 1);
    }

    public boolean isVillage(SectionPos sectionposition) {
        return this.isVillage(sectionposition.center());
    }

    public boolean isCloseToVillage(BlockPos blockposition, int i) {
        return i > 6 ? false : this.sectionsToVillage(SectionPos.of(blockposition)) <= i;
    }

    public int sectionsToVillage(SectionPos sectionposition) {
        return this.getPoiManager().sectionsToVillage(sectionposition);
    }

    public Raids getRaids() {
        return this.raids;
    }

    @Nullable
    public Raid getRaidAt(BlockPos blockposition) {
        return this.raids.getNearbyRaid(blockposition, 9216);
    }

    public boolean isRaided(BlockPos blockposition) {
        return this.getRaidAt(blockposition) != null;
    }

    public void onReputationEvent(ReputationEventType reputationevent, Entity entity, ReputationEventHandler reputationhandler) {
        reputationhandler.onReputationEventFrom(reputationevent, entity);
    }

    public void saveDebugReport(Path path) throws IOException {
        ChunkMap playerchunkmap = this.getChunkSource().chunkMap;
        try (BufferedWriter writer = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            writer.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", playerchunkmap.getDistanceManager().getNaturalSpawnChunkCount()));
            NaturalSpawner.SpawnState spawnercreature_d = this.getChunkSource().getLastSpawnState();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry object2intmap_entry : spawnercreature_d.getMobCategoryCounts().object2IntEntrySet()) {
                    writer.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((MobCategory)object2intmap_entry.getKey()).getName(), object2intmap_entry.getIntValue()));
                }
            }
            writer.write(String.format(Locale.ROOT, "entities: %s\n", this.entityManager.gatherStats()));
            writer.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.blockEntityTickers.size()));
            writer.write(String.format(Locale.ROOT, "block_ticks: %d\n", ((LevelTicks)this.getBlockTicks()).count()));
            writer.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", ((LevelTicks)this.getFluidTicks()).count()));
            writer.write("distance_manager: " + playerchunkmap.getDistanceManager().getDebugStatus() + "\n");
            writer.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.getChunkSource().getPendingTasksCount()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.fillReportDetails(crashreport);
        try (BufferedWriter writer1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            writer1.write(crashreport.getFriendlyReport(ReportType.TEST));
        }
        Path path1 = path.resolve("chunks.csv");
        try (BufferedWriter writer2 = Files.newBufferedWriter(path1, new OpenOption[0]);){
            playerchunkmap.dumpChunks(writer2);
        }
        Path path2 = path.resolve("entity_chunks.csv");
        try (BufferedWriter writer3 = Files.newBufferedWriter(path2, new OpenOption[0]);){
            this.entityManager.dumpSections(writer3);
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter writer4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            ServerLevel.dumpEntities(writer4, this.getEntities().getAll());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter writer5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.dumpBlockEntityTickers(writer5);
        }
    }

    private static void dumpEntities(Writer writer, Iterable<Entity> iterable) throws IOException {
        CsvOutput csvwriter = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("uuid").addColumn("type").addColumn("alive").addColumn("display_name").addColumn("custom_name").build(writer);
        for (Entity entity : iterable) {
            Component ichatbasecomponent = entity.getCustomName();
            Component ichatbasecomponent1 = entity.getDisplayName();
            csvwriter.writeRow(entity.getX(), entity.getY(), entity.getZ(), entity.getUUID(), BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()), entity.isAlive(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void dumpBlockEntityTickers(Writer writer) throws IOException {
        CsvOutput csvwriter = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("type").build(writer);
        for (TickingBlockEntity tickingblockentity : this.blockEntityTickers) {
            BlockPos blockposition = tickingblockentity.getPos();
            csvwriter.writeRow(blockposition.getX(), blockposition.getY(), blockposition.getZ(), tickingblockentity.getType());
        }
    }

    @VisibleForTesting
    public void clearBlockEvents(BoundingBox structureboundingbox) {
        this.blockEvents.removeIf(blockactiondata -> structureboundingbox.isInside(blockactiondata.pos()));
    }

    @Override
    public float getShade(Direction enumdirection, boolean flag) {
        return 1.0f;
    }

    public Iterable<Entity> getAllEntities() {
        return this.getEntities().getAll();
    }

    public String toString() {
        return "ServerLevel[" + this.J.getLevelName() + "]";
    }

    public boolean isFlat() {
        return this.J.isFlatWorld();
    }

    @Override
    public long getSeed() {
        return this.J.worldGenOptions().seed();
    }

    @Nullable
    public EndDragonFight getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public ServerLevel getLevel() {
        return this;
    }

    @VisibleForTesting
    public String getWatchdogStats() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.players.size(), this.entityManager.gatherStats(), ServerLevel.getTypeCount(this.entityManager.getEntityGetter().getAll(), entity -> BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()).toString()), this.blockEntityTickers.size(), ServerLevel.getTypeCount(this.blockEntityTickers, TickingBlockEntity::getType), ((LevelTicks)this.getBlockTicks()).count(), ((LevelTicks)this.getFluidTicks()).count(), this.gatherChunkSourceStats());
    }

    private static <T> String getTypeCount(Iterable<T> iterable, Function<T, String> function) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : iterable) {
                String s = function.apply(t0);
                object2intopenhashmap.addTo((Object)s, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return s1 + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<Entity> getEntities() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.entityManager.getEntityGetter();
    }

    public void addLegacyChunkEntities(Stream<Entity> stream) {
        this.entityManager.addLegacyChunkEntities(stream);
    }

    public void addWorldGenChunkEntities(Stream<Entity> stream) {
        this.entityManager.addWorldGenChunkEntities(stream);
    }

    public void startTickingChunk(LevelChunk chunk) {
        chunk.unpackTicks(this.getLevelData().getGameTime());
    }

    public void onStructureStartsAvailable(ChunkAccess ichunkaccess) {
        this.server.execute(() -> this.structureCheck.onStructureLoad(ichunkaccess.getPos(), ichunkaccess.getAllStarts()));
    }

    public PathTypeCache getPathTypeCache() {
        return this.pathTypesByPosCache;
    }

    public void waitForEntities(ChunkPos chunkcoordintpair, int i) {
        List<ChunkPos> list = ChunkPos.rangeClosed(chunkcoordintpair, i).toList();
        this.server.managedBlock(() -> {
            this.entityManager.processPendingLoads();
            for (ChunkPos chunkcoordintpair1 : list) {
                if (this.areEntitiesLoaded(chunkcoordintpair1.toLong())) continue;
                return false;
            }
            return true;
        });
    }

    public boolean isSpawningMonsters() {
        return MinecraftServer.isSpawningMonsters(this);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.entityManager.close();
    }

    @Override
    public String gatherChunkSourceStats() {
        String s = this.chunkSource.gatherStats();
        return "Chunks[S] W: " + s + " E: " + this.entityManager.gatherStats();
    }

    public boolean areEntitiesLoaded(long i) {
        return this.entityManager.areEntitiesLoaded(i);
    }

    public boolean isPositionTickingWithEntitiesLoaded(long i) {
        return this.areEntitiesLoaded(i) && this.chunkSource.isPositionTicking(i);
    }

    public boolean isPositionEntityTicking(BlockPos blockposition) {
        return this.entityManager.canPositionTick(blockposition) && this.chunkSource.chunkMap.getDistanceManager().inEntityTickingRange(ChunkPos.asLong(blockposition));
    }

    public boolean areEntitiesActuallyLoadedAndTicking(ChunkPos chunkcoordintpair) {
        return this.entityManager.isTicking(chunkcoordintpair) && this.entityManager.areEntitiesLoaded(chunkcoordintpair.toLong());
    }

    public boolean anyPlayerCloseEnoughForSpawning(BlockPos blockposition) {
        return this.anyPlayerCloseEnoughForSpawning(new ChunkPos(blockposition));
    }

    public boolean anyPlayerCloseEnoughForSpawning(ChunkPos chunkcoordintpair) {
        return this.chunkSource.chunkMap.anyPlayerCloseEnoughForSpawning(chunkcoordintpair);
    }

    public boolean canSpawnEntitiesInChunk(ChunkPos chunkcoordintpair) {
        return this.entityManager.canPositionTick(chunkcoordintpair) && this.getWorldBorder().isWithinBounds(chunkcoordintpair);
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.server.getWorldData().enabledFeatures();
    }

    @Override
    public PotionBrewing potionBrewing() {
        return this.server.potionBrewing();
    }

    @Override
    public FuelValues fuelValues() {
        return this.server.fuelValues();
    }

    public RandomSource getRandomSequence(ResourceLocation minecraftkey) {
        return this.randomSequences.get(minecraftkey);
    }

    public RandomSequences getRandomSequences() {
        return this.randomSequences;
    }

    public GameRules getGameRules() {
        return this.J.getGameRules();
    }

    @Override
    public CrashReportCategory fillReportDetails(CrashReport crashreport) {
        CrashReportCategory crashreportsystemdetails = super.fillReportDetails(crashreport);
        crashreportsystemdetails.setDetail("Loaded entity count", () -> String.valueOf(this.entityManager.count()));
        return crashreportsystemdetails;
    }

    @Override
    public int getSeaLevel() {
        return this.chunkSource.getGenerator().getSeaLevel();
    }

    @Override
    public void onBlockEntityAdded(BlockEntity tileentity) {
        super.onBlockEntityAdded(tileentity);
        this.debugSynchronizers.registerBlockEntity(tileentity);
    }

    public LevelDebugSynchronizers debugSynchronizers() {
        return this.debugSynchronizers;
    }

    private final class EntityCallbacks
    implements LevelCallback<Entity> {
        EntityCallbacks() {
        }

        @Override
        public void onCreated(Entity entity) {
            WaypointTransmitter waypointtransmitter;
            if (entity instanceof WaypointTransmitter && (waypointtransmitter = (WaypointTransmitter)((Object)entity)).isTransmittingWaypoint()) {
                ServerLevel.this.getWaypointManager().trackWaypoint(waypointtransmitter);
            }
        }

        @Override
        public void onDestroyed(Entity entity) {
            if (entity instanceof WaypointTransmitter) {
                WaypointTransmitter waypointtransmitter = (WaypointTransmitter)((Object)entity);
                ServerLevel.this.getWaypointManager().untrackWaypoint(waypointtransmitter);
            }
            ServerLevel.this.getScoreboard().entityRemoved(entity);
        }

        @Override
        public void onTickingStart(Entity entity) {
            ServerLevel.this.entityTickList.add(entity);
        }

        @Override
        public void onTickingEnd(Entity entity) {
            ServerLevel.this.entityTickList.remove(entity);
        }

        @Override
        public void onTrackingStart(Entity entity) {
            WaypointTransmitter waypointtransmitter;
            AsyncCatcher.catchOp("entity register");
            ServerLevel.this.getChunkSource().addEntity(entity);
            if (entity instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entity;
                ServerLevel.this.players.add(entityplayer);
                if (entityplayer.isReceivingWaypoints()) {
                    ServerLevel.this.getWaypointManager().addPlayer(entityplayer);
                }
                ServerLevel.this.updateSleepingPlayerList();
            }
            if (entity instanceof WaypointTransmitter && (waypointtransmitter = (WaypointTransmitter)((Object)entity)).isTransmittingWaypoint()) {
                ServerLevel.this.getWaypointManager().trackWaypoint(waypointtransmitter);
            }
            if (entity instanceof Mob) {
                Mob entityinsentient = (Mob)entity;
                if (ServerLevel.this.isUpdatingNavigations) {
                    String s = "onTrackingStart called during navigation iteration";
                    Util.logAndPauseIfInIde("onTrackingStart called during navigation iteration", new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                ServerLevel.this.navigatingMobs.add(entityinsentient);
            }
            if (entity instanceof EnderDragon) {
                EnderDragon entityenderdragon = (EnderDragon)entity;
                for (EnderDragonPart entitycomplexpart : entityenderdragon.getSubEntities()) {
                    ServerLevel.this.dragonParts.put(entitycomplexpart.getId(), (Object)entitycomplexpart);
                }
            }
            entity.updateDynamicGameEventListener(DynamicGameEventListener::add);
            entity.valid = true;
        }

        @Override
        public void onTrackingEnd(Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof Player) {
                Streams.stream(ServerLevel.this.getServer().getAllLevels()).map(ServerLevel::getDataStorage).forEach(worldData -> {
                    for (Optional<SavedData> o : worldData.cache.values()) {
                        if (!(o instanceof MapItemSavedData)) continue;
                        MapItemSavedData map = (MapItemSavedData)((Object)o);
                        map.carriedByPlayers.remove((Player)entity);
                        Iterator<MapItemSavedData.HoldingPlayer> iter = map.carriedBy.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().player != entity) continue;
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof ServerPlayer) || entity.getRemovalReason() != Entity.RemovalReason.KILLED)) {
                for (HumanEntity h : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h.closeInventory();
                }
            }
            ServerLevel.this.getChunkSource().removeEntity(entity);
            if (entity instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entity;
                ServerLevel.this.players.remove(entityplayer);
                ServerLevel.this.getWaypointManager().removePlayer(entityplayer);
                ServerLevel.this.updateSleepingPlayerList();
            }
            if (entity instanceof Mob) {
                Mob entityinsentient = (Mob)entity;
                if (ServerLevel.this.isUpdatingNavigations) {
                    EnderDragonPart[] s = "onTrackingStart called during navigation iteration";
                    Util.logAndPauseIfInIde("onTrackingStart called during navigation iteration", new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                ServerLevel.this.navigatingMobs.remove(entityinsentient);
            }
            if (entity instanceof EnderDragon) {
                EnderDragon entityenderdragon = (EnderDragon)entity;
                for (EnderDragonPart entitycomplexpart : entityenderdragon.getSubEntities()) {
                    ServerLevel.this.dragonParts.remove(entitycomplexpart.getId());
                }
            }
            entity.updateDynamicGameEventListener(DynamicGameEventListener::remove);
            ServerLevel.this.debugSynchronizers.dropEntity(entity);
            entity.valid = false;
            if (!(entity instanceof ServerPlayer)) {
                for (ServerPlayer player : ServerLevel.this.players) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
        }

        @Override
        public void onSectionChange(Entity entity) {
            entity.updateDynamicGameEventListener(DynamicGameEventListener::move);
        }
    }
}

