/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerStatusPacketListener;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftIconCache;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;
import org.spigotmc.SpigotConfig;

public class ServerStatusPacketListenerImpl
implements ServerStatusPacketListener {
    private static final Component DISCONNECT_REASON = Component.translatable("multiplayer.status.request_handled");
    private final ServerStatus status;
    private final Connection connection;
    private boolean hasRequestedStatus;

    public ServerStatusPacketListenerImpl(ServerStatus serverping, Connection networkmanager) {
        this.status = serverping;
        this.connection = networkmanager;
    }

    @Override
    public void onDisconnect(DisconnectionDetails disconnectiondetails) {
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }

    @Override
    public void handleStatusRequest(ServerboundStatusRequestPacket packetstatusinstart) {
        if (this.hasRequestedStatus) {
            this.connection.disconnect(DISCONNECT_REASON);
        } else {
            this.hasRequestedStatus = true;
            final MinecraftServer server = MinecraftServer.getServer();
            final Object[] players = server.getPlayerList().players.toArray();
            class ServerListPingEvent
            extends org.bukkit.event.server.ServerListPingEvent {
                CraftIconCache icon;

                ServerListPingEvent() {
                    super(this$0.connection.hostname, ((InetSocketAddress)this$0.connection.getRemoteAddress()).getAddress(), minecraftServer.getMotd(), minecraftServer.getPlayerList().getMaxPlayers());
                    this.icon = server.server.getServerIcon();
                }

                public void setServerIcon(CachedServerIcon icon) {
                    if (!(icon instanceof CraftIconCache)) {
                        throw new IllegalArgumentException(String.valueOf(icon) + " was not created by " + String.valueOf(CraftServer.class));
                    }
                    this.icon = (CraftIconCache)icon;
                }

                public Iterator<Player> iterator() throws UnsupportedOperationException {
                    return new Iterator<Player>(){
                        int i;
                        int ret = Integer.MIN_VALUE;
                        ServerPlayer player;

                        @Override
                        public boolean hasNext() {
                            if (this.player != null) {
                                return true;
                            }
                            Object[] currentPlayers = players;
                            int length = currentPlayers.length;
                            for (int i = this.i; i < length; ++i) {
                                ServerPlayer player = (ServerPlayer)currentPlayers[i];
                                if (player == null) continue;
                                this.i = i + 1;
                                this.player = player;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public Player next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            ServerPlayer player = this.player;
                            this.player = null;
                            this.ret = this.i - 1;
                            return player.getBukkitEntity();
                        }

                        @Override
                        public void remove() {
                            Object[] currentPlayers = players;
                            int i = this.ret;
                            if (i < 0 || currentPlayers[i] == null) {
                                throw new IllegalStateException();
                            }
                            currentPlayers[i] = null;
                        }
                    };
                }
            }
            ServerListPingEvent event = new ServerListPingEvent();
            server.server.getPluginManager().callEvent((Event)event);
            List<Object> profiles = new ArrayList(players.length);
            for (Object player : players) {
                if (player == null) continue;
                ServerPlayer entityPlayer = (ServerPlayer)player;
                if (entityPlayer.allowsListing()) {
                    profiles.add(entityPlayer.nameAndId());
                    continue;
                }
                profiles.add(MinecraftServer.ANONYMOUS_PLAYER_PROFILE);
            }
            if (!server.hidesOnlinePlayers() && !profiles.isEmpty()) {
                Collections.shuffle(profiles);
                profiles = profiles.subList(0, Math.min(profiles.size(), SpigotConfig.playerSample));
            }
            ServerStatus.Players playerSample = new ServerStatus.Players(event.getMaxPlayers(), event.getNumPlayers(), server.hidesOnlinePlayers() ? Collections.emptyList() : profiles);
            ServerStatus ping = new ServerStatus(CraftChatMessage.fromString(event.getMotd(), true)[0], Optional.of(playerSample), Optional.of(new ServerStatus.Version(server.getServerModName() + " " + server.getServerVersion(), SharedConstants.getCurrentVersion().protocolVersion())), event.icon.value != null ? Optional.of(new ServerStatus.Favicon(event.icon.value)) : Optional.empty(), server.enforceSecureProfile());
            this.connection.send(new ClientboundStatusResponsePacket(ping));
        }
    }

    @Override
    public void handlePingRequest(ServerboundPingRequestPacket serverboundpingrequestpacket) {
        this.connection.send(new ClientboundPongResponsePacket(serverboundpingrequestpacket.getTime()));
        this.connection.disconnect(DISCONNECT_REASON);
    }
}

