/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.notifications.EmptyNotificationService;
import net.minecraft.server.players.BanListEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class OldUsersConverter {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final File OLD_IPBANLIST = new File("banned-ips.txt");
    public static final File OLD_USERBANLIST = new File("banned-players.txt");
    public static final File OLD_OPLIST = new File("ops.txt");
    public static final File OLD_WHITELIST = new File("white-list.txt");

    static List<String> readOldListFormat(File file, Map<String, String[]> map) throws IOException {
        List list = Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        for (String s : list) {
            if ((s = s.trim()).startsWith("#") || s.length() < 1) continue;
            String[] astring = s.split("\\|");
            map.put(astring[0].toLowerCase(Locale.ROOT), astring);
        }
        return list;
    }

    private static void lookupPlayers(MinecraftServer minecraftserver, Collection<String> collection, ProfileLookupCallback profilelookupcallback) {
        String[] astring = (String[])collection.stream().filter(s -> !StringUtil.isNullOrEmpty(s)).toArray(String[]::new);
        if (minecraftserver.usesAuthentication() || SpigotConfig.bungee) {
            minecraftserver.services().profileRepository().findProfilesByNames(astring, profilelookupcallback);
        } else {
            for (String s2 : astring) {
                profilelookupcallback.onProfileLookupSucceeded(s2, UUIDUtil.createOfflinePlayerUUID(s2));
            }
        }
    }

    public static boolean convertUserBanlist(final MinecraftServer minecraftserver) {
        final UserBanList gameprofilebanlist = new UserBanList(PlayerList.USERBANLIST_FILE, new EmptyNotificationService());
        if (OLD_USERBANLIST.exists() && OLD_USERBANLIST.isFile()) {
            if (gameprofilebanlist.getFile().exists()) {
                try {
                    gameprofilebanlist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)gameprofilebanlist.getFile().getName());
                }
            }
            try {
                final HashMap map = Maps.newHashMap();
                OldUsersConverter.readOldListFormat(OLD_USERBANLIST, map);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(String s, UUID uuid) {
                        NameAndId nameandid = new NameAndId(uuid, s);
                        minecraftserver.services().nameToIdCache().add(nameandid);
                        String[] astring = (String[])map.get(nameandid.name().toLowerCase(Locale.ROOT));
                        if (astring == null) {
                            LOGGER.warn("Could not convert user banlist entry for {}", (Object)nameandid.name());
                            throw new ConversionError("Profile not in the conversionlist");
                        }
                        Date date = astring.length > 1 ? OldUsersConverter.parseDate(astring[1], null) : null;
                        String s1 = astring.length > 2 ? astring[2] : null;
                        Date date1 = astring.length > 3 ? OldUsersConverter.parseDate(astring[3], null) : null;
                        String s2 = astring.length > 4 ? astring[4] : null;
                        gameprofilebanlist.add(new UserBanListEntry(nameandid, date, s1, date1, s2));
                    }

                    public void onProfileLookupFailed(String s, Exception exception) {
                        LOGGER.warn("Could not lookup user banlist entry for {}", (Object)s, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + s + " from backend systems", exception);
                        }
                    }
                };
                OldUsersConverter.lookupPlayers(minecraftserver, map.keySet(), profilelookupcallback);
                gameprofilebanlist.save();
                OldUsersConverter.renameOldFile(OLD_USERBANLIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not read old user banlist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (ConversionError namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    public static boolean convertIpBanlist(MinecraftServer minecraftserver) {
        IpBanList ipbanlist = new IpBanList(PlayerList.IPBANLIST_FILE, new EmptyNotificationService());
        if (OLD_IPBANLIST.exists() && OLD_IPBANLIST.isFile()) {
            if (ipbanlist.getFile().exists()) {
                try {
                    ipbanlist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)ipbanlist.getFile().getName());
                }
            }
            try {
                HashMap map = Maps.newHashMap();
                OldUsersConverter.readOldListFormat(OLD_IPBANLIST, map);
                for (String s : map.keySet()) {
                    String[] astring = (String[])map.get(s);
                    Date date = astring.length > 1 ? OldUsersConverter.parseDate(astring[1], null) : null;
                    String s1 = astring.length > 2 ? astring[2] : null;
                    Date date1 = astring.length > 3 ? OldUsersConverter.parseDate(astring[3], null) : null;
                    String s2 = astring.length > 4 ? astring[4] : null;
                    ipbanlist.add(new IpBanListEntry(s, date, s1, date1, s2));
                }
                ipbanlist.save();
                OldUsersConverter.renameOldFile(OLD_IPBANLIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not parse old ip banlist to convert it!", (Throwable)ioexception1);
                return false;
            }
        }
        return true;
    }

    public static boolean convertOpsList(final MinecraftServer minecraftserver) {
        final ServerOpList oplist = new ServerOpList(PlayerList.OPLIST_FILE, new EmptyNotificationService());
        if (OLD_OPLIST.exists() && OLD_OPLIST.isFile()) {
            if (oplist.getFile().exists()) {
                try {
                    oplist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)oplist.getFile().getName());
                }
            }
            try {
                List list = Files.readLines((File)OLD_OPLIST, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(String s, UUID uuid) {
                        NameAndId nameandid = new NameAndId(uuid, s);
                        minecraftserver.services().nameToIdCache().add(nameandid);
                        oplist.add(new ServerOpListEntry(nameandid, minecraftserver.operatorUserPermissionLevel(), false));
                    }

                    public void onProfileLookupFailed(String s, Exception exception) {
                        LOGGER.warn("Could not lookup oplist entry for {}", (Object)s, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + s + " from backend systems", exception);
                        }
                    }
                };
                OldUsersConverter.lookupPlayers(minecraftserver, list, profilelookupcallback);
                oplist.save();
                OldUsersConverter.renameOldFile(OLD_OPLIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not read old oplist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (ConversionError namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    public static boolean convertWhiteList(final MinecraftServer minecraftserver) {
        final UserWhiteList whitelist = new UserWhiteList(PlayerList.WHITELIST_FILE, new EmptyNotificationService());
        if (OLD_WHITELIST.exists() && OLD_WHITELIST.isFile()) {
            if (whitelist.getFile().exists()) {
                try {
                    whitelist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)whitelist.getFile().getName());
                }
            }
            try {
                List list = Files.readLines((File)OLD_WHITELIST, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(String s, UUID uuid) {
                        NameAndId nameandid = new NameAndId(uuid, s);
                        minecraftserver.services().nameToIdCache().add(nameandid);
                        whitelist.add(new UserWhiteListEntry(nameandid));
                    }

                    public void onProfileLookupFailed(String s, Exception exception) {
                        LOGGER.warn("Could not lookup user whitelist entry for {}", (Object)s, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + s + " from backend systems", exception);
                        }
                    }
                };
                OldUsersConverter.lookupPlayers(minecraftserver, list, profilelookupcallback);
                whitelist.save();
                OldUsersConverter.renameOldFile(OLD_WHITELIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not read old whitelist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (ConversionError namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static UUID convertMobOwnerIfNecessary(final MinecraftServer minecraftserver, String s) {
        if (!StringUtil.isNullOrEmpty(s) && s.length() <= 16) {
            Optional<UUID> optional = minecraftserver.services().nameToIdCache().get(s).map(NameAndId::id);
            if (optional.isPresent()) {
                return optional.get();
            }
            if (!minecraftserver.isSingleplayer() && minecraftserver.usesAuthentication()) {
                final ArrayList list = new ArrayList();
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(String s1, UUID uuid) {
                        NameAndId nameandid = new NameAndId(uuid, s1);
                        minecraftserver.services().nameToIdCache().add(nameandid);
                        list.add(nameandid);
                    }

                    public void onProfileLookupFailed(String s1, Exception exception) {
                        LOGGER.warn("Could not lookup user whitelist entry for {}", (Object)s1, (Object)exception);
                    }
                };
                OldUsersConverter.lookupPlayers(minecraftserver, Lists.newArrayList((Object[])new String[]{s}), profilelookupcallback);
                return !list.isEmpty() ? ((NameAndId)list.getFirst()).id() : null;
            }
            return UUIDUtil.createOfflinePlayerUUID(s);
        }
        try {
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public static boolean convertPlayers(final DedicatedServer dedicatedserver) {
        final File file = OldUsersConverter.getWorldPlayersDirectory(dedicatedserver);
        final File file1 = new File(file.getParentFile(), "playerdata");
        final File file2 = new File(file.getParentFile(), "unknownplayers");
        if (file.exists() && file.isDirectory()) {
            File[] afile = file.listFiles();
            ArrayList list = Lists.newArrayList();
            for (File file3 : afile) {
                String s1;
                String s = file3.getName();
                if (!s.toLowerCase(Locale.ROOT).endsWith(".dat") || (s1 = s.substring(0, s.length() - ".dat".length())).isEmpty()) continue;
                list.add(s1);
            }
            try {
                Object[] astring = list.toArray(new String[list.size()]);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){
                    final /* synthetic */ String[] val$astring;
                    {
                        this.val$astring = stringArray;
                    }

                    public void onProfileLookupSucceeded(String s2, UUID uuid) {
                        NameAndId nameandid = new NameAndId(uuid, s2);
                        dedicatedserver.services().nameToIdCache().add(nameandid);
                        this.movePlayerFile(file1, this.getFileNameForProfile(s2), uuid.toString());
                    }

                    public void onProfileLookupFailed(String s2, Exception exception) {
                        LOGGER.warn("Could not lookup user uuid for {}", (Object)s2, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + s2 + " from backend systems", exception);
                        }
                        String s3 = this.getFileNameForProfile(s2);
                        this.movePlayerFile(file2, s3, s3);
                    }

                    private void movePlayerFile(File file4, String s2, String s3) {
                        File file5 = new File(file, s2 + ".dat");
                        File file6 = new File(file4, s3 + ".dat");
                        CompoundTag root = null;
                        try {
                            root = NbtIo.readCompressed(new FileInputStream(file5), NbtAccounter.unlimitedHeap());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (root != null) {
                            if (!root.contains("bukkit")) {
                                root.put("bukkit", new CompoundTag());
                            }
                            CompoundTag data = root.getCompoundOrEmpty("bukkit");
                            data.putString("lastKnownName", s2);
                            try {
                                NbtIo.writeCompressed(root, new FileOutputStream(file2));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        OldUsersConverter.ensureDirectoryExists(file4);
                        if (!file5.renameTo(file6)) {
                            throw new ConversionError("Could not convert file for " + s2);
                        }
                    }

                    private String getFileNameForProfile(String s2) {
                        String s3 = null;
                        for (String s4 : this.val$astring) {
                            if (s4 == null || !s4.equalsIgnoreCase(s2)) continue;
                            s3 = s4;
                            break;
                        }
                        if (s3 == null) {
                            throw new ConversionError("Could not find the filename for " + s2 + " anymore");
                        }
                        return s3;
                    }
                };
                OldUsersConverter.lookupPlayers(dedicatedserver, Lists.newArrayList((Object[])astring), profilelookupcallback);
                return true;
            }
            catch (ConversionError namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    static void ensureDirectoryExists(File file) {
        if (file.exists() ? !file.isDirectory() : !file.mkdirs()) {
            throw new ConversionError("Can't create directory " + file.getName() + " in world save directory.");
        }
    }

    public static boolean serverReadyAfterUserconversion(MinecraftServer minecraftserver) {
        boolean flag = OldUsersConverter.areOldUserlistsRemoved();
        flag = flag && OldUsersConverter.areOldPlayersConverted(minecraftserver);
        return flag;
    }

    private static boolean areOldUserlistsRemoved() {
        boolean flag = false;
        if (OLD_USERBANLIST.exists() && OLD_USERBANLIST.isFile()) {
            flag = true;
        }
        boolean flag1 = false;
        if (OLD_IPBANLIST.exists() && OLD_IPBANLIST.isFile()) {
            flag1 = true;
        }
        boolean flag2 = false;
        if (OLD_OPLIST.exists() && OLD_OPLIST.isFile()) {
            flag2 = true;
        }
        boolean flag3 = false;
        if (OLD_WHITELIST.exists() && OLD_WHITELIST.isFile()) {
            flag3 = true;
        }
        if (!(flag || flag1 || flag2 || flag3)) {
            return true;
        }
        LOGGER.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
        LOGGER.warn("** please remove the following files and restart the server:");
        if (flag) {
            LOGGER.warn("* {}", (Object)OLD_USERBANLIST.getName());
        }
        if (flag1) {
            LOGGER.warn("* {}", (Object)OLD_IPBANLIST.getName());
        }
        if (flag2) {
            LOGGER.warn("* {}", (Object)OLD_OPLIST.getName());
        }
        if (flag3) {
            LOGGER.warn("* {}", (Object)OLD_WHITELIST.getName());
        }
        return false;
    }

    private static boolean areOldPlayersConverted(MinecraftServer minecraftserver) {
        File file = OldUsersConverter.getWorldPlayersDirectory(minecraftserver);
        if (!file.exists() || !file.isDirectory() || file.list().length <= 0 && file.delete()) {
            return true;
        }
        LOGGER.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
        LOGGER.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
        LOGGER.warn("** please restart the server and if the problem persists, remove the directory '{}'", (Object)file.getPath());
        return false;
    }

    private static File getWorldPlayersDirectory(MinecraftServer minecraftserver) {
        return minecraftserver.getWorldPath(LevelResource.PLAYER_OLD_DATA_DIR).toFile();
    }

    private static void renameOldFile(File file) {
        File file1 = new File(file.getName() + ".converted");
        file.renameTo(file1);
    }

    static Date parseDate(String s, Date date) {
        Date date1;
        try {
            date1 = BanListEntry.DATE_FORMAT.parse(s);
        }
        catch (ParseException parseexception) {
            date1 = date;
        }
        return date1;
    }

    private static class ConversionError
    extends RuntimeException {
        ConversionError(String s, Throwable throwable) {
            super(s, throwable);
        }

        ConversionError(String s) {
            super(s);
        }
    }
}

