/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public abstract class ItemStackTagFix
extends DataFix {
    private final String name;
    private final Predicate<String> idFilter;

    public ItemStackTagFix(Schema var0, String var1, Predicate<String> var2) {
        super(var0, false);
        this.name = var1;
        this.idFilter = var2;
    }

    public final TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(References.ITEM_STACK);
        return this.fixTypeEverywhereTyped(this.name, var0, ItemStackTagFix.createFixer(var0, this.idFilter, this::fixItemStackTag));
    }

    public static UnaryOperator<Typed<?>> createFixer(Type<?> var0, Predicate<String> var1, UnaryOperator<Typed<?>> var2) {
        OpticFinder var3 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        OpticFinder var42 = var0.findField("tag");
        return var4 -> {
            Optional var5 = var4.getOptional(var3);
            if (var5.isPresent() && var1.test((String)((Pair)var5.get()).getSecond())) {
                return var4.updateTyped(var42, (Function)var2);
            }
            return var4;
        };
    }

    protected abstract Typed<?> fixItemStackTag(Typed<?> var1);
}

