/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import net.minecraft.util.datafix.fixes.AbstractBlockPropertyFix;

public class JigsawRotationFix
extends AbstractBlockPropertyFix {
    private static final Map<String, String> RENAMES = ImmutableMap.builder().put((Object)"down", (Object)"down_south").put((Object)"up", (Object)"up_north").put((Object)"north", (Object)"north_up").put((Object)"south", (Object)"south_up").put((Object)"west", (Object)"west_up").put((Object)"east", (Object)"east_up").build();

    public JigsawRotationFix(Schema var0) {
        super(var0, "jigsaw_rotation_fix");
    }

    @Override
    protected boolean shouldFix(String var0) {
        return var0.equals("minecraft:jigsaw");
    }

    @Override
    protected <T> Dynamic<T> fixProperties(String var0, Dynamic<T> var1) {
        String var2 = var1.get("facing").asString("north");
        return var1.remove("facing").set("orientation", var1.createString(RENAMES.getOrDefault(var2, var2)));
    }
}

