/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class ClampedInt
extends IntProvider {
    public static final MapCodec<ClampedInt> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)IntProvider.CODEC.fieldOf("source").forGetter(var0 -> var0.source), (App)Codec.INT.fieldOf("min_inclusive").forGetter(var0 -> var0.minInclusive), (App)Codec.INT.fieldOf("max_inclusive").forGetter(var0 -> var0.maxInclusive)).apply((Applicative)var02, ClampedInt::new)).validate(var0 -> {
        if (var0.maxInclusive < var0.minInclusive) {
            return DataResult.error(() -> "Max must be at least min, min_inclusive: " + var0.minInclusive + ", max_inclusive: " + var0.maxInclusive);
        }
        return DataResult.success((Object)var0);
    });
    private final IntProvider source;
    private final int minInclusive;
    private final int maxInclusive;

    public static ClampedInt of(IntProvider var0, int var1, int var2) {
        return new ClampedInt(var0, var1, var2);
    }

    public ClampedInt(IntProvider var0, int var1, int var2) {
        this.source = var0;
        this.minInclusive = var1;
        this.maxInclusive = var2;
    }

    @Override
    public int sample(RandomSource var0) {
        return Mth.clamp(this.source.sample(var0), this.minInclusive, this.maxInclusive);
    }

    @Override
    public int getMinValue() {
        return Math.max(this.minInclusive, this.source.getMinValue());
    }

    @Override
    public int getMaxValue() {
        return Math.min(this.maxInclusive, this.source.getMaxValue());
    }

    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.CLAMPED;
    }
}

