/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class InterpolationHandler {
    public static final int DEFAULT_INTERPOLATION_STEPS = 3;
    private final Entity entity;
    private int interpolationSteps;
    private final InterpolationData interpolationData = new InterpolationData(0, Vec3.ZERO, 0.0f, 0.0f);
    @Nullable
    private Vec3 previousTickPosition;
    @Nullable
    private Vec2 previousTickRot;
    @Nullable
    private final Consumer<InterpolationHandler> onInterpolationStart;

    public InterpolationHandler(Entity var0) {
        this(var0, 3, null);
    }

    public InterpolationHandler(Entity var0, int var1) {
        this(var0, var1, null);
    }

    public InterpolationHandler(Entity var0, @Nullable Consumer<InterpolationHandler> var1) {
        this(var0, 3, var1);
    }

    public InterpolationHandler(Entity var0, int var1, @Nullable Consumer<InterpolationHandler> var2) {
        this.interpolationSteps = var1;
        this.entity = var0;
        this.onInterpolationStart = var2;
    }

    public Vec3 position() {
        return this.interpolationData.steps > 0 ? this.interpolationData.position : this.entity.position();
    }

    public float yRot() {
        return this.interpolationData.steps > 0 ? this.interpolationData.yRot : this.entity.getYRot();
    }

    public float xRot() {
        return this.interpolationData.steps > 0 ? this.interpolationData.xRot : this.entity.getXRot();
    }

    public void interpolateTo(Vec3 var0, float var1, float var2) {
        if (this.interpolationSteps == 0) {
            this.entity.snapTo(var0, var1, var2);
            this.cancel();
            return;
        }
        if (this.hasActiveInterpolation() && Objects.equals(Float.valueOf(this.yRot()), Float.valueOf(var1)) && Objects.equals(Float.valueOf(this.xRot()), Float.valueOf(var2)) && Objects.equals(this.position(), var0)) {
            return;
        }
        this.interpolationData.steps = this.interpolationSteps;
        this.interpolationData.position = var0;
        this.interpolationData.yRot = var1;
        this.interpolationData.xRot = var2;
        this.previousTickPosition = this.entity.position();
        this.previousTickRot = new Vec2(this.entity.getXRot(), this.entity.getYRot());
        if (this.onInterpolationStart != null) {
            this.onInterpolationStart.accept(this);
        }
    }

    public boolean hasActiveInterpolation() {
        return this.interpolationData.steps > 0;
    }

    public void setInterpolationLength(int var0) {
        this.interpolationSteps = var0;
    }

    public void interpolate() {
        if (!this.hasActiveInterpolation()) {
            this.cancel();
            return;
        }
        double var0 = 1.0 / (double)this.interpolationData.steps;
        if (this.previousTickPosition != null) {
            Vec3 var2 = this.entity.position().subtract(this.previousTickPosition);
            if (this.entity.level().noCollision(this.entity, this.entity.makeBoundingBox(this.interpolationData.position.add(var2)))) {
                this.interpolationData.addDelta(var2);
            }
        }
        if (this.previousTickRot != null) {
            float var2 = this.entity.getYRot() - this.previousTickRot.y;
            float var3 = this.entity.getXRot() - this.previousTickRot.x;
            this.interpolationData.addRotation(var2, var3);
        }
        double var2 = Mth.lerp(var0, this.entity.getX(), this.interpolationData.position.x);
        double var4 = Mth.lerp(var0, this.entity.getY(), this.interpolationData.position.y);
        double var6 = Mth.lerp(var0, this.entity.getZ(), this.interpolationData.position.z);
        Vec3 var8 = new Vec3(var2, var4, var6);
        float var9 = (float)Mth.rotLerp(var0, (double)this.entity.getYRot(), (double)this.interpolationData.yRot);
        float var10 = (float)Mth.lerp(var0, (double)this.entity.getXRot(), (double)this.interpolationData.xRot);
        this.entity.setPos(var8);
        this.entity.setRot(var9, var10);
        this.interpolationData.decrease();
        this.previousTickPosition = var8;
        this.previousTickRot = new Vec2(this.entity.getXRot(), this.entity.getYRot());
    }

    public void cancel() {
        this.interpolationData.steps = 0;
        this.previousTickPosition = null;
        this.previousTickRot = null;
    }

    static class InterpolationData {
        protected int steps;
        Vec3 position;
        float yRot;
        float xRot;

        InterpolationData(int var0, Vec3 var1, float var2, float var3) {
            this.steps = var0;
            this.position = var1;
            this.yRot = var2;
            this.xRot = var3;
        }

        public void decrease() {
            --this.steps;
        }

        public void addDelta(Vec3 var0) {
            this.position = this.position.add(var0);
        }

        public void addRotation(float var0, float var1) {
            this.yRot += var0;
            this.xRot += var1;
        }
    }
}

