/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityUnleashEvent;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 12.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;
    public static final double MAXIMUM_ALLOWED_LEASHED_DIST = 16.0;
    public static final Vec3 AXIS_SPECIFIC_ELASTICITY = new Vec3(0.8, 0.2, 0.8);
    public static final float SPRING_DAMPENING = 0.7f;
    public static final double TORSIONAL_ELASTICITY = 10.0;
    public static final double STIFFNESS = 0.11;
    public static final List<Vec3> ENTITY_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.5));
    public static final List<Vec3> LEASHER_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.0));
    public static final List<Vec3> SHARED_QUAD_ATTACHMENT_POINTS = ImmutableList.of((Object)new Vec3(-0.5, 0.5, 0.5), (Object)new Vec3(-0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, 0.5));

    @Nullable
    public LeashData getLeashData();

    public void setLeashData(@Nullable LeashData var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedTo(Entity entity) {
        return this == entity ? false : (this.leashDistanceTo(entity) > this.leashSnapDistance() ? false : this.canBeLeashed());
    }

    default public double leashDistanceTo(Entity entity) {
        return entity.getBoundingBox().getCenter().distanceTo(((Entity)((Object)this)).getBoundingBox().getCenter());
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int i) {
        this.setLeashData(new LeashData(i));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    default public void readLeashData(ValueInput valueinput) {
        LeashData leashable_a = valueinput.read(LEASH_TAG, LeashData.CODEC).orElse(null);
        if (this.getLeashData() != null && leashable_a == null) {
            this.removeLeash();
        }
        this.setLeashData(leashable_a);
    }

    default public void writeLeashData(ValueOutput valueoutput, @Nullable LeashData leashable_a) {
        Entity entity;
        if (leashable_a != null && (entity = leashable_a.leashHolder) != null && entity.pluginRemoved) {
            return;
        }
        valueoutput.storeNullable(LEASH_TAG, LeashData.CODEC, leashable_a);
    }

    private static <E extends Entity> void restoreLeashFromSave(E e0, LeashData leashable_a) {
        Level world;
        if (leashable_a.delayedLeashInfo != null && (world = e0.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Optional optional = leashable_a.delayedLeashInfo.left();
            Optional optional1 = leashable_a.delayedLeashInfo.right();
            if (optional.isPresent()) {
                Entity entity = worldserver.getEntity((UUID)optional.get());
                if (entity != null) {
                    Leashable.setLeashedTo(e0, entity, true);
                    return;
                }
            } else if (optional1.isPresent()) {
                Leashable.setLeashedTo(e0, LeashFenceKnotEntity.getOrCreateKnot(worldserver, (BlockPos)optional1.get()), true);
                return;
            }
            if (e0.tickCount > 100) {
                e0.forceDrops = true;
                e0.spawnAtLocation(worldserver, Items.LEAD);
                e0.forceDrops = false;
                ((Leashable)((Object)e0)).setLeashData(null);
            }
        }
    }

    default public void dropLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, true);
    }

    default public void removeLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, false);
    }

    default public void onLeashRemoved() {
    }

    private static <E extends Entity> void dropLeash(E e0, boolean flag, boolean flag1) {
        LeashData leashable_a = ((Leashable)((Object)e0)).getLeashData();
        if (leashable_a != null && leashable_a.leashHolder != null) {
            ((Leashable)((Object)e0)).setLeashData(null);
            ((Leashable)((Object)e0)).onLeashRemoved();
            Level world = e0.level();
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (flag1) {
                    e0.forceDrops = true;
                    e0.spawnAtLocation(worldserver, Items.LEAD);
                    e0.forceDrops = false;
                }
                if (flag) {
                    worldserver.getChunkSource().sendToTrackingPlayers(e0, new ClientboundSetEntityLinkPacket(e0, null));
                }
                leashable_a.leashHolder.notifyLeasheeRemoved((Leashable)((Object)e0));
            }
        }
    }

    public static <E extends Entity> void tickLeash(ServerLevel worldserver, E e0) {
        LeashData leashable_a = ((Leashable)((Object)e0)).getLeashData();
        if (leashable_a != null && leashable_a.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave(e0, leashable_a);
        }
        if (leashable_a != null && leashable_a.leashHolder != null) {
            Entity entity;
            if (!e0.canInteractWithLevel() || !leashable_a.leashHolder.canInteractWithLevel()) {
                worldserver.getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)e0.getBukkitEntity(), !e0.isAlive() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE));
                if (worldserver.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && !e0.pluginRemoved) {
                    ((Leashable)((Object)e0)).dropLeash();
                } else {
                    ((Leashable)((Object)e0)).removeLeash();
                }
            }
            if ((entity = ((Leashable)((Object)e0)).getLeashHolder()) != null && entity.level() == e0.level()) {
                double d0 = ((Leashable)((Object)e0)).leashDistanceTo(entity);
                ((Leashable)((Object)e0)).whenLeashedTo(entity);
                if (d0 > ((Leashable)((Object)e0)).leashSnapDistance()) {
                    worldserver.playSound((Entity)null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.LEAD_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ((Leashable)((Object)e0)).leashTooFarBehaviour();
                } else if (d0 > ((Leashable)((Object)e0)).leashElasticDistance() - (double)entity.getBbWidth() - (double)e0.getBbWidth() && ((Leashable)((Object)e0)).checkElasticInteractions(entity, leashable_a)) {
                    ((Leashable)((Object)e0)).onElasticLeashPull();
                } else {
                    ((Leashable)((Object)e0)).closeRangeLeashBehaviour(entity);
                }
                e0.setYRot((float)((double)e0.getYRot() - leashable_a.angularMomentum));
                leashable_a.angularMomentum *= (double)Leashable.angularFriction(e0);
            }
        }
    }

    default public void onElasticLeashPull() {
        Entity entity = (Entity)((Object)this);
        entity.checkFallDistanceAccumulation();
    }

    default public double leashSnapDistance() {
        return 12.0;
    }

    default public double leashElasticDistance() {
        return 6.0;
    }

    public static <E extends Entity> float angularFriction(E e0) {
        return e0.onGround() ? e0.level().getBlockState(e0.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.91f : (e0.isInLiquid() ? 0.8f : 0.91f);
    }

    default public void whenLeashedTo(Entity entity) {
        entity.notifyLeashHolder(this);
    }

    default public void leashTooFarBehaviour() {
        Leashable leashable = this;
        if (leashable instanceof Entity) {
            Entity entity = (Entity)((Object)leashable);
            entity.level().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE));
        }
        this.dropLeash();
    }

    default public void closeRangeLeashBehaviour(Entity entity) {
    }

    default public boolean checkElasticInteractions(Entity entity, LeashData leashable_a) {
        boolean flag = entity.supportQuadLeashAsHolder() && this.supportQuadLeash();
        List<Wrench> list = Leashable.computeElasticInteraction((Entity)((Object)this), entity, flag ? SHARED_QUAD_ATTACHMENT_POINTS : ENTITY_ATTACHMENT_POINT, flag ? SHARED_QUAD_ATTACHMENT_POINTS : LEASHER_ATTACHMENT_POINT);
        if (list.isEmpty()) {
            return false;
        }
        Wrench leashable_b = Wrench.accumulate(list).scale(flag ? 0.25 : 1.0);
        leashable_a.angularMomentum += 10.0 * leashable_b.torque();
        Vec3 vec3d = Leashable.getHolderMovement(entity).subtract(((Entity)((Object)this)).getKnownMovement());
        ((Entity)((Object)this)).addDeltaMovement(leashable_b.force().multiply(AXIS_SPECIFIC_ELASTICITY).add(vec3d.scale(0.11)));
        return true;
    }

    private static Vec3 getHolderMovement(Entity entity) {
        Mob entityinsentient;
        if (entity instanceof Mob && (entityinsentient = (Mob)entity).isNoAi()) {
            return Vec3.ZERO;
        }
        return entity.getKnownMovement();
    }

    private static <E extends Entity> List<Wrench> computeElasticInteraction(E e0, Entity entity, List<Vec3> list, List<Vec3> list1) {
        double d0 = ((Leashable)((Object)e0)).leashElasticDistance();
        Vec3 vec3d = Leashable.getHolderMovement(e0);
        float f = e0.getYRot() * ((float)Math.PI / 180);
        Vec3 vec3d1 = new Vec3(e0.getBbWidth(), e0.getBbHeight(), e0.getBbWidth());
        float f1 = entity.getYRot() * ((float)Math.PI / 180);
        Vec3 vec3d2 = new Vec3(entity.getBbWidth(), entity.getBbHeight(), entity.getBbWidth());
        ArrayList<Wrench> list2 = new ArrayList<Wrench>();
        for (int i = 0; i < list.size(); ++i) {
            Vec3 vec3d3 = list.get(i).multiply(vec3d1).yRot(-f);
            Vec3 vec3d4 = e0.position().add(vec3d3);
            Vec3 vec3d5 = list1.get(i).multiply(vec3d2).yRot(-f1);
            Vec3 vec3d6 = entity.position().add(vec3d5);
            Optional<Wrench> optional = Leashable.computeDampenedSpringInteraction(vec3d6, vec3d4, d0, vec3d, vec3d3);
            Objects.requireNonNull(list2);
            optional.ifPresent(list2::add);
        }
        return list2;
    }

    private static Optional<Wrench> computeDampenedSpringInteraction(Vec3 vec3d, Vec3 vec3d1, double d0, Vec3 vec3d2, Vec3 vec3d3) {
        boolean flag;
        double d1 = vec3d1.distanceTo(vec3d);
        if (d1 < d0) {
            return Optional.empty();
        }
        Vec3 vec3d4 = vec3d.subtract(vec3d1).normalize().scale(d1 - d0);
        double d2 = Wrench.torqueFromForce(vec3d3, vec3d4);
        boolean bl = flag = vec3d2.dot(vec3d4) >= 0.0;
        if (flag) {
            vec3d4 = vec3d4.scale(0.3f);
        }
        return Optional.of(new Wrench(vec3d4, d2));
    }

    default public boolean supportQuadLeash() {
        return false;
    }

    default public Vec3[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets((Entity)((Object)this), 0.0, 0.5, 0.5, 0.5);
    }

    public static Vec3[] createQuadLeashOffsets(Entity entity, double d0, double d1, double d2, double d3) {
        float f = entity.getBbWidth();
        double d4 = d0 * (double)f;
        double d5 = d1 * (double)f;
        double d6 = d2 * (double)f;
        double d7 = d3 * (double)entity.getBbHeight();
        return new Vec3[]{new Vec3(-d6, d7, d5 + d4), new Vec3(-d6, d7, -d5 + d4), new Vec3(d6, d7, -d5 + d4), new Vec3(d6, d7, d5 + d4)};
    }

    default public Vec3 getLeashOffset(float f) {
        return this.getLeashOffset();
    }

    default public Vec3 getLeashOffset() {
        Entity entity = (Entity)((Object)this);
        return new Vec3(0.0, entity.getEyeHeight(), entity.getBbWidth() * 0.4f);
    }

    default public void setLeashedTo(Entity entity, boolean flag) {
        if (this != entity) {
            Leashable.setLeashedTo((Entity)((Object)this), entity, flag);
        }
    }

    private static <E extends Entity> void setLeashedTo(E e0, Entity entity, boolean flag) {
        Level world;
        LeashData leashable_a = ((Leashable)((Object)e0)).getLeashData();
        if (leashable_a == null) {
            leashable_a = new LeashData(entity);
            ((Leashable)((Object)e0)).setLeashData(leashable_a);
        } else {
            Entity entity1 = leashable_a.leashHolder;
            leashable_a.setLeashHolder(entity);
            if (entity1 != null && entity1 != entity) {
                entity1.notifyLeasheeRemoved((Leashable)((Object)e0));
            }
        }
        if (flag && (world = e0.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            worldserver.getChunkSource().sendToTrackingPlayers(e0, new ClientboundSetEntityLinkPacket(e0, entity));
        }
        if (e0.isPassenger()) {
            e0.stopRiding();
        }
    }

    @Nullable
    default public Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity getLeashHolder(E e0) {
        Entity entity;
        LeashData leashable_a = ((Leashable)((Object)e0)).getLeashData();
        if (leashable_a == null) {
            return null;
        }
        if (leashable_a.delayedLeashHolderId != 0 && e0.level().isClientSide() && (entity = e0.level().getEntity(leashable_a.delayedLeashHolderId)) instanceof Entity) {
            leashable_a.setLeashHolder(entity);
        }
        return leashable_a.leashHolder;
    }

    public static List<Leashable> leashableLeashedTo(Entity entity) {
        return Leashable.leashableInArea(entity, leashable -> leashable.getLeashHolder() == entity);
    }

    public static List<Leashable> leashableInArea(Entity entity, Predicate<Leashable> predicate) {
        return Leashable.leashableInArea(entity.level(), entity.getBoundingBox().getCenter(), predicate);
    }

    public static List<Leashable> leashableInArea(Level world, Vec3 vec3d, Predicate<Leashable> predicate) {
        double d0 = 32.0;
        AABB axisalignedbb = AABB.ofSize(vec3d, 32.0, 32.0, 32.0);
        Stream stream = world.getEntitiesOfClass(Entity.class, axisalignedbb, entity -> {
            Leashable leashable;
            if (entity instanceof Leashable && predicate.test(leashable = (Leashable)((Object)entity))) {
                boolean flag = true;
                return flag;
            }
            boolean flag = false;
            return flag;
        }).stream();
        Objects.requireNonNull(Leashable.class);
        return stream.map(Leashable.class::cast).toList();
    }

    public static final class LeashData {
        public static final Codec<LeashData> CODEC = Codec.xor((Codec)UUIDUtil.CODEC.fieldOf("UUID").codec(), BlockPos.CODEC).xmap(LeashData::new, leashable_a -> {
            Entity entity = leashable_a.leashHolder;
            if (entity instanceof LeashFenceKnotEntity) {
                LeashFenceKnotEntity entityleash = (LeashFenceKnotEntity)entity;
                return Either.right((Object)entityleash.getPos());
            }
            return leashable_a.leashHolder != null ? Either.left((Object)leashable_a.leashHolder.getUUID()) : Objects.requireNonNull(leashable_a.delayedLeashInfo, "Invalid LeashData had no attachment");
        });
        int delayedLeashHolderId;
        @Nullable
        public Entity leashHolder;
        @Nullable
        public Either<UUID, BlockPos> delayedLeashInfo;
        public double angularMomentum;

        private LeashData(Either<UUID, BlockPos> either) {
            this.delayedLeashInfo = either;
        }

        LeashData(Entity entity) {
            this.leashHolder = entity;
        }

        LeashData(int i) {
            this.delayedLeashHolderId = i;
        }

        public void setLeashHolder(Entity entity) {
            this.leashHolder = entity;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }

    public record Wrench(Vec3 force, double torque) {
        static Wrench ZERO = new Wrench(Vec3.ZERO, 0.0);

        static double torqueFromForce(Vec3 vec3d, Vec3 vec3d1) {
            return vec3d.z * vec3d1.x - vec3d.x * vec3d1.z;
        }

        static Wrench accumulate(List<Wrench> list) {
            if (list.isEmpty()) {
                return ZERO;
            }
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (Wrench leashable_b : list) {
                Vec3 vec3d = leashable_b.force;
                d0 += vec3d.x;
                d1 += vec3d.y;
                d2 += vec3d.z;
                d3 += leashable_b.torque;
            }
            return new Wrench(new Vec3(d0, d1, d2), d3);
        }

        public Wrench scale(double d0) {
            return new Wrench(this.force.scale(d0), this.torque * d0);
        }
    }
}

