/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.debug.DebugBrainDump;
import net.minecraft.util.debug.DebugGoalInfo;
import net.minecraft.util.debug.DebugPathInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.DropChances;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensing;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class Mob
extends LivingEntity
implements EquipmentUser,
Leashable,
Targeting {
    private static final EntityDataAccessor<Byte> DATA_MOB_FLAGS_ID = SynchedEntityData.defineId(Mob.class, EntityDataSerializers.BYTE);
    private static final int MOB_FLAG_NO_AI = 1;
    private static final int MOB_FLAG_LEFTHANDED = 2;
    private static final int MOB_FLAG_AGGRESSIVE = 4;
    protected static final int PICKUP_REACH = 1;
    private static final Vec3i ITEM_PICKUP_REACH = new Vec3i(1, 0, 1);
    private static final List<EquipmentSlot> EQUIPMENT_POPULATION_ORDER = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
    public static final float MAX_WEARING_ARMOR_CHANCE = 0.15f;
    public static final float WEARING_ARMOR_UPGRADE_MATERIAL_CHANCE = 0.1087f;
    public static final float WEARING_ARMOR_UPGRADE_MATERIAL_ATTEMPTS = 3.0f;
    public static final float MAX_PICKUP_LOOT_CHANCE = 0.55f;
    public static final float MAX_ENCHANTED_ARMOR_CHANCE = 0.5f;
    public static final float MAX_ENCHANTED_WEAPON_CHANCE = 0.25f;
    public static final int UPDATE_GOAL_SELECTOR_EVERY_N_TICKS = 2;
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    private static final boolean DEFAULT_CAN_PICK_UP_LOOT = false;
    private static final boolean DEFAULT_PERSISTENCE_REQUIRED = false;
    private static final boolean DEFAULT_LEFT_HANDED = false;
    private static final boolean DEFAULT_NO_AI = false;
    protected static final ResourceLocation RANDOM_SPAWN_BONUS_ID = ResourceLocation.withDefaultNamespace("random_spawn_bonus");
    public static final String TAG_DROP_CHANCES = "drop_chances";
    public static final String TAG_LEFT_HANDED = "LeftHanded";
    public static final String TAG_CAN_PICK_UP_LOOT = "CanPickUpLoot";
    public static final String TAG_NO_AI = "NoAI";
    public int ambientSoundTime;
    protected int xpReward;
    protected LookControl lookControl;
    protected MoveControl moveControl;
    protected JumpControl jumpControl;
    private final BodyRotationControl bodyRotationControl;
    protected PathNavigation navigation;
    public GoalSelector goalSelector;
    public GoalSelector targetSelector;
    @Nullable
    private LivingEntity target;
    private final Sensing sensing;
    private DropChances dropChances = DropChances.DEFAULT;
    private boolean canPickUpLoot = false;
    private boolean persistenceRequired = false;
    private final Map<PathType, Float> pathfindingMalus = Maps.newEnumMap(PathType.class);
    public Optional<ResourceKey<LootTable>> lootTable = Optional.empty();
    public long lootTableSeed;
    @Nullable
    private Leashable.LeashData leashData;
    private BlockPos homePosition = BlockPos.ZERO;
    private int homeRadius = -1;
    public boolean aware = true;

    protected Mob(EntityType<? extends Mob> entitytypes, net.minecraft.world.level.Level world) {
        super((EntityType<? extends LivingEntity>)entitytypes, world);
        this.goalSelector = new GoalSelector();
        this.targetSelector = new GoalSelector();
        this.lookControl = new LookControl(this);
        this.moveControl = new MoveControl(this);
        this.jumpControl = new JumpControl(this);
        this.bodyRotationControl = this.createBodyControl();
        this.navigation = this.createNavigation(world);
        this.sensing = new Sensing(this);
        if (world instanceof ServerLevel) {
            this.registerGoals();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.persistenceRequired = persistenceRequired;
    }

    protected void registerGoals() {
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 16.0);
    }

    protected PathNavigation createNavigation(net.minecraft.world.level.Level world) {
        return new GroundPathNavigation(this, world);
    }

    protected boolean shouldPassengersInheritMalus() {
        return false;
    }

    public float getPathfindingMalus(PathType pathtype) {
        Mob entityinsentient1;
        Entity entity = this.getControlledVehicle();
        Mob entityinsentient = entity instanceof Mob && (entityinsentient1 = (Mob)entity).shouldPassengersInheritMalus() ? entityinsentient1 : this;
        Float ofloat = entityinsentient.pathfindingMalus.get((Object)pathtype);
        return ofloat == null ? pathtype.getMalus() : ofloat.floatValue();
    }

    public void setPathfindingMalus(PathType pathtype, float f) {
        this.pathfindingMalus.put(pathtype, Float.valueOf(f));
    }

    public void onPathfindingStart() {
    }

    public void onPathfindingDone() {
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl(this);
    }

    public LookControl getLookControl() {
        return this.lookControl;
    }

    public MoveControl getMoveControl() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob) {
            Mob entityinsentient = (Mob)entity;
            return entityinsentient.getMoveControl();
        }
        return this.moveControl;
    }

    public JumpControl getJumpControl() {
        return this.jumpControl;
    }

    public PathNavigation getNavigation() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob) {
            Mob entityinsentient = (Mob)entity;
            return entityinsentient.getNavigation();
        }
        return this.navigation;
    }

    @Override
    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (!this.isNoAi() && entity instanceof Mob) {
            Mob entityinsentient1 = (Mob)entity;
            if (entity.canControlVehicle()) {
                Mob entityinsentient = entityinsentient1;
                return entityinsentient;
            }
        }
        LivingEntity entityinsentient = null;
        return entityinsentient;
    }

    public Sensing getSensing() {
        return this.sensing;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    @Nullable
    protected final LivingEntity getTargetFromBrain() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public void setTarget(@Nullable LivingEntity entityliving) {
        this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(LivingEntity entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.getTarget() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.getTarget() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.getTarget().isAlive() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.level().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.LivingEntity)ctarget, reason);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.target = entityliving;
        return true;
    }

    @Override
    public boolean canAttackType(EntityType<?> entitytypes) {
        return entitytypes != EntityType.GHAST;
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem itemprojectileweapon) {
        return false;
    }

    public void ate() {
        this.gameEvent(GameEvent.EAT);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_MOB_FLAGS_ID, (byte)0);
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    public void playAmbientSound() {
        this.makeSound(this.getAmbientSound());
    }

    @Override
    public void baseTick() {
        super.baseTick();
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("mobBaseTick");
        if (this.isAlive() && this.random.nextInt(1000) < this.ambientSoundTime++) {
            this.resetAmbientSoundTime();
            this.playAmbientSound();
        }
        gameprofilerfiller.pop();
    }

    @Override
    protected void playHurtSound(DamageSource damagesource) {
        this.resetAmbientSoundTime();
        super.playHurtSound(damagesource);
    }

    private void resetAmbientSoundTime() {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
    }

    @Override
    protected int getBaseExperienceReward(ServerLevel worldserver) {
        if (this.xpReward > 0) {
            int i = this.xpReward;
            for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
                ItemStack itemstack;
                if (!enumitemslot.canIncreaseExperience() || (itemstack = this.getItemBySlot(enumitemslot)).isEmpty() || !(this.dropChances.byEquipment(enumitemslot) <= 1.0f)) continue;
                i += 1 + this.random.nextInt(3);
            }
            return i;
        }
        return this.xpReward;
    }

    public void spawnAnim() {
        if (this.level().isClientSide()) {
            this.makePoofParticles();
        } else {
            this.level().broadcastEntityEvent(this, (byte)20);
        }
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 20) {
            this.spawnAnim();
        } else {
            super.handleEntityEvent(b0);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.tickCount % 5 == 0) {
            this.updateControlFlags();
        }
    }

    protected void updateControlFlags() {
        boolean flag = !(this.getControllingPassenger() instanceof Mob);
        boolean flag1 = !(this.getVehicle() instanceof AbstractBoat);
        this.goalSelector.setControlFlag(Goal.Flag.MOVE, flag);
        this.goalSelector.setControlFlag(Goal.Flag.JUMP, flag && flag1);
        this.goalSelector.setControlFlag(Goal.Flag.LOOK, flag);
    }

    @Override
    protected void tickHeadTurn(float f) {
        this.bodyRotationControl.clientTick();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    public SoundEvent getAmbientSound0() {
        return this.getAmbientSound();
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putBoolean(TAG_CAN_PICK_UP_LOOT, this.canPickUpLoot());
        valueoutput.putBoolean("PersistenceRequired", this.persistenceRequired);
        if (!this.dropChances.equals(DropChances.DEFAULT)) {
            valueoutput.store(TAG_DROP_CHANCES, DropChances.CODEC, this.dropChances);
        }
        this.writeLeashData(valueoutput, this.leashData);
        if (this.hasHome()) {
            valueoutput.putInt("home_radius", this.homeRadius);
            valueoutput.store("home_pos", BlockPos.CODEC, this.homePosition);
        }
        valueoutput.putBoolean(TAG_LEFT_HANDED, this.isLeftHanded());
        this.lootTable.ifPresent(resourcekey -> valueoutput.store("DeathLootTable", LootTable.KEY_CODEC, resourcekey));
        if (this.lootTableSeed != 0L) {
            valueoutput.putLong("DeathLootTableSeed", this.lootTableSeed);
        }
        if (this.isNoAi()) {
            valueoutput.putBoolean(TAG_NO_AI, this.isNoAi());
        }
        valueoutput.putBoolean("Bukkit.Aware", this.aware);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        boolean canPickUpLoot = valueinput.getBooleanOr(TAG_CAN_PICK_UP_LOOT, false);
        if (Mob.isLevelAtLeast(valueinput, 1) || canPickUpLoot) {
            this.setCanPickUpLoot(canPickUpLoot);
        }
        boolean persistenceRequired = valueinput.getBooleanOr("PersistenceRequired", false);
        if (Mob.isLevelAtLeast(valueinput, 1) || persistenceRequired) {
            this.persistenceRequired = persistenceRequired;
        }
        this.dropChances = valueinput.read(TAG_DROP_CHANCES, DropChances.CODEC).orElse(DropChances.DEFAULT);
        this.readLeashData(valueinput);
        this.homeRadius = valueinput.getIntOr("home_radius", -1);
        if (this.homeRadius >= 0) {
            this.homePosition = valueinput.read("home_pos", BlockPos.CODEC).orElse(BlockPos.ZERO);
        }
        this.setLeftHanded(valueinput.getBooleanOr(TAG_LEFT_HANDED, false));
        this.lootTable = valueinput.read("DeathLootTable", LootTable.KEY_CODEC);
        this.lootTableSeed = valueinput.getLongOr("DeathLootTableSeed", 0L);
        this.setNoAi(valueinput.getBooleanOr(TAG_NO_AI, false));
        this.aware = valueinput.getBooleanOr("Bukkit.Aware", this.aware);
    }

    @Override
    protected void dropFromLootTable(ServerLevel worldserver, DamageSource damagesource, boolean flag) {
        super.dropFromLootTable(worldserver, damagesource, flag);
        this.lootTable = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> getLootTable() {
        return this.lootTable.isPresent() ? this.lootTable : super.getLootTable();
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setZza(float f) {
        this.zza = f;
    }

    public void setYya(float f) {
        this.yya = f;
    }

    public void setXxa(float f) {
        this.xxa = f;
    }

    @Override
    public void setSpeed(float f) {
        super.setSpeed(f);
        this.setZza(f);
    }

    public void stopInPlace() {
        this.getNavigation().stop();
        this.setXxa(0.0f);
        this.setYya(0.0f);
        this.setSpeed(0.0f);
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.resetAngularLeashMomentum();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("looting");
        net.minecraft.world.level.Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (this.canPickUpLoot() && this.isAlive() && !this.dead && worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                Vec3i baseblockposition = this.getPickupReach();
                for (ItemEntity entityitem : this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(baseblockposition.getX(), baseblockposition.getY(), baseblockposition.getZ()))) {
                    if (entityitem.isRemoved() || entityitem.getItem().isEmpty() || entityitem.hasPickUpDelay() || !this.wantsToPickUp(worldserver, entityitem.getItem())) continue;
                    this.pickUpItem(worldserver, entityitem);
                }
            }
        }
        gameprofilerfiller.pop();
    }

    protected Vec3i getPickupReach() {
        return ITEM_PICKUP_REACH;
    }

    protected void pickUpItem(ServerLevel worldserver, ItemEntity entityitem) {
        ItemStack itemstack = entityitem.getItem();
        ItemStack itemstack1 = this.equipItemIfPossible(worldserver, itemstack.copy(), entityitem);
        if (!itemstack1.isEmpty()) {
            this.onItemPickup(entityitem);
            this.take(entityitem, itemstack1.getCount());
            itemstack.shrink(itemstack1.getCount());
            if (itemstack.isEmpty()) {
                entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack equipItemIfPossible(ServerLevel worldserver, ItemStack itemstack) {
        return this.equipItemIfPossible(worldserver, itemstack, null);
    }

    public ItemStack equipItemIfPossible(ServerLevel worldserver, ItemStack itemstack, ItemEntity entityitem) {
        boolean canPickup;
        EquipmentSlot enumitemslot = this.getEquipmentSlotForItem(itemstack);
        if (!this.isEquippableInSlot(itemstack, enumitemslot)) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack1 = this.getItemBySlot(enumitemslot);
        boolean flag = this.canReplaceCurrentItem(itemstack, itemstack1, enumitemslot);
        if (enumitemslot.isArmor() && !flag) {
            enumitemslot = EquipmentSlot.MAINHAND;
            itemstack1 = this.getItemBySlot(enumitemslot);
            flag = itemstack1.isEmpty();
        }
        boolean bl = canPickup = flag && this.canHoldItem(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.dropChances.byEquipment(enumitemslot);
            if (!itemstack1.isEmpty() && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.spawnAtLocation(worldserver, itemstack1);
                this.forceDrops = false;
            }
            ItemStack itemstack2 = enumitemslot.limit(itemstack);
            this.setItemSlotAndDropWhenKilled(enumitemslot, itemstack2);
            return itemstack2;
        }
        return ItemStack.EMPTY;
    }

    protected void setItemSlotAndDropWhenKilled(EquipmentSlot enumitemslot, ItemStack itemstack) {
        this.setItemSlot(enumitemslot, itemstack);
        this.setGuaranteedDrop(enumitemslot);
        this.persistenceRequired = true;
    }

    protected boolean canShearEquipment(Player entityhuman) {
        return !this.isVehicle();
    }

    public void setGuaranteedDrop(EquipmentSlot enumitemslot) {
        this.dropChances = this.dropChances.withGuaranteedDrop(enumitemslot);
    }

    protected boolean canReplaceCurrentItem(ItemStack itemstack, ItemStack itemstack1, EquipmentSlot enumitemslot) {
        return itemstack1.isEmpty() ? true : (enumitemslot.isArmor() ? this.compareArmor(itemstack, itemstack1, enumitemslot) : (enumitemslot == EquipmentSlot.MAINHAND ? this.compareWeapons(itemstack, itemstack1, enumitemslot) : false));
    }

    private boolean compareArmor(ItemStack itemstack, ItemStack itemstack1, EquipmentSlot enumitemslot) {
        if (EnchantmentHelper.has(itemstack1, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
            return false;
        }
        double d0 = this.getApproximateAttributeWith(itemstack, Attributes.ARMOR, enumitemslot);
        double d1 = this.getApproximateAttributeWith(itemstack1, Attributes.ARMOR, enumitemslot);
        double d2 = this.getApproximateAttributeWith(itemstack, Attributes.ARMOR_TOUGHNESS, enumitemslot);
        double d3 = this.getApproximateAttributeWith(itemstack1, Attributes.ARMOR_TOUGHNESS, enumitemslot);
        return d0 != d1 ? d0 > d1 : (d2 != d3 ? d2 > d3 : this.canReplaceEqualItem(itemstack, itemstack1));
    }

    private boolean compareWeapons(ItemStack itemstack, ItemStack itemstack1, EquipmentSlot enumitemslot) {
        double d1;
        double d0;
        TagKey<Item> tagkey = this.getPreferredWeaponType();
        if (tagkey != null) {
            if (itemstack1.is(tagkey) && !itemstack.is(tagkey)) {
                return false;
            }
            if (!itemstack1.is(tagkey) && itemstack.is(tagkey)) {
                return true;
            }
        }
        return (d0 = this.getApproximateAttributeWith(itemstack, Attributes.ATTACK_DAMAGE, enumitemslot)) != (d1 = this.getApproximateAttributeWith(itemstack1, Attributes.ATTACK_DAMAGE, enumitemslot)) ? d0 > d1 : this.canReplaceEqualItem(itemstack, itemstack1);
    }

    private double getApproximateAttributeWith(ItemStack itemstack, Holder<Attribute> holder, EquipmentSlot enumitemslot) {
        double d0 = this.getAttributes().hasAttribute(holder) ? this.getAttributeBaseValue(holder) : 0.0;
        ItemAttributeModifiers itemattributemodifiers = itemstack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        return itemattributemodifiers.compute(d0, enumitemslot);
    }

    public boolean canReplaceEqualItem(ItemStack itemstack, ItemStack itemstack1) {
        int j;
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set = itemstack1.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).entrySet();
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set1 = itemstack.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).entrySet();
        if (set1.size() != set.size()) {
            return set1.size() > set.size();
        }
        int i = itemstack.getDamageValue();
        return i != (j = itemstack1.getDamageValue()) ? i < j : itemstack.has(DataComponents.CUSTOM_NAME) && !itemstack1.has(DataComponents.CUSTOM_NAME);
    }

    public boolean canHoldItem(ItemStack itemstack) {
        return true;
    }

    public boolean wantsToPickUp(ServerLevel worldserver, ItemStack itemstack) {
        return this.canHoldItem(itemstack);
    }

    @Nullable
    public TagKey<Item> getPreferredWeaponType() {
        return null;
    }

    public boolean removeWhenFarAway(double d0) {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return this.isPassenger();
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && !this.getType().isAllowedInPeaceful()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.isPersistenceRequired() && !this.requiresCustomPersistence()) {
            Player entity = this.level().getNearestPlayer(this, -1.0);
            if (entity != null) {
                int i;
                int j;
                double d0 = entity.distanceToSqr(this);
                if (d0 > (double)(j = (i = this.getType().getCategory().getDespawnDistance()) * i) && this.removeWhenFarAway(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                int k = this.getType().getCategory().getNoDespawnDistance();
                int l = k * k;
                if (this.noActionTime > 600 && this.random.nextInt(800) == 0 && d0 > (double)l && this.removeWhenFarAway(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                } else if (d0 < (double)l) {
                    this.noActionTime = 0;
                }
            }
        } else {
            this.noActionTime = 0;
        }
    }

    @Override
    protected final void serverAiStep() {
        ++this.noActionTime;
        if (!this.aware) {
            return;
        }
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("sensing");
        this.sensing.tick();
        gameprofilerfiller.pop();
        int i = this.tickCount + this.getId();
        if (i % 2 != 0 && this.tickCount > 1) {
            gameprofilerfiller.push("targetSelector");
            this.targetSelector.tickRunningGoals(false);
            gameprofilerfiller.pop();
            gameprofilerfiller.push("goalSelector");
            this.goalSelector.tickRunningGoals(false);
            gameprofilerfiller.pop();
        } else {
            gameprofilerfiller.push("targetSelector");
            this.targetSelector.tick();
            gameprofilerfiller.pop();
            gameprofilerfiller.push("goalSelector");
            this.goalSelector.tick();
            gameprofilerfiller.pop();
        }
        gameprofilerfiller.push("navigation");
        this.navigation.tick();
        gameprofilerfiller.pop();
        gameprofilerfiller.push("mob tick");
        this.customServerAiStep((ServerLevel)this.level());
        gameprofilerfiller.pop();
        gameprofilerfiller.push("controls");
        gameprofilerfiller.push("move");
        this.moveControl.tick();
        gameprofilerfiller.popPush("look");
        this.lookControl.tick();
        gameprofilerfiller.popPush("jump");
        this.jumpControl.tick();
        gameprofilerfiller.pop();
        gameprofilerfiller.pop();
    }

    protected void customServerAiStep(ServerLevel worldserver) {
    }

    public int getMaxHeadXRot() {
        return 40;
    }

    public int getMaxHeadYRot() {
        return 75;
    }

    protected void clampHeadRotationToBody() {
        float f = this.getMaxHeadYRot();
        float f1 = this.getYHeadRot();
        float f2 = Mth.wrapDegrees(this.yBodyRot - f1);
        float f3 = Mth.clamp(Mth.wrapDegrees(this.yBodyRot - f1), -f, f);
        float f4 = f1 + f2 - f3;
        this.setYHeadRot(f4);
    }

    public int getHeadRotSpeed() {
        return 10;
    }

    public void lookAt(Entity entity, float f, float f1) {
        double d2;
        double d0 = entity.getX() - this.getX();
        double d1 = entity.getZ() - this.getZ();
        if (entity instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            d2 = entityliving.getEyeY() - this.getEyeY();
        } else {
            d2 = (entity.getBoundingBox().minY + entity.getBoundingBox().maxY) / 2.0 - this.getEyeY();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f2 = (float)(Mth.atan2(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(Mth.atan2(d2, d3) * 57.2957763671875));
        this.setXRot(this.rotlerp(this.getXRot(), f3, f1));
        this.setYRot(this.rotlerp(this.getYRot(), f2, f));
    }

    private float rotlerp(float f, float f1, float f2) {
        float f3 = Mth.wrapDegrees(f1 - f);
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> entitytypes, LevelAccessor generatoraccess, EntitySpawnReason entityspawnreason, BlockPos blockposition, RandomSource randomsource) {
        BlockPos blockposition1 = blockposition.below();
        return EntitySpawnReason.isSpawner(entityspawnreason) || generatoraccess.getBlockState(blockposition1).isValidSpawn(generatoraccess, blockposition1, entitytypes);
    }

    public boolean checkSpawnRules(LevelAccessor generatoraccess, EntitySpawnReason entityspawnreason) {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader iworldreader) {
        return !iworldreader.containsAnyLiquid(this.getBoundingBox()) && iworldreader.isUnobstructed(this);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    public boolean isMaxGroupSizeReached(int i) {
        return false;
    }

    @Override
    public int getMaxFallDistance() {
        if (this.getTarget() == null) {
            return this.getComfortableFallDistance(0.0f);
        }
        int i = (int)(this.getHealth() - this.getMaxHealth() * 0.33f);
        if ((i -= (3 - this.level().getDifficulty().getId()) * 4) < 0) {
            i = 0;
        }
        return this.getComfortableFallDistance(i);
    }

    public ItemStack getBodyArmorItem() {
        return this.getItemBySlot(EquipmentSlot.BODY);
    }

    public boolean isSaddled() {
        return this.hasValidEquippableItemForSlot(EquipmentSlot.SADDLE);
    }

    public boolean isWearingBodyArmor() {
        return this.hasValidEquippableItemForSlot(EquipmentSlot.BODY);
    }

    private boolean hasValidEquippableItemForSlot(EquipmentSlot enumitemslot) {
        return this.hasItemInSlot(enumitemslot) && this.isEquippableInSlot(this.getItemBySlot(enumitemslot), enumitemslot);
    }

    public void setBodyArmorItem(ItemStack itemstack) {
        this.setItemSlotAndDropWhenKilled(EquipmentSlot.BODY, itemstack);
    }

    public Container createEquipmentSlotContainer(final EquipmentSlot enumitemslot) {
        return new ContainerSingleItem(){
            public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
            private int maxStack = 99;

            @Override
            public ItemStack getTheItem() {
                return Mob.this.getItemBySlot(enumitemslot);
            }

            @Override
            public void setTheItem(ItemStack itemstack) {
                Mob.this.setItemSlot(enumitemslot, itemstack);
                if (!itemstack.isEmpty()) {
                    Mob.this.setGuaranteedDrop(enumitemslot);
                    Mob.this.setPersistenceRequired();
                }
            }

            @Override
            public void setChanged() {
            }

            @Override
            public boolean stillValid(Player entityhuman) {
                return entityhuman.getVehicle() == Mob.this || entityhuman.canInteractWithEntity(Mob.this, 4.0);
            }

            @Override
            public List<ItemStack> getContents() {
                return Arrays.asList(this.getTheItem());
            }

            @Override
            public void onOpen(CraftHumanEntity who) {
                this.transaction.add(who);
            }

            @Override
            public void onClose(CraftHumanEntity who) {
                this.transaction.remove(who);
            }

            @Override
            public List<HumanEntity> getViewers() {
                return this.transaction;
            }

            @Override
            public int getMaxStackSize() {
                return this.maxStack;
            }

            @Override
            public void setMaxStackSize(int size) {
                this.maxStack = size;
            }

            @Override
            public InventoryHolder getOwner() {
                return (InventoryHolder)Mob.this.getBukkitEntity();
            }

            @Override
            public Location getLocation() {
                return Mob.this.getBukkitEntity().getLocation();
            }
        };
    }

    @Override
    protected void dropCustomDeathLoot(ServerLevel worldserver, DamageSource damagesource, boolean flag) {
        super.dropCustomDeathLoot(worldserver, damagesource, flag);
        for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
            ItemStack itemstack = this.getItemBySlot(enumitemslot);
            float f = this.dropChances.byEquipment(enumitemslot);
            if (f == 0.0f) continue;
            boolean flag1 = this.dropChances.isPreserved(enumitemslot);
            Entity entity = damagesource.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity entityliving = (LivingEntity)entity;
                net.minecraft.world.level.Level world = this.level();
                if (world instanceof ServerLevel) {
                    ServerLevel worldserver1 = (ServerLevel)world;
                    f = EnchantmentHelper.processEquipmentDropChance(worldserver1, entityliving, damagesource, f);
                }
            }
            if (itemstack.isEmpty() || EnchantmentHelper.has(itemstack, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || !flag && !flag1 || !(this.random.nextFloat() < f)) continue;
            if (!flag1 && itemstack.isDamageableItem()) {
                itemstack.setDamageValue(itemstack.getMaxDamage() - this.random.nextInt(1 + this.random.nextInt(Math.max(itemstack.getMaxDamage() - 3, 1))));
            }
            this.spawnAtLocation(worldserver, itemstack);
            this.setItemSlot(enumitemslot, ItemStack.EMPTY);
        }
    }

    public DropChances getDropChances() {
        return this.dropChances;
    }

    public void dropPreservedEquipment(ServerLevel worldserver) {
        this.dropPreservedEquipment(worldserver, itemstack -> true);
    }

    public Set<EquipmentSlot> dropPreservedEquipment(ServerLevel worldserver, Predicate<ItemStack> predicate) {
        HashSet<EquipmentSlot> set = new HashSet<EquipmentSlot>();
        for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
            ItemStack itemstack = this.getItemBySlot(enumitemslot);
            if (itemstack.isEmpty()) continue;
            if (!predicate.test(itemstack)) {
                set.add(enumitemslot);
                continue;
            }
            if (!this.dropChances.isPreserved(enumitemslot)) continue;
            this.setItemSlot(enumitemslot, ItemStack.EMPTY);
            this.spawnAtLocation(worldserver, itemstack);
        }
        return set;
    }

    private LootParams createEquipmentParams(ServerLevel worldserver) {
        return new LootParams.Builder(worldserver).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.THIS_ENTITY, this).create(LootContextParamSets.EQUIPMENT);
    }

    public void equip(EquipmentTable equipmenttable) {
        this.equip(equipmenttable.lootTable(), equipmenttable.slotDropChances());
    }

    public void equip(ResourceKey<LootTable> resourcekey, Map<EquipmentSlot, Float> map) {
        net.minecraft.world.level.Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.equip(resourcekey, this.createEquipmentParams(worldserver), map);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomsource, DifficultyInstance difficultydamagescaler) {
        if (randomsource.nextFloat() < 0.15f * difficultydamagescaler.getSpecialMultiplier()) {
            int i = randomsource.nextInt(3);
            int j = 1;
            while ((float)j <= 3.0f) {
                if (randomsource.nextFloat() < 0.1087f) {
                    ++i;
                }
                ++j;
            }
            float f = this.level().getDifficulty() == Difficulty.HARD ? 0.1f : 0.25f;
            boolean flag = true;
            for (EquipmentSlot enumitemslot : EQUIPMENT_POPULATION_ORDER) {
                Item item;
                ItemStack itemstack = this.getItemBySlot(enumitemslot);
                if (!flag && randomsource.nextFloat() < f) break;
                flag = false;
                if (!itemstack.isEmpty() || (item = Mob.getEquipmentForSlot(enumitemslot, i)) == null) continue;
                this.setItemSlot(enumitemslot, new ItemStack(item));
            }
        }
    }

    @Nullable
    public static Item getEquipmentForSlot(EquipmentSlot enumitemslot, int i) {
        switch (enumitemslot) {
            case HEAD: {
                if (i == 0) {
                    return Items.LEATHER_HELMET;
                }
                if (i == 1) {
                    return Items.COPPER_HELMET;
                }
                if (i == 2) {
                    return Items.GOLDEN_HELMET;
                }
                if (i == 3) {
                    return Items.CHAINMAIL_HELMET;
                }
                if (i == 4) {
                    return Items.IRON_HELMET;
                }
                if (i == 5) {
                    return Items.DIAMOND_HELMET;
                }
            }
            case CHEST: {
                if (i == 0) {
                    return Items.LEATHER_CHESTPLATE;
                }
                if (i == 1) {
                    return Items.COPPER_CHESTPLATE;
                }
                if (i == 2) {
                    return Items.GOLDEN_CHESTPLATE;
                }
                if (i == 3) {
                    return Items.CHAINMAIL_CHESTPLATE;
                }
                if (i == 4) {
                    return Items.IRON_CHESTPLATE;
                }
                if (i == 5) {
                    return Items.DIAMOND_CHESTPLATE;
                }
            }
            case LEGS: {
                if (i == 0) {
                    return Items.LEATHER_LEGGINGS;
                }
                if (i == 1) {
                    return Items.COPPER_LEGGINGS;
                }
                if (i == 2) {
                    return Items.GOLDEN_LEGGINGS;
                }
                if (i == 3) {
                    return Items.CHAINMAIL_LEGGINGS;
                }
                if (i == 4) {
                    return Items.IRON_LEGGINGS;
                }
                if (i == 5) {
                    return Items.DIAMOND_LEGGINGS;
                }
            }
            case FEET: {
                if (i == 0) {
                    return Items.LEATHER_BOOTS;
                }
                if (i == 1) {
                    return Items.COPPER_BOOTS;
                }
                if (i == 2) {
                    return Items.GOLDEN_BOOTS;
                }
                if (i == 3) {
                    return Items.CHAINMAIL_BOOTS;
                }
                if (i == 4) {
                    return Items.IRON_BOOTS;
                }
                if (i != 5) break;
                return Items.DIAMOND_BOOTS;
            }
        }
        return null;
    }

    protected void populateDefaultEquipmentEnchantments(ServerLevelAccessor worldaccess, RandomSource randomsource, DifficultyInstance difficultydamagescaler) {
        this.enchantSpawnedWeapon(worldaccess, randomsource, difficultydamagescaler);
        for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
            if (enumitemslot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            this.enchantSpawnedArmor(worldaccess, randomsource, enumitemslot, difficultydamagescaler);
        }
    }

    protected void enchantSpawnedWeapon(ServerLevelAccessor worldaccess, RandomSource randomsource, DifficultyInstance difficultydamagescaler) {
        this.enchantSpawnedEquipment(worldaccess, EquipmentSlot.MAINHAND, randomsource, 0.25f, difficultydamagescaler);
    }

    protected void enchantSpawnedArmor(ServerLevelAccessor worldaccess, RandomSource randomsource, EquipmentSlot enumitemslot, DifficultyInstance difficultydamagescaler) {
        this.enchantSpawnedEquipment(worldaccess, enumitemslot, randomsource, 0.5f, difficultydamagescaler);
    }

    private void enchantSpawnedEquipment(ServerLevelAccessor worldaccess, EquipmentSlot enumitemslot, RandomSource randomsource, float f, DifficultyInstance difficultydamagescaler) {
        ItemStack itemstack = this.getItemBySlot(enumitemslot);
        if (!itemstack.isEmpty() && randomsource.nextFloat() < f * difficultydamagescaler.getSpecialMultiplier()) {
            EnchantmentHelper.enchantItemFromProvider(itemstack, worldaccess.registryAccess(), VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, difficultydamagescaler, randomsource);
            this.setItemSlot(enumitemslot, itemstack);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldaccess, DifficultyInstance difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable SpawnGroupData groupdataentity) {
        RandomSource randomsource = worldaccess.getRandom();
        AttributeInstance attributemodifiable = Objects.requireNonNull(this.getAttribute(Attributes.FOLLOW_RANGE));
        if (!attributemodifiable.hasModifier(RANDOM_SPAWN_BONUS_ID)) {
            attributemodifiable.addPermanentModifier(new AttributeModifier(RANDOM_SPAWN_BONUS_ID, randomsource.triangle(0.0, 0.11485000000000001), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        this.setLeftHanded(randomsource.nextFloat() < 0.05f);
        return groupdataentity;
    }

    public void setPersistenceRequired() {
        this.persistenceRequired = true;
    }

    @Override
    public void setDropChance(EquipmentSlot enumitemslot, float f) {
        this.dropChances = this.dropChances.withEquipmentChance(enumitemslot, f);
    }

    @Override
    public boolean canPickUpLoot() {
        return this.canPickUpLoot;
    }

    public void setCanPickUpLoot(boolean flag) {
        this.canPickUpLoot = flag;
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EquipmentSlot enumitemslot) {
        return this.canPickUpLoot();
    }

    public boolean isPersistenceRequired() {
        return this.persistenceRequired;
    }

    @Override
    public final InteractionResult interact(Player entityhuman, InteractionHand enumhand) {
        if (!this.isAlive()) {
            return InteractionResult.PASS;
        }
        InteractionResult enuminteractionresult = this.checkAndHandleImportantInteractions(entityhuman, enumhand);
        if (enuminteractionresult.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, entityhuman);
            return enuminteractionresult;
        }
        InteractionResult enuminteractionresult1 = super.interact(entityhuman, enumhand);
        if (enuminteractionresult1 != InteractionResult.PASS) {
            return enuminteractionresult1;
        }
        enuminteractionresult = this.mobInteract(entityhuman, enumhand);
        if (enuminteractionresult.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, entityhuman);
            return enuminteractionresult;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult checkAndHandleImportantInteractions(Player entityhuman, InteractionHand enumhand) {
        InteractionResult enuminteractionresult;
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (itemstack.is(Items.NAME_TAG) && (enuminteractionresult = itemstack.interactLivingEntity(entityhuman, this, enumhand)).consumesAction()) {
            return enuminteractionresult;
        }
        if (itemstack.getItem() instanceof SpawnEggItem) {
            if (this.level() instanceof ServerLevel) {
                SpawnEggItem itemmonsteregg = (SpawnEggItem)itemstack.getItem();
                Optional<Mob> optional = itemmonsteregg.spawnOffspringFromSpawnEgg(entityhuman, this, this.getType(), (ServerLevel)this.level(), this.position(), itemstack);
                optional.ifPresent(entityinsentient -> this.onOffspringSpawnedFromEgg(entityhuman, (Mob)entityinsentient));
                if (optional.isEmpty()) {
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.PASS;
    }

    protected void onOffspringSpawnedFromEgg(Player entityhuman, Mob entityinsentient) {
    }

    protected InteractionResult mobInteract(Player entityhuman, InteractionHand enumhand) {
        return InteractionResult.PASS;
    }

    protected void usePlayerItem(Player entityhuman, InteractionHand enumhand, ItemStack itemstack) {
        int i = itemstack.getCount();
        UseRemainder useremainder = itemstack.get(DataComponents.USE_REMAINDER);
        itemstack.consume(1, entityhuman);
        if (useremainder != null) {
            boolean flag = entityhuman.hasInfiniteMaterials();
            Objects.requireNonNull(entityhuman);
            ItemStack itemstack1 = useremainder.convertIntoRemainder(itemstack, i, flag, entityhuman::handleExtraItemsCreatedOnUse);
            entityhuman.setItemInHand(enumhand, itemstack1);
        }
    }

    public boolean isWithinHome() {
        return this.isWithinHome(this.blockPosition());
    }

    public boolean isWithinHome(BlockPos blockposition) {
        return this.homeRadius == -1 ? true : this.homePosition.distSqr(blockposition) < (double)(this.homeRadius * this.homeRadius);
    }

    public boolean isWithinHome(Vec3 vec3d) {
        return this.homeRadius == -1 ? true : this.homePosition.distToCenterSqr(vec3d) < (double)(this.homeRadius * this.homeRadius);
    }

    public void setHomeTo(BlockPos blockposition, int i) {
        this.homePosition = blockposition;
        this.homeRadius = i;
    }

    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    public int getHomeRadius() {
        return this.homeRadius;
    }

    public void clearHome() {
        this.homeRadius = -1;
    }

    public boolean hasHome() {
        return this.homeRadius != -1;
    }

    @Nullable
    public <T extends Mob> T convertTo(EntityType<T> entitytypes, ConversionParams conversionparams, EntitySpawnReason entityspawnreason, ConversionParams.AfterConversion<T> conversionparams_a) {
        return this.convertTo(entitytypes, conversionparams, entityspawnreason, conversionparams_a, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends Mob> T convertTo(EntityType<T> entitytypes, ConversionParams conversionparams, EntitySpawnReason entityspawnreason, ConversionParams.AfterConversion<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.isRemoved()) {
            return null;
        }
        Mob t0 = (Mob)entitytypes.create(this.level(), entityspawnreason);
        if (t0 == null) {
            return null;
        }
        conversionparams.type().convert(this, t0, conversionparams);
        conversionparams_a.finalizeConversion(t0);
        net.minecraft.world.level.Level world = this.level();
        if (transformReason == null) {
            return (T)t0;
        }
        if (CraftEventFactory.callEntityTransformEvent((LivingEntity)this, t0, transformReason).isCancelled()) {
            return null;
        }
        conversionparams.type().postConvert(this, t0, conversionparams);
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            worldserver.addFreshEntity(t0, spawnReason);
        }
        if (conversionparams.type().shouldDiscardAfterConversion()) {
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        }
        return (T)t0;
    }

    @Nullable
    public <T extends Mob> T convertTo(EntityType<T> entitytypes, ConversionParams conversionparams, ConversionParams.AfterConversion<T> conversionparams_a) {
        return this.convertTo(entitytypes, conversionparams, conversionparams_a, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends Mob> T convertTo(EntityType<T> entitytypes, ConversionParams conversionparams, ConversionParams.AfterConversion<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        return this.convertTo(entitytypes, conversionparams, EntitySpawnReason.CONVERSION, conversionparams_a, transformReason, spawnReason);
    }

    @Override
    @Nullable
    public Leashable.LeashData getLeashData() {
        return this.leashData;
    }

    private void resetAngularLeashMomentum() {
        if (this.leashData != null) {
            this.leashData.angularMomentum = 0.0;
        }
    }

    @Override
    public void setLeashData(@Nullable Leashable.LeashData leashable_a) {
        this.leashData = leashable_a;
    }

    @Override
    public void onLeashRemoved() {
        if (this.getLeashData() == null) {
            this.clearHome();
        }
    }

    @Override
    public void leashTooFarBehaviour() {
        Leashable.super.leashTooFarBehaviour();
        this.goalSelector.disableControlFlag(Goal.Flag.MOVE);
    }

    @Override
    public boolean canBeLeashed() {
        return !(this instanceof Enemy);
    }

    @Override
    public boolean startRiding(Entity entity, boolean flag, boolean flag1) {
        boolean flag2 = super.startRiding(entity, flag, flag1);
        if (flag2 && this.isLeashed()) {
            this.level().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            this.dropLeash();
        }
        return flag2;
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && !this.isNoAi();
    }

    public void setNoAi(boolean flag) {
        byte b0 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void setLeftHanded(boolean flag) {
        byte b0 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void setAggressive(boolean flag) {
        byte b0 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean isNoAi() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 1) != 0;
    }

    public boolean isLeftHanded() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 2) != 0;
    }

    public boolean isAggressive() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 4) != 0;
    }

    public void setBaby(boolean flag) {
    }

    @Override
    public HumanoidArm getMainArm() {
        return this.isLeftHanded() ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    public boolean isWithinMeleeAttackRange(LivingEntity entityliving) {
        return this.getAttackBoundingBox().intersects(entityliving.getHitbox());
    }

    protected AABB getAttackBoundingBox() {
        AABB axisalignedbb;
        Entity entity = this.getVehicle();
        if (entity != null) {
            AABB axisalignedbb1 = entity.getBoundingBox();
            AABB axisalignedbb2 = this.getBoundingBox();
            axisalignedbb = new AABB(Math.min(axisalignedbb2.minX, axisalignedbb1.minX), axisalignedbb2.minY, Math.min(axisalignedbb2.minZ, axisalignedbb1.minZ), Math.max(axisalignedbb2.maxX, axisalignedbb1.maxX), axisalignedbb2.maxY, Math.max(axisalignedbb2.maxZ, axisalignedbb1.maxZ));
        } else {
            axisalignedbb = this.getBoundingBox();
        }
        return axisalignedbb.inflate(DEFAULT_ATTACK_REACH, 0.0, DEFAULT_ATTACK_REACH);
    }

    @Override
    public boolean doHurtTarget(ServerLevel worldserver, Entity entity) {
        boolean flag;
        float f = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        ItemStack itemstack = this.getWeaponItem();
        DamageSource damagesource = Optional.ofNullable(itemstack.getItem().getDamageSource(this)).orElse(this.damageSources().mobAttack(this));
        f = EnchantmentHelper.modifyDamage(worldserver, itemstack, entity, damagesource, f);
        if (flag = entity.hurtServer(worldserver, damagesource, f += itemstack.getItem().getAttackDamageBonus(entity, f, damagesource))) {
            float f1 = this.getKnockback(entity, damagesource);
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                LivingEntity entityliving = (LivingEntity)entity;
                entityliving.knockback(f1 * 0.5f, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if (entity instanceof LivingEntity) {
                LivingEntity entityliving1 = (LivingEntity)entity;
                itemstack.hurtEnemy(entityliving1, this);
            }
            EnchantmentHelper.doPostAttackEffects(worldserver, entity, damagesource);
            this.setLastHurtMob(entity);
            this.playAttackSound();
        }
        return flag;
    }

    protected void playAttackSound() {
    }

    protected boolean isSunBurnTick() {
        if (this.level().isBrightOutside() && !this.level().isClientSide()) {
            boolean flag;
            float f = this.getLightLevelDependentMagicValue();
            BlockPos blockposition = BlockPos.containing(this.getX(), this.getEyeY(), this.getZ());
            boolean bl = flag = this.isInWaterOrRain() || this.isInPowderSnow || this.wasInPowderSnow;
            if (f > 0.5f && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && !flag && this.level().canSeeSky(blockposition)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void jumpInLiquid(TagKey<Fluid> tagkey) {
        if (this.getNavigation().canFloat()) {
            super.jumpInLiquid(tagkey);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void removeFreeWill() {
        this.removeAllGoals(pathfindergoal -> true);
        this.getBrain().removeAllBehaviors();
    }

    public void removeAllGoals(Predicate<Goal> predicate) {
        this.goalSelector.removeAllGoals(predicate);
    }

    @Override
    protected void removeAfterChangingDimensions() {
        super.removeAfterChangingDimensions();
        for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
            ItemStack itemstack = this.getItemBySlot(enumitemslot);
            if (itemstack.isEmpty()) continue;
            itemstack.setCount(0);
        }
    }

    @Override
    @Nullable
    public ItemStack getPickResult() {
        SpawnEggItem itemmonsteregg = SpawnEggItem.byId(this.getType());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }

    @Override
    protected void onAttributeUpdated(Holder<Attribute> holder) {
        super.onAttributeUpdated(holder);
        if (holder.is(Attributes.FOLLOW_RANGE) || holder.is(Attributes.TEMPT_RANGE)) {
            this.getNavigation().updatePathfinderMaxVisitedNodes();
        }
    }

    @Override
    public void registerDebugValues(ServerLevel worldserver, DebugValueSource.Registration debugvaluesource_a) {
        debugvaluesource_a.register(DebugSubscriptions.ENTITY_PATHS, () -> {
            Path pathentity = this.getNavigation().getPath();
            return pathentity != null && pathentity.debugData() != null ? new DebugPathInfo(pathentity.copy(), this.getNavigation().getMaxDistanceToWaypoint()) : null;
        });
        debugvaluesource_a.register(DebugSubscriptions.GOAL_SELECTORS, () -> {
            Set<WrappedGoal> set = this.goalSelector.getAvailableGoals();
            ArrayList<DebugGoalInfo.DebugGoal> list = new ArrayList<DebugGoalInfo.DebugGoal>(set.size());
            set.forEach(pathfindergoalwrapped -> list.add(new DebugGoalInfo.DebugGoal(pathfindergoalwrapped.getPriority(), pathfindergoalwrapped.isRunning(), pathfindergoalwrapped.getGoal().getClass().getSimpleName())));
            return new DebugGoalInfo(list);
        });
        if (!this.brain.isBrainDead()) {
            debugvaluesource_a.register(DebugSubscriptions.BRAINS, () -> DebugBrainDump.takeBrainDump(worldserver, this));
        }
    }
}

