/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeSupplier {
    private final Map<Holder<Attribute>, AttributeInstance> instances;

    AttributeSupplier(Map<Holder<Attribute>, AttributeInstance> var0) {
        this.instances = var0;
    }

    private AttributeInstance getAttributeInstance(Holder<Attribute> var0) {
        AttributeInstance var1 = this.instances.get(var0);
        if (var1 == null) {
            throw new IllegalArgumentException("Can't find attribute " + var0.getRegisteredName());
        }
        return var1;
    }

    public double getValue(Holder<Attribute> var0) {
        return this.getAttributeInstance(var0).getValue();
    }

    public double getBaseValue(Holder<Attribute> var0) {
        return this.getAttributeInstance(var0).getBaseValue();
    }

    public double getModifierValue(Holder<Attribute> var0, ResourceLocation var1) {
        AttributeModifier var2 = this.getAttributeInstance(var0).getModifier(var1);
        if (var2 == null) {
            throw new IllegalArgumentException("Can't find modifier " + String.valueOf(var1) + " on attribute " + var0.getRegisteredName());
        }
        return var2.amount();
    }

    @Nullable
    public AttributeInstance createInstance(Consumer<AttributeInstance> var0, Holder<Attribute> var1) {
        AttributeInstance var2 = this.instances.get(var1);
        if (var2 == null) {
            return null;
        }
        AttributeInstance var3 = new AttributeInstance(var1, var0);
        var3.replaceFrom(var2);
        return var3;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasAttribute(Holder<Attribute> var0) {
        return this.instances.containsKey(var0);
    }

    public boolean hasModifier(Holder<Attribute> var0, ResourceLocation var1) {
        AttributeInstance var2 = this.instances.get(var0);
        return var2 != null && var2.getModifier(var1) != null;
    }

    public static class Builder {
        private final ImmutableMap.Builder<Holder<Attribute>, AttributeInstance> builder = ImmutableMap.builder();
        private boolean instanceFrozen;

        private AttributeInstance create(Holder<Attribute> var0) {
            AttributeInstance var12 = new AttributeInstance(var0, var1 -> {
                if (this.instanceFrozen) {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance: " + var0.getRegisteredName());
                }
            });
            this.builder.put(var0, (Object)var12);
            return var12;
        }

        public Builder add(Holder<Attribute> var0) {
            this.create(var0);
            return this;
        }

        public Builder add(Holder<Attribute> var0, double var1) {
            AttributeInstance var3 = this.create(var0);
            var3.setBaseValue(var1);
            return this;
        }

        public AttributeSupplier build() {
            this.instanceFrozen = true;
            return new AttributeSupplier((Map<Holder<Attribute>, AttributeInstance>)this.builder.buildKeepingLast());
        }
    }
}

