/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;

public class AnimalMakeLove
extends Behavior<Animal> {
    private static final int BREED_RANGE = 3;
    private static final int MIN_DURATION = 60;
    private static final int MAX_DURATION = 110;
    private final EntityType<? extends Animal> partnerType;
    private final float speedModifier;
    private final int closeEnoughDistance;
    private static final int DEFAULT_CLOSE_ENOUGH_DISTANCE = 2;
    private long spawnChildAtTime;

    public AnimalMakeLove(EntityType<? extends Animal> var0) {
        this(var0, 1.0f, 2);
    }

    public AnimalMakeLove(EntityType<? extends Animal> var0, float var1, int var2) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.BREED_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 110);
        this.partnerType = var0;
        this.speedModifier = var1;
        this.closeEnoughDistance = var2;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Animal var1) {
        return var1.isInLove() && this.findValidBreedPartner(var1).isPresent();
    }

    @Override
    protected void start(ServerLevel var0, Animal var1, long var2) {
        Animal var4 = this.findValidBreedPartner(var1).get();
        var1.getBrain().setMemory(MemoryModuleType.BREED_TARGET, var4);
        var4.getBrain().setMemory(MemoryModuleType.BREED_TARGET, var1);
        BehaviorUtils.lockGazeAndWalkToEachOther(var1, var4, this.speedModifier, this.closeEnoughDistance);
        int var5 = 60 + var1.getRandom().nextInt(50);
        this.spawnChildAtTime = var2 + (long)var5;
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Animal var1, long var2) {
        if (!this.hasBreedTargetOfRightType(var1)) {
            return false;
        }
        Animal var4 = this.getBreedTarget(var1);
        return var4.isAlive() && var1.canMate(var4) && BehaviorUtils.entityIsVisible(var1.getBrain(), var4) && var2 <= this.spawnChildAtTime && !var1.isPanicking() && !var4.isPanicking();
    }

    @Override
    protected void tick(ServerLevel var0, Animal var1, long var2) {
        Animal var4 = this.getBreedTarget(var1);
        BehaviorUtils.lockGazeAndWalkToEachOther(var1, var4, this.speedModifier, this.closeEnoughDistance);
        if (!var1.closerThan(var4, 3.0)) {
            return;
        }
        if (var2 >= this.spawnChildAtTime) {
            var1.spawnChildFromBreeding(var0, var4);
            var1.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
            var4.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
        }
    }

    @Override
    protected void stop(ServerLevel var0, Animal var1, long var2) {
        var1.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.spawnChildAtTime = 0L;
    }

    private Animal getBreedTarget(Animal var0) {
        return (Animal)var0.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
    }

    private boolean hasBreedTargetOfRightType(Animal var0) {
        Brain<AgeableMob> var1 = var0.getBrain();
        return var1.hasMemoryValue(MemoryModuleType.BREED_TARGET) && var1.getMemory(MemoryModuleType.BREED_TARGET).get().getType() == this.partnerType;
    }

    private Optional<? extends Animal> findValidBreedPartner(Animal var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get().findClosest(var1 -> {
            Animal var2;
            return var1.getType() == this.partnerType && var1 instanceof Animal && var0.canMate(var2 = (Animal)var1) && !var2.isPanicking();
        }).map(Animal.class::cast);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        return this.canStillUse(serverLevel, (Animal)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Animal)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Animal)livingEntity, l);
    }
}

