/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;

public class GoToPotentialJobSite
extends Behavior<Villager> {
    private static final int TICKS_UNTIL_TIMEOUT = 1200;
    final float speedModifier;

    public GoToPotentialJobSite(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.POTENTIAL_JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 1200);
        this.speedModifier = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var02, Villager var1) {
        return var1.getBrain().getActiveNonCoreActivity().map(var0 -> var0 == Activity.IDLE || var0 == Activity.WORK || var0 == Activity.PLAY).orElse(true);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Villager var1, long var2) {
        return var1.getBrain().hasMemoryValue(MemoryModuleType.POTENTIAL_JOB_SITE);
    }

    @Override
    protected void tick(ServerLevel var0, Villager var1, long var2) {
        BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)var1, var1.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE).get().pos(), this.speedModifier, 1);
    }

    @Override
    protected void stop(ServerLevel var0, Villager var12, long var2) {
        Optional<GlobalPos> var4 = var12.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE);
        var4.ifPresent(var1 -> {
            BlockPos var2 = var1.pos();
            ServerLevel var3 = var0.getServer().getLevel(var1.dimension());
            if (var3 == null) {
                return;
            }
            PoiManager var4 = var3.getPoiManager();
            if (var4.exists(var2, var0 -> true)) {
                var4.release(var2);
            }
            var0.debugSynchronizers().updatePoi(var2);
        });
        var12.getBrain().eraseMemory(MemoryModuleType.POTENTIAL_JOB_SITE);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.tick(serverLevel, (Villager)livingEntity, l);
    }
}

