/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;

public class LookAndFollowTradingPlayerSink
extends Behavior<Villager> {
    private final float speedModifier;

    public LookAndFollowTradingPlayerSink(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)), Integer.MAX_VALUE);
        this.speedModifier = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Villager var1) {
        Player var2 = var1.getTradingPlayer();
        return var1.isAlive() && var2 != null && !var1.isInWater() && !var1.hurtMarked && var1.distanceToSqr(var2) <= 16.0;
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Villager var1, long var2) {
        return this.checkExtraStartConditions(var0, var1);
    }

    @Override
    protected void start(ServerLevel var0, Villager var1, long var2) {
        this.followPlayer(var1);
    }

    @Override
    protected void stop(ServerLevel var0, Villager var1, long var2) {
        Brain<Villager> var4 = var1.getBrain();
        var4.eraseMemory(MemoryModuleType.WALK_TARGET);
        var4.eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    @Override
    protected void tick(ServerLevel var0, Villager var1, long var2) {
        this.followPlayer(var1);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    private void followPlayer(Villager var0) {
        Brain<Villager> var1 = var0.getBrain();
        var1.setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new EntityTracker(var0.getTradingPlayer(), false), this.speedModifier, 2));
        var1.setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(var0.getTradingPlayer(), true));
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.tick(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Villager)livingEntity, l);
    }
}

