/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;

public class SecondaryPoiSensor
extends Sensor<Villager> {
    private static final int SCAN_RATE = 40;

    public SecondaryPoiSensor() {
        super(40);
    }

    @Override
    protected void doTick(ServerLevel var0, Villager var1) {
        ResourceKey<Level> var2 = var0.dimension();
        BlockPos var3 = var1.blockPosition();
        ArrayList var4 = Lists.newArrayList();
        int var5 = 4;
        for (int var6 = -4; var6 <= 4; ++var6) {
            for (int var7 = -2; var7 <= 2; ++var7) {
                for (int var8 = -4; var8 <= 4; ++var8) {
                    BlockPos var9 = var3.offset(var6, var7, var8);
                    if (!var1.getVillagerData().profession().value().secondaryPoi().contains((Object)var0.getBlockState(var9).getBlock())) continue;
                    var4.add(GlobalPos.of(var2, var9));
                }
            }
        }
        Brain<Villager> var6 = var1.getBrain();
        if (!var4.isEmpty()) {
            var6.setMemory(MemoryModuleType.SECONDARY_JOB_SITE, var4);
        } else {
            var6.eraseMemory(MemoryModuleType.SECONDARY_JOB_SITE);
        }
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.SECONDARY_JOB_SITE);
    }
}

