/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class FallingBlockEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BlockState DEFAULT_BLOCK_STATE = Blocks.SAND.defaultBlockState();
    private static final int DEFAULT_TIME = 0;
    private static final float DEFAULT_FALL_DAMAGE_PER_DISTANCE = 0.0f;
    private static final int DEFAULT_MAX_FALL_DAMAGE = 40;
    private static final boolean DEFAULT_DROP_ITEM = true;
    private static final boolean DEFAULT_CANCEL_DROP = false;
    private BlockState blockState = DEFAULT_BLOCK_STATE;
    public int time = 0;
    public boolean dropItem = true;
    public boolean cancelDrop = false;
    public boolean hurtEntities;
    public int fallDamageMax = 40;
    public float fallDamagePerDistance = 0.0f;
    @Nullable
    public CompoundTag blockData;
    public boolean forceTickAfterTeleportToDuplicate;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.defineId(FallingBlockEntity.class, EntityDataSerializers.BLOCK_POS);

    public FallingBlockEntity(EntityType<? extends FallingBlockEntity> entitytypes, Level world) {
        super(entitytypes, world);
    }

    private FallingBlockEntity(Level world, double d0, double d1, double d2, BlockState iblockdata) {
        this((EntityType<? extends FallingBlockEntity>)EntityType.FALLING_BLOCK, world);
        this.blockState = iblockdata;
        this.blocksBuilding = true;
        this.setPos(d0, d1, d2);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = d0;
        this.yo = d1;
        this.zo = d2;
        this.setStartPos(this.blockPosition());
    }

    public static FallingBlockEntity fall(Level world, BlockPos blockposition, BlockState iblockdata) {
        return FallingBlockEntity.fall(world, blockposition, iblockdata, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public static FallingBlockEntity fall(Level world, BlockPos blockposition, BlockState iblockdata, CreatureSpawnEvent.SpawnReason spawnReason) {
        FallingBlockEntity entityfallingblock = new FallingBlockEntity(world, (double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5, iblockdata.hasProperty(BlockStateProperties.WATERLOGGED) ? (BlockState)iblockdata.setValue(BlockStateProperties.WATERLOGGED, false) : iblockdata);
        if (!CraftEventFactory.callEntityChangeBlockEvent(entityfallingblock, blockposition, iblockdata.getFluidState().createLegacyBlock())) {
            return entityfallingblock;
        }
        world.setBlock(blockposition, iblockdata.getFluidState().createLegacyBlock(), 3);
        world.addFreshEntity(entityfallingblock, spawnReason);
        return entityfallingblock;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public final boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (!this.isInvulnerableToBase(damagesource)) {
            this.markHurt();
        }
        return false;
    }

    public void setStartPos(BlockPos blockposition) {
        this.entityData.set(DATA_START_POS, blockposition);
    }

    public BlockPos getStartPos() {
        return this.entityData.get(DATA_START_POS);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(DATA_START_POS, BlockPos.ZERO);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        if (this.blockState.isAir()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.blockState.getBlock();
            ++this.time;
            this.applyGravity();
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.applyEffectsFromBlocks();
            this.handlePortal();
            Level world = this.level();
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (this.isAlive() || this.forceTickAfterTeleportToDuplicate) {
                    BlockHitResult movingobjectpositionblock;
                    BlockPos blockposition = this.blockPosition();
                    boolean flag = this.blockState.getBlock() instanceof ConcretePowderBlock;
                    boolean flag1 = flag && this.level().getFluidState(blockposition).is(FluidTags.WATER);
                    double d0 = this.getDeltaMovement().lengthSqr();
                    if (flag && d0 > 1.0 && (movingobjectpositionblock = this.level().clip(new ClipContext(new Vec3(this.xo, this.yo, this.zo), this.position(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, this))).getType() != HitResult.Type.MISS && this.level().getFluidState(movingobjectpositionblock.getBlockPos()).is(FluidTags.WATER)) {
                        blockposition = movingobjectpositionblock.getBlockPos();
                        flag1 = true;
                    }
                    if (!this.onGround() && !flag1) {
                        if (this.time > 100 && (blockposition.getY() <= this.level().getMinY() || blockposition.getY() > this.level().getMaxY()) || this.time > 600) {
                            if (this.dropItem && worldserver.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                this.spawnAtLocation(worldserver, block);
                            }
                            this.discard(EntityRemoveEvent.Cause.DROP);
                        }
                    } else {
                        BlockState iblockdata = this.level().getBlockState(blockposition);
                        this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                        if (!iblockdata.is(Blocks.MOVING_PISTON)) {
                            if (!this.cancelDrop) {
                                boolean flag4;
                                boolean flag2 = iblockdata.canBeReplaced(new DirectionalPlaceContext(this.level(), blockposition, Direction.DOWN, ItemStack.EMPTY, Direction.UP));
                                boolean flag3 = FallingBlock.isFree(this.level().getBlockState(blockposition.below())) && (!flag || !flag1);
                                boolean bl = flag4 = this.blockState.canSurvive(this.level(), blockposition) && !flag3;
                                if (flag2 && flag4) {
                                    if (this.blockState.hasProperty(BlockStateProperties.WATERLOGGED) && this.level().getFluidState(blockposition).getType() == Fluids.WATER) {
                                        this.blockState = (BlockState)this.blockState.setValue(BlockStateProperties.WATERLOGGED, true);
                                    }
                                    if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, this.blockState)) {
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        return;
                                    }
                                    if (this.level().setBlock(blockposition, this.blockState, 3)) {
                                        BlockEntity tileentity;
                                        worldserver.getChunkSource().chunkMap.sendToTrackingPlayers(this, new ClientboundBlockUpdatePacket(blockposition, this.level().getBlockState(blockposition)));
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        if (block instanceof Fallable) {
                                            Fallable fallable = (Fallable)((Object)block);
                                            fallable.onLand(this.level(), blockposition, this.blockState, iblockdata, this);
                                        }
                                        if (this.blockData != null && this.blockState.hasBlockEntity() && (tileentity = this.level().getBlockEntity(blockposition)) != null) {
                                            try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(tileentity.problemPath(), LOGGER);){
                                                RegistryAccess iregistrycustom = this.level().registryAccess();
                                                TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter_j, iregistrycustom);
                                                tileentity.saveWithoutMetadata(tagvalueoutput);
                                                CompoundTag nbttagcompound = tagvalueoutput.buildResult();
                                                this.blockData.forEach((s, nbtbase) -> nbttagcompound.put((String)s, nbtbase.copy()));
                                                tileentity.loadWithComponents(TagValueInput.create((ProblemReporter)problemreporter_j, (HolderLookup.Provider)iregistrycustom, nbttagcompound));
                                            }
                                            catch (Exception exception) {
                                                LOGGER.error("Failed to load block entity from falling block", (Throwable)exception);
                                            }
                                            tileentity.setChanged();
                                        }
                                    } else if (this.dropItem && worldserver.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                        this.discard(EntityRemoveEvent.Cause.DROP);
                                        this.callOnBrokenAfterFall(block, blockposition);
                                        this.spawnAtLocation(worldserver, block);
                                    }
                                } else {
                                    this.discard(EntityRemoveEvent.Cause.DROP);
                                    if (this.dropItem && worldserver.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                        this.callOnBrokenAfterFall(block, blockposition);
                                        this.spawnAtLocation(worldserver, block);
                                    }
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                this.callOnBrokenAfterFall(block, blockposition);
                            }
                        }
                    }
                }
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
    }

    public void callOnBrokenAfterFall(Block block, BlockPos blockposition) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).onBrokenAfterFall(this.level(), blockposition, this);
        }
    }

    @Override
    public boolean causeFallDamage(double d0, float f, DamageSource damagesource) {
        DamageSource damagesource1;
        if (!this.hurtEntities) {
            return false;
        }
        int i = Mth.ceil(d0 - 1.0);
        if (i < 0) {
            return false;
        }
        Predicate<Entity> predicate = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        Block block = this.blockState.getBlock();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)block);
            damagesource1 = fallable.getFallDamageSource(this);
        } else {
            damagesource1 = this.damageSources().fallingBlock(this);
        }
        DamageSource damagesource2 = damagesource1;
        float f1 = Math.min(Mth.floor((float)i * this.fallDamagePerDistance), this.fallDamageMax);
        this.level().getEntities(this, this.getBoundingBox(), predicate).forEach(entity -> entity.hurt(damagesource2, f1));
        boolean flag = this.blockState.is(BlockTags.ANVIL);
        if (flag && f1 > 0.0f && this.random.nextFloat() < 0.05f + (float)i * 0.05f) {
            BlockState iblockdata = AnvilBlock.damage(this.blockState);
            if (iblockdata == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = iblockdata;
            }
        }
        return false;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        valueoutput.store("BlockState", BlockState.CODEC, this.blockState);
        valueoutput.putInt("Time", this.time);
        valueoutput.putBoolean("DropItem", this.dropItem);
        valueoutput.putBoolean("HurtEntities", this.hurtEntities);
        valueoutput.putFloat("FallHurtAmount", this.fallDamagePerDistance);
        valueoutput.putInt("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            valueoutput.store("TileEntityData", CompoundTag.CODEC, this.blockData);
        }
        valueoutput.putBoolean("CancelDrop", this.cancelDrop);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        this.blockState = valueinput.read("BlockState", BlockState.CODEC).orElse(DEFAULT_BLOCK_STATE);
        this.time = valueinput.getIntOr("Time", 0);
        boolean flag = this.blockState.is(BlockTags.ANVIL);
        this.hurtEntities = valueinput.getBooleanOr("HurtEntities", flag);
        this.fallDamagePerDistance = valueinput.getFloatOr("FallHurtAmount", 0.0f);
        this.fallDamageMax = valueinput.getIntOr("FallHurtMax", 40);
        this.dropItem = valueinput.getBooleanOr("DropItem", true);
        this.blockData = valueinput.read("TileEntityData", CompoundTag.CODEC).orElse(null);
        this.cancelDrop = valueinput.getBooleanOr("CancelDrop", false);
    }

    public void setHurtsEntities(float f, int i) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = f;
        this.fallDamageMax = i;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    @Override
    public boolean displayFireAnimation() {
        return false;
    }

    @Override
    public void fillCrashReportCategory(CrashReportCategory crashreportsystemdetails) {
        super.fillCrashReportCategory(crashreportsystemdetails);
        crashreportsystemdetails.setDetail("Immitating BlockState", this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    protected Component getTypeName() {
        return Component.translatable("entity.minecraft.falling_block_type", this.blockState.getBlock().getName());
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entitytrackerentry) {
        return new ClientboundAddEntityPacket((Entity)this, entitytrackerentry, Block.getId(this.getBlockState()));
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        this.blockState = Block.stateById(packetplayoutspawnentity.getData());
        this.blocksBuilding = true;
        double d0 = packetplayoutspawnentity.getX();
        double d1 = packetplayoutspawnentity.getY();
        double d2 = packetplayoutspawnentity.getZ();
        this.setPos(d0, d1, d2);
        this.setStartPos(this.blockPosition());
    }

    @Override
    @Nullable
    public Entity teleport(TeleportTransition teleporttransition) {
        ResourceKey<Level> resourcekey = teleporttransition.newLevel().dimension();
        ResourceKey<Level> resourcekey1 = this.level().dimension();
        boolean flag = (resourcekey1 == Level.END || resourcekey == Level.END) && resourcekey1 != resourcekey;
        Entity entity = super.teleport(teleporttransition);
        this.forceTickAfterTeleportToDuplicate = entity != null && flag;
        return entity;
    }
}

