/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.breeze.BreezeUtil;
import net.minecraft.world.phys.Vec3;

public class Slide
extends Behavior<Breeze> {
    public Slide() {
        super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_PRESENT, MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREEZE_JUMP_COOLDOWN, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREEZE_SHOOT, MemoryStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Breeze var1) {
        return var1.onGround() && !var1.isInWater() && var1.getPose() == Pose.STANDING;
    }

    @Override
    protected void start(ServerLevel var0, Breeze var1, long var2) {
        Vec3 var7;
        LivingEntity var4 = var1.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (var4 == null) {
            return;
        }
        boolean var5 = var1.withinInnerCircleRange(var4.position());
        Vec3 var6 = null;
        if (var5 && (var7 = DefaultRandomPos.getPosAway(var1, 5, 5, var4.position())) != null && BreezeUtil.hasLineOfSight(var1, var7) && var4.distanceToSqr(var7.x, var7.y, var7.z) > var4.distanceToSqr(var1)) {
            var6 = var7;
        }
        if (var6 == null) {
            var6 = var1.getRandom().nextBoolean() ? BreezeUtil.randomPointBehindTarget(var4, var1.getRandom()) : Slide.randomPointInMiddleCircle(var1, var4);
        }
        var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(BlockPos.containing(var6), 0.6f, 1));
    }

    private static Vec3 randomPointInMiddleCircle(Breeze var0, LivingEntity var1) {
        Vec3 var2 = var1.position().subtract(var0.position());
        double var3 = var2.length() - Mth.lerp(var0.getRandom().nextDouble(), 8.0, 4.0);
        Vec3 var5 = var2.normalize().multiply(var3, var3, var3);
        return var0.position().add(var5);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Breeze)livingEntity, l);
    }
}

