/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.schedule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.entity.schedule.Keyframe;

public class Timeline {
    private final List<Keyframe> keyframes = Lists.newArrayList();
    private int previousIndex;

    public ImmutableList<Keyframe> getKeyframes() {
        return ImmutableList.copyOf(this.keyframes);
    }

    public Timeline addKeyframe(int var0, float var1) {
        this.keyframes.add(new Keyframe(var0, var1));
        this.sortAndDeduplicateKeyframes();
        return this;
    }

    public Timeline addKeyframes(Collection<Keyframe> var0) {
        this.keyframes.addAll(var0);
        this.sortAndDeduplicateKeyframes();
        return this;
    }

    private void sortAndDeduplicateKeyframes() {
        Int2ObjectAVLTreeMap var0 = new Int2ObjectAVLTreeMap();
        this.keyframes.forEach(arg_0 -> Timeline.lambda$sortAndDeduplicateKeyframes$0((Int2ObjectSortedMap)var0, arg_0));
        this.keyframes.clear();
        this.keyframes.addAll((Collection<Keyframe>)var0.values());
        this.previousIndex = 0;
    }

    public float getValueAt(int var0) {
        Keyframe var7;
        if (this.keyframes.size() <= 0) {
            return 0.0f;
        }
        Keyframe var1 = this.keyframes.get(this.previousIndex);
        Keyframe var2 = this.keyframes.get(this.keyframes.size() - 1);
        boolean var3 = var0 < var1.getTimeStamp();
        int var4 = var3 ? 0 : this.previousIndex;
        float var5 = var3 ? var2.getValue() : var1.getValue();
        int var6 = var4;
        while (var6 < this.keyframes.size() && (var7 = this.keyframes.get(var6)).getTimeStamp() <= var0) {
            this.previousIndex = var6++;
            var5 = var7.getValue();
        }
        return var5;
    }

    private static /* synthetic */ void lambda$sortAndDeduplicateKeyframes$0(Int2ObjectSortedMap var0, Keyframe var1) {
        var0.put(var1.getTimeStamp(), (Object)var1);
    }
}

