/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class MinecartFurnace
extends AbstractMinecart {
    private static final EntityDataAccessor<Boolean> DATA_ID_FUEL = SynchedEntityData.defineId(MinecartFurnace.class, EntityDataSerializers.BOOLEAN);
    private static final int FUEL_TICKS_PER_ITEM = 3600;
    private static final int MAX_FUEL_TICKS = 32000;
    private static final short DEFAULT_FUEL = 0;
    private static final Vec3 DEFAULT_PUSH = Vec3.ZERO;
    public int fuel = 0;
    public Vec3 push = DEFAULT_PUSH;

    public MinecartFurnace(EntityType<? extends MinecartFurnace> var0, Level var1) {
        super(var0, var1);
    }

    @Override
    public boolean isFurnace() {
        return true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ID_FUEL, false);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.fuel > 0) {
                --this.fuel;
            }
            if (this.fuel <= 0) {
                this.push = Vec3.ZERO;
            }
            this.setHasFuel(this.fuel > 0);
        }
        if (this.hasFuel() && this.random.nextInt(4) == 0) {
            this.level().addParticle(ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + 0.8, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected double getMaxSpeed(ServerLevel var0) {
        return this.isInWater() ? super.getMaxSpeed(var0) * 0.75 : super.getMaxSpeed(var0) * 0.5;
    }

    @Override
    protected Item getDropItem() {
        return Items.FURNACE_MINECART;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.FURNACE_MINECART);
    }

    @Override
    protected Vec3 applyNaturalSlowdown(Vec3 var0) {
        Vec3 var1;
        if (this.push.lengthSqr() > 1.0E-7) {
            this.push = this.calculateNewPushAlong(var0);
            var1 = var0.multiply(0.8, 0.0, 0.8).add(this.push);
            if (this.isInWater()) {
                var1 = var1.scale(0.1);
            }
        } else {
            var1 = var0.multiply(0.98, 0.0, 0.98);
        }
        return super.applyNaturalSlowdown(var1);
    }

    private Vec3 calculateNewPushAlong(Vec3 var0) {
        double var1 = 1.0E-4;
        double var3 = 0.001;
        if (this.push.horizontalDistanceSqr() > 1.0E-4 && var0.horizontalDistanceSqr() > 0.001) {
            return this.push.projectedOn(var0).normalize().scale(this.push.length());
        }
        return this.push;
    }

    @Override
    public InteractionResult interact(Player var0, InteractionHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (this.addFuel(var0.position(), var2)) {
            var2.consume(1, var0);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean addFuel(Vec3 var0, ItemStack var1) {
        if (var1.is(ItemTags.FURNACE_MINECART_FUEL) && this.fuel + 3600 <= 32000) {
            this.fuel += 3600;
        } else {
            return false;
        }
        if (this.fuel > 0) {
            this.push = this.position().subtract(var0).horizontal();
        }
        return true;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putDouble("PushX", this.push.x);
        var0.putDouble("PushZ", this.push.z);
        var0.putShort("Fuel", (short)this.fuel);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        double var1 = var0.getDoubleOr("PushX", MinecartFurnace.DEFAULT_PUSH.x);
        double var3 = var0.getDoubleOr("PushZ", MinecartFurnace.DEFAULT_PUSH.z);
        this.push = new Vec3(var1, 0.0, var3);
        this.fuel = var0.getShortOr("Fuel", (short)0);
    }

    protected boolean hasFuel() {
        return this.entityData.get(DATA_ID_FUEL);
    }

    protected void setHasFuel(boolean var0) {
        this.entityData.set(DATA_ID_FUEL, var0);
    }

    @Override
    public BlockState getDefaultDisplayBlockState() {
        return (BlockState)((BlockState)Blocks.FURNACE.defaultBlockState().setValue(FurnaceBlock.FACING, Direction.NORTH)).setValue(FurnaceBlock.LIT, this.hasFuel());
    }
}

