/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryStonecutter;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.CraftStonecutterView;
import org.bukkit.entity.HumanEntity;

public class StonecutterMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    private static final int INV_SLOT_START = 2;
    private static final int INV_SLOT_END = 29;
    private static final int USE_ROW_SLOT_START = 29;
    private static final int USE_ROW_SLOT_END = 38;
    private final ContainerLevelAccess access;
    final DataSlot selectedRecipeIndex = DataSlot.standalone();
    private final Level level;
    private SelectableRecipe.SingleInputSet<StonecutterRecipe> recipesForInput = SelectableRecipe.SingleInputSet.empty();
    private ItemStack input = ItemStack.EMPTY;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container;
    final ResultContainer resultContainer;
    private CraftStonecutterView bukkitEntity = null;
    private org.bukkit.entity.Player player;

    @Override
    public CraftStonecutterView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryStonecutter inventory = new CraftInventoryStonecutter(this.container, this.resultContainer);
        this.bukkitEntity = new CraftStonecutterView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public StonecutterMenu(int i, Inventory playerinventory) {
        this(i, playerinventory, ContainerLevelAccess.NULL);
    }

    public StonecutterMenu(int i, Inventory playerinventory, final ContainerLevelAccess containeraccess) {
        super(MenuType.STONECUTTER, i);
        this.container = new SimpleContainer(1){

            @Override
            public void setChanged() {
                super.setChanged();
                StonecutterMenu.this.slotsChanged(this);
                StonecutterMenu.this.slotUpdateListener.run();
            }

            @Override
            public Location getLocation() {
                return containeraccess.getLocation();
            }
        };
        this.resultContainer = new ResultContainer();
        this.access = containeraccess;
        this.level = playerinventory.player.level();
        this.inputSlot = this.addSlot(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.addSlot(new Slot(this.resultContainer, 1, 143, 33){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return false;
            }

            @Override
            public void onTake(Player entityhuman, ItemStack itemstack) {
                itemstack.onCraftedBy(entityhuman, itemstack.getCount());
                StonecutterMenu.this.resultContainer.awardUsedRecipes(entityhuman, this.getRelevantItems());
                ItemStack itemstack1 = StonecutterMenu.this.inputSlot.remove(1);
                if (!itemstack1.isEmpty()) {
                    StonecutterMenu.this.setupResultSlot(StonecutterMenu.this.selectedRecipeIndex.get());
                }
                containeraccess.execute((world, blockposition) -> {
                    long j = world.getGameTime();
                    if (StonecutterMenu.this.lastSoundTime != j) {
                        world.playSound((Entity)null, (BlockPos)blockposition, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        StonecutterMenu.this.lastSoundTime = j;
                    }
                });
                super.onTake(entityhuman, itemstack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(StonecutterMenu.this.inputSlot.getItem());
            }
        });
        this.addStandardInventorySlots(playerinventory, 8, 84);
        this.addDataSlot(this.selectedRecipeIndex);
        this.player = (org.bukkit.entity.Player)playerinventory.player.getBukkitEntity();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public SelectableRecipe.SingleInputSet<StonecutterRecipe> getVisibleRecipes() {
        return this.recipesForInput;
    }

    public int getNumberOfVisibleRecipes() {
        return this.recipesForInput.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipesForInput.isEmpty();
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return StonecutterMenu.stillValid(this.access, entityhuman, Blocks.STONECUTTER);
    }

    @Override
    public boolean clickMenuButton(Player entityhuman, int i) {
        if (this.selectedRecipeIndex.get() == i) {
            return false;
        }
        if (this.isValidRecipeIndex(i)) {
            this.selectedRecipeIndex.set(i);
            this.setupResultSlot(i);
        }
        return true;
    }

    private boolean isValidRecipeIndex(int i) {
        return i >= 0 && i < this.recipesForInput.size();
    }

    @Override
    public void slotsChanged(Container iinventory) {
        ItemStack itemstack = this.inputSlot.getItem();
        if (!itemstack.is(this.input.getItem())) {
            this.input = itemstack.copy();
            this.setupRecipeList(itemstack);
        }
    }

    private void setupRecipeList(ItemStack itemstack) {
        this.selectedRecipeIndex.set(-1);
        this.resultSlot.set(ItemStack.EMPTY);
        this.recipesForInput = !itemstack.isEmpty() ? this.level.recipeAccess().stonecutterRecipes().selectByInput(itemstack) : SelectableRecipe.SingleInputSet.empty();
    }

    void setupResultSlot(int i) {
        Optional<RecipeHolder<Object>> optional;
        if (!this.recipesForInput.isEmpty() && this.isValidRecipeIndex(i)) {
            SelectableRecipe.SingleInputEntry<StonecutterRecipe> selectablerecipe_a = this.recipesForInput.entries().get(i);
            optional = selectablerecipe_a.recipe().recipe();
        } else {
            optional = Optional.empty();
        }
        optional.ifPresentOrElse(recipeholder -> {
            this.resultContainer.setRecipeUsed((RecipeHolder<?>)recipeholder);
            this.resultSlot.set(((StonecutterRecipe)recipeholder.value()).assemble(new SingleRecipeInput(this.container.getItem(0)), (HolderLookup.Provider)this.level.registryAccess()));
        }, () -> {
            this.resultSlot.set(ItemStack.EMPTY);
            this.resultContainer.setRecipeUsed(null);
        });
        this.broadcastChanges();
    }

    @Override
    public MenuType<?> getType() {
        return MenuType.STONECUTTER;
    }

    public void registerUpdateListener(Runnable runnable) {
        this.slotUpdateListener = runnable;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack itemstack, Slot slot) {
        return slot.container != this.resultContainer && super.canTakeItemForPickAll(itemstack, slot);
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            Item item = itemstack1.getItem();
            itemstack = itemstack1.copy();
            if (i == 1) {
                item.onCraftedBy(itemstack1, entityhuman);
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i == 0 ? !this.moveItemStackTo(itemstack1, 2, 38, false) : (this.level.recipeAccess().stonecutterRecipes().acceptsInput(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (i >= 2 && i < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : i >= 29 && i < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
            if (i == 1) {
                entityhuman.drop(itemstack1, false);
            }
            this.broadcastChanges();
        }
        return itemstack;
    }

    @Override
    public void removed(Player entityhuman) {
        super.removed(entityhuman);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((world, blockposition) -> this.clearContainer(entityhuman, this.container));
    }
}

