/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DebugStickState;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class DebugStickItem
extends Item {
    public DebugStickItem(Item.Properties item_info) {
        super(item_info);
    }

    @Override
    public boolean canDestroyBlock(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, LivingEntity entityliving) {
        if (!world.isClientSide() && entityliving instanceof Player) {
            Player entityhuman = (Player)entityliving;
            this.handleInteraction(entityhuman, iblockdata, world, blockposition, false, itemstack);
        }
        return false;
    }

    @Override
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        BlockPos blockposition;
        Player entityhuman = itemactioncontext.getPlayer();
        Level world = itemactioncontext.getLevel();
        if (!world.isClientSide() && entityhuman != null && !this.handleInteraction(entityhuman, world.getBlockState(blockposition = itemactioncontext.getClickedPos()), world, blockposition, true, itemactioncontext.getItemInHand())) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean handleInteraction(Player entityhuman, BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition, boolean flag, ItemStack itemstack) {
        if (!(entityhuman.canUseGameMasterBlocks() || entityhuman.getAbilities().instabuild && entityhuman.getBukkitEntity().hasPermission("minecraft.debugstick") || entityhuman.getBukkitEntity().hasPermission("minecraft.debugstick.always"))) {
            return false;
        }
        Holder<Block> holder = iblockdata.getBlockHolder();
        StateDefinition<Block, BlockState> blockstatelist = holder.value().getStateDefinition();
        Collection<Property<?>> collection = blockstatelist.getProperties();
        if (collection.isEmpty()) {
            DebugStickItem.message(entityhuman, Component.translatable(this.descriptionId + ".empty", holder.getRegisteredName()));
            return false;
        }
        DebugStickState debugstickstate = itemstack.get(DataComponents.DEBUG_STICK_STATE);
        if (debugstickstate == null) {
            return false;
        }
        Property<?> iblockstate = debugstickstate.properties().get(holder);
        if (flag) {
            if (iblockstate == null) {
                iblockstate = collection.iterator().next();
            }
            BlockState iblockdata1 = DebugStickItem.cycleState(iblockdata, iblockstate, entityhuman.isSecondaryUseActive());
            generatoraccess.setBlock(blockposition, iblockdata1, 18);
            DebugStickItem.message(entityhuman, Component.translatable(this.descriptionId + ".update", iblockstate.getName(), DebugStickItem.getNameHelper(iblockdata1, iblockstate)));
        } else {
            iblockstate = DebugStickItem.getRelative(collection, iblockstate, entityhuman.isSecondaryUseActive());
            itemstack.set(DataComponents.DEBUG_STICK_STATE, debugstickstate.withProperty(holder, iblockstate));
            DebugStickItem.message(entityhuman, Component.translatable(this.descriptionId + ".select", iblockstate.getName(), DebugStickItem.getNameHelper(iblockdata, iblockstate)));
        }
        return true;
    }

    private static <T extends Comparable<T>> BlockState cycleState(BlockState iblockdata, Property<T> iblockstate, boolean flag) {
        return (BlockState)iblockdata.setValue(iblockstate, (Comparable)DebugStickItem.getRelative(iblockstate.getPossibleValues(), iblockdata.getValue(iblockstate), flag));
    }

    private static <T> T getRelative(Iterable<T> iterable, @Nullable T t0, boolean flag) {
        return flag ? Util.findPreviousInIterable(iterable, t0) : Util.findNextInIterable(iterable, t0);
    }

    private static void message(Player entityhuman, Component ichatbasecomponent) {
        ((ServerPlayer)entityhuman).sendSystemMessage(ichatbasecomponent, true);
    }

    private static <T extends Comparable<T>> String getNameHelper(BlockState iblockdata, Property<T> iblockstate) {
        return iblockstate.getName(iblockdata.getValue(iblockstate));
    }
}

