/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public record JukeboxPlayable(EitherHolder<JukeboxSong> song) implements TooltipProvider
{
    public static final Codec<JukeboxPlayable> CODEC = EitherHolder.codec(Registries.JUKEBOX_SONG, JukeboxSong.CODEC).xmap(JukeboxPlayable::new, JukeboxPlayable::song);
    public static final StreamCodec<RegistryFriendlyByteBuf, JukeboxPlayable> STREAM_CODEC = StreamCodec.composite(EitherHolder.streamCodec(Registries.JUKEBOX_SONG, JukeboxSong.STREAM_CODEC), JukeboxPlayable::song, JukeboxPlayable::new);

    @Override
    public void addToTooltip(Item.TooltipContext var0, Consumer<Component> var12, TooltipFlag var2, DataComponentGetter var3) {
        HolderLookup.Provider var4 = var0.registries();
        if (var4 != null) {
            this.song.unwrap(var4).ifPresent(var1 -> {
                MutableComponent var2 = ((JukeboxSong)var1.value()).description().copy();
                ComponentUtils.mergeStyles(var2, Style.EMPTY.withColor(ChatFormatting.GRAY));
                var12.accept(var2);
            });
        }
    }

    public static InteractionResult tryInsertIntoJukebox(Level var0, BlockPos var1, ItemStack var2, Player var3) {
        JukeboxPlayable var4 = var2.get(DataComponents.JUKEBOX_PLAYABLE);
        if (var4 == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockState var5 = var0.getBlockState(var1);
        if (!var5.is(Blocks.JUKEBOX) || var5.getValue(JukeboxBlock.HAS_RECORD).booleanValue()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!var0.isClientSide()) {
            ItemStack var6 = var2.consumeAndReturn(1, var3);
            BlockEntity blockEntity = var0.getBlockEntity(var1);
            if (blockEntity instanceof JukeboxBlockEntity) {
                JukeboxBlockEntity var7 = (JukeboxBlockEntity)blockEntity;
                var7.setTheItem(var6);
                var0.gameEvent(GameEvent.BLOCK_CHANGE, var1, GameEvent.Context.of(var3, var5));
            }
            var3.awardStat(Stats.PLAY_RECORD);
        }
        return InteractionResult.SUCCESS;
    }
}

