/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class KnowledgeBookItem
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();

    public KnowledgeBookItem(Item.Properties var0) {
        super(var0);
    }

    @Override
    public InteractionResult use(Level var0, Player var1, InteractionHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        List var4 = var3.getOrDefault(DataComponents.RECIPES, List.of());
        var3.consume(1, var1);
        if (var4.isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (!var0.isClientSide()) {
            RecipeManager var5 = var0.getServer().getRecipeManager();
            ArrayList var6 = new ArrayList(var4.size());
            for (ResourceKey var8 : var4) {
                Optional<RecipeHolder<?>> var9 = var5.byKey(var8);
                if (var9.isPresent()) {
                    var6.add(var9.get());
                    continue;
                }
                LOGGER.error("Invalid recipe: {}", (Object)var8);
                return InteractionResult.FAIL;
            }
            var1.awardRecipes(var6);
            var1.awardStat(Stats.ITEM_USED.get(this));
        }
        return InteractionResult.SUCCESS;
    }
}

