/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class MobBucketItem
extends BucketItem {
    private final EntityType<? extends Mob> type;
    private final SoundEvent emptySound;

    public MobBucketItem(EntityType<? extends Mob> entitytypes, Fluid fluidtype, SoundEvent soundeffect, Item.Properties item_info) {
        super(fluidtype, item_info);
        this.type = entitytypes;
        this.emptySound = soundeffect;
    }

    @Override
    public void checkExtraContent(@Nullable LivingEntity entityliving, Level world, ItemStack itemstack, BlockPos blockposition) {
        if (world instanceof ServerLevel) {
            this.spawn((ServerLevel)world, itemstack, blockposition);
            world.gameEvent((Entity)entityliving, GameEvent.ENTITY_PLACE, blockposition);
        }
    }

    @Override
    protected void playEmptySound(@Nullable LivingEntity entityliving, LevelAccessor generatoraccess, BlockPos blockposition) {
        generatoraccess.playSound(entityliving, blockposition, this.emptySound, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(ServerLevel worldserver, ItemStack itemstack, BlockPos blockposition) {
        Mob entityinsentient = this.type.create(worldserver, EntityType.createDefaultStackConfig(worldserver, itemstack, null), blockposition, EntitySpawnReason.BUCKET, true, false);
        if (entityinsentient instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)((Object)entityinsentient);
            CustomData customdata = itemstack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, CustomData.EMPTY);
            bucketable.loadFromBucketTag(customdata.copyTag());
            bucketable.setFromBucket(true);
        }
        if (entityinsentient != null) {
            worldserver.addFreshEntityWithPassengers(entityinsentient, CreatureSpawnEvent.SpawnReason.BUCKET);
            entityinsentient.playAmbientSound();
        }
    }
}

