/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;

public abstract class ProjectileWeaponItem
extends Item {
    public static final Predicate<ItemStack> ARROW_ONLY = itemstack -> itemstack.is(ItemTags.ARROWS);
    public static final Predicate<ItemStack> ARROW_OR_FIREWORK = ARROW_ONLY.or(itemstack -> itemstack.is(Items.FIREWORK_ROCKET));

    public ProjectileWeaponItem(Item.Properties item_info) {
        super(item_info);
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return this.getAllSupportedProjectiles();
    }

    public abstract Predicate<ItemStack> getAllSupportedProjectiles();

    public static ItemStack getHeldProjectile(LivingEntity entityliving, Predicate<ItemStack> predicate) {
        return predicate.test(entityliving.getItemInHand(InteractionHand.OFF_HAND)) ? entityliving.getItemInHand(InteractionHand.OFF_HAND) : (predicate.test(entityliving.getItemInHand(InteractionHand.MAIN_HAND)) ? entityliving.getItemInHand(InteractionHand.MAIN_HAND) : ItemStack.EMPTY);
    }

    public abstract int getDefaultProjectileRange();

    protected void shoot(ServerLevel worldserver, LivingEntity entityliving, InteractionHand enumhand, ItemStack itemstack, List<ItemStack> list, float f, float f1, boolean flag, @Nullable LivingEntity entityliving1) {
        float f2 = EnchantmentHelper.processProjectileSpread(worldserver, itemstack, entityliving, 0.0f);
        float f3 = list.size() == 1 ? 0.0f : 2.0f * f2 / (float)(list.size() - 1);
        float f4 = (float)((list.size() - 1) % 2) * f3 / 2.0f;
        float f5 = 1.0f;
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack1 = list.get(i);
            if (itemstack1.isEmpty()) continue;
            float f6 = f4 + f5 * (float)((i + 1) / 2) * f3;
            f5 = -f5;
            Projectile iprojectile = this.createProjectile(worldserver, entityliving, itemstack, itemstack1, flag);
            this.shootProjectile(entityliving, iprojectile, i, f, f1, f6, entityliving1);
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(entityliving, itemstack, itemstack1, iprojectile, enumhand, f, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == iprojectile.getBukkitEntity() && Projectile.spawnProjectile(iprojectile, worldserver, itemstack1).isRemoved()) {
                if (entityliving instanceof ServerPlayer) {
                    ((ServerPlayer)entityliving).getBukkitEntity().updateInventory();
                }
                return;
            }
            itemstack.hurtAndBreak(this.getDurabilityUse(itemstack1), entityliving, enumhand.asEquipmentSlot());
            if (itemstack.isEmpty()) break;
        }
    }

    protected int getDurabilityUse(ItemStack itemstack) {
        return 1;
    }

    protected abstract void shootProjectile(LivingEntity var1, Projectile var2, int var3, float var4, float var5, float var6, @Nullable LivingEntity var7);

    protected Projectile createProjectile(Level world, LivingEntity entityliving, ItemStack itemstack, ItemStack itemstack1, boolean flag) {
        ArrowItem itemarrow1;
        Item item = itemstack1.getItem();
        ArrowItem itemarrow = item instanceof ArrowItem ? (itemarrow1 = (ArrowItem)item) : (ArrowItem)Items.ARROW;
        ArrowItem itemarrow2 = itemarrow;
        AbstractArrow entityarrow = itemarrow2.createArrow(world, itemstack1, entityliving, itemstack);
        if (flag) {
            entityarrow.setCritArrow(true);
        }
        return entityarrow;
    }

    protected static List<ItemStack> draw(ItemStack itemstack, ItemStack itemstack1, LivingEntity entityliving) {
        int i;
        if (itemstack1.isEmpty()) {
            return List.of();
        }
        Level world = entityliving.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            i = EnchantmentHelper.processProjectileCount(worldserver, itemstack, entityliving, 1);
        } else {
            i = 1;
        }
        int j = i;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(j);
        ItemStack itemstack2 = itemstack1.copy();
        for (int k = 0; k < j; ++k) {
            ItemStack itemstack3 = ProjectileWeaponItem.useAmmo(itemstack, k == 0 ? itemstack1 : itemstack2, entityliving, k > 0);
            if (itemstack3.isEmpty()) continue;
            list.add(itemstack3);
        }
        return list;
    }

    protected static ItemStack useAmmo(ItemStack itemstack, ItemStack itemstack1, LivingEntity entityliving, boolean flag) {
        int i;
        Level world;
        if (!flag && !entityliving.hasInfiniteMaterials() && (world = entityliving.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            i = EnchantmentHelper.processAmmoUse(worldserver, itemstack, itemstack1, 1);
        } else {
            i = 0;
        }
        int j = i;
        if (j > itemstack1.getCount()) {
            return ItemStack.EMPTY;
        }
        if (j == 0) {
            ItemStack itemstack2 = itemstack1.copyWithCount(1);
            itemstack2.set(DataComponents.INTANGIBLE_PROJECTILE, Unit.INSTANCE);
            return itemstack2;
        }
        ItemStack itemstack3 = itemstack1.split(j);
        if (itemstack1.isEmpty() && entityliving instanceof Player) {
            Player entityhuman = (Player)entityliving;
            entityhuman.getInventory().removeItem(itemstack1);
        }
        return itemstack3;
    }
}

