/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractThrownPotion;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;

public abstract class ThrowablePotionItem
extends PotionItem
implements ProjectileItem {
    public static float PROJECTILE_SHOOT_POWER = 0.5f;

    public ThrowablePotionItem(Item.Properties var0) {
        super(var0);
    }

    @Override
    public InteractionResult use(Level var0, Player var1, InteractionHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (var0 instanceof ServerLevel) {
            ServerLevel var4 = (ServerLevel)var0;
            Projectile.spawnProjectileFromRotation(this::createPotion, var4, var3, var1, -20.0f, PROJECTILE_SHOOT_POWER, 1.0f);
        }
        var1.awardStat(Stats.ITEM_USED.get(this));
        var3.consume(1, var1);
        return InteractionResult.SUCCESS;
    }

    protected abstract AbstractThrownPotion createPotion(ServerLevel var1, LivingEntity var2, ItemStack var3);

    protected abstract AbstractThrownPotion createPotion(Level var1, Position var2, ItemStack var3);

    @Override
    public Projectile asProjectile(Level var0, Position var1, ItemStack var2, Direction var3) {
        return this.createPotion(var0, var1, var2);
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().uncertainty(ProjectileItem.DispenseConfig.DEFAULT.uncertainty() * 0.5f).power(ProjectileItem.DispenseConfig.DEFAULT.power() * 1.25f).build();
    }
}

