/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.chunk.status.ChunkPyramid;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class ChunkPos {
    public static final Codec<ChunkPos> CODEC = Codec.INT_STREAM.comapFlatMap(var02 -> Util.fixedSize(var02, 2).map(var0 -> new ChunkPos(var0[0], var0[1])), var0 -> IntStream.of(var0.x, var0.z)).stable();
    public static final StreamCodec<ByteBuf, ChunkPos> STREAM_CODEC = new StreamCodec<ByteBuf, ChunkPos>(){

        @Override
        public ChunkPos decode(ByteBuf var0) {
            return FriendlyByteBuf.readChunkPos(var0);
        }

        @Override
        public void encode(ByteBuf var0, ChunkPos var1) {
            FriendlyByteBuf.writeChunkPos(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (ChunkPos)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    private static final int SAFETY_MARGIN = 1056;
    public static final long INVALID_CHUNK_POS = ChunkPos.asLong(1875066, 1875066);
    private static final int SAFETY_MARGIN_CHUNKS = (32 + ChunkPyramid.GENERATION_PYRAMID.getStepTo(ChunkStatus.FULL).accumulatedDependencies().size() + 1) * 2;
    public static final int MAX_COORDINATE_VALUE = SectionPos.blockToSectionCoord(BlockPos.MAX_HORIZONTAL_COORDINATE) - SAFETY_MARGIN_CHUNKS;
    public static final ChunkPos ZERO = new ChunkPos(0, 0);
    private static final long COORD_BITS = 32L;
    private static final long COORD_MASK = 0xFFFFFFFFL;
    private static final int REGION_BITS = 5;
    public static final int REGION_SIZE = 32;
    private static final int REGION_MASK = 31;
    public static final int REGION_MAX_INDEX = 31;
    public final int x;
    public final int z;
    private static final int HASH_A = 1664525;
    private static final int HASH_C = 1013904223;
    private static final int HASH_Z_XOR = -559038737;

    public ChunkPos(int var0, int var1) {
        this.x = var0;
        this.z = var1;
    }

    public ChunkPos(BlockPos var0) {
        this.x = SectionPos.blockToSectionCoord(var0.getX());
        this.z = SectionPos.blockToSectionCoord(var0.getZ());
    }

    public ChunkPos(long var0) {
        this.x = (int)var0;
        this.z = (int)(var0 >> 32);
    }

    public static ChunkPos minFromRegion(int var0, int var1) {
        return new ChunkPos(var0 << 5, var1 << 5);
    }

    public static ChunkPos maxFromRegion(int var0, int var1) {
        return new ChunkPos((var0 << 5) + 31, (var1 << 5) + 31);
    }

    public long toLong() {
        return ChunkPos.asLong(this.x, this.z);
    }

    public static long asLong(int var0, int var1) {
        return (long)var0 & 0xFFFFFFFFL | ((long)var1 & 0xFFFFFFFFL) << 32;
    }

    public static long asLong(BlockPos var0) {
        return ChunkPos.asLong(SectionPos.blockToSectionCoord(var0.getX()), SectionPos.blockToSectionCoord(var0.getZ()));
    }

    public static int getX(long var0) {
        return (int)(var0 & 0xFFFFFFFFL);
    }

    public static int getZ(long var0) {
        return (int)(var0 >>> 32 & 0xFFFFFFFFL);
    }

    public int hashCode() {
        return ChunkPos.hash(this.x, this.z);
    }

    public static int hash(int var0, int var1) {
        int var2 = 1664525 * var0 + 1013904223;
        int var3 = 1664525 * (var1 ^ 0xDEADBEEF) + 1013904223;
        return var2 ^ var3;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ChunkPos) {
            ChunkPos var1 = (ChunkPos)var0;
            return this.x == var1.x && this.z == var1.z;
        }
        return false;
    }

    public int getMiddleBlockX() {
        return this.getBlockX(8);
    }

    public int getMiddleBlockZ() {
        return this.getBlockZ(8);
    }

    public int getMinBlockX() {
        return SectionPos.sectionToBlockCoord(this.x);
    }

    public int getMinBlockZ() {
        return SectionPos.sectionToBlockCoord(this.z);
    }

    public int getMaxBlockX() {
        return this.getBlockX(15);
    }

    public int getMaxBlockZ() {
        return this.getBlockZ(15);
    }

    public int getRegionX() {
        return this.x >> 5;
    }

    public int getRegionZ() {
        return this.z >> 5;
    }

    public int getRegionLocalX() {
        return this.x & 0x1F;
    }

    public int getRegionLocalZ() {
        return this.z & 0x1F;
    }

    public BlockPos getBlockAt(int var0, int var1, int var2) {
        return new BlockPos(this.getBlockX(var0), var1, this.getBlockZ(var2));
    }

    public int getBlockX(int var0) {
        return SectionPos.sectionToBlockCoord(this.x, var0);
    }

    public int getBlockZ(int var0) {
        return SectionPos.sectionToBlockCoord(this.z, var0);
    }

    public BlockPos getMiddleBlockPosition(int var0) {
        return new BlockPos(this.getMiddleBlockX(), var0, this.getMiddleBlockZ());
    }

    public boolean contains(BlockPos var0) {
        return var0.getX() >= this.getMinBlockX() && var0.getZ() >= this.getMinBlockZ() && var0.getX() <= this.getMaxBlockX() && var0.getZ() <= this.getMaxBlockZ();
    }

    public String toString() {
        return "[" + this.x + ", " + this.z + "]";
    }

    public BlockPos getWorldPosition() {
        return new BlockPos(this.getMinBlockX(), 0, this.getMinBlockZ());
    }

    public int getChessboardDistance(ChunkPos var0) {
        return this.getChessboardDistance(var0.x, var0.z);
    }

    public int getChessboardDistance(int var0, int var1) {
        return Math.max(Math.abs(this.x - var0), Math.abs(this.z - var1));
    }

    public int distanceSquared(ChunkPos var0) {
        return this.distanceSquared(var0.x, var0.z);
    }

    public int distanceSquared(long var0) {
        return this.distanceSquared(ChunkPos.getX(var0), ChunkPos.getZ(var0));
    }

    private int distanceSquared(int var0, int var1) {
        int var2 = var0 - this.x;
        int var3 = var1 - this.z;
        return var2 * var2 + var3 * var3;
    }

    public static Stream<ChunkPos> rangeClosed(ChunkPos var0, int var1) {
        return ChunkPos.rangeClosed(new ChunkPos(var0.x - var1, var0.z - var1), new ChunkPos(var0.x + var1, var0.z + var1));
    }

    public static Stream<ChunkPos> rangeClosed(final ChunkPos var0, final ChunkPos var1) {
        int var2 = Math.abs(var0.x - var1.x) + 1;
        int var3 = Math.abs(var0.z - var1.z) + 1;
        final int var4 = var0.x < var1.x ? 1 : -1;
        final int var5 = var0.z < var1.z ? 1 : -1;
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<ChunkPos>((long)(var2 * var3), 64){
            @Nullable
            private ChunkPos pos;

            @Override
            public boolean tryAdvance(Consumer<? super ChunkPos> var02) {
                if (this.pos == null) {
                    this.pos = var0;
                } else {
                    int var12 = this.pos.x;
                    int var2 = this.pos.z;
                    if (var12 == var1.x) {
                        if (var2 == var1.z) {
                            return false;
                        }
                        this.pos = new ChunkPos(var0.x, var2 + var5);
                    } else {
                        this.pos = new ChunkPos(var12 + var4, var2);
                    }
                }
                var02.accept(this.pos);
                return true;
            }
        }, false);
    }
}

