/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicLike;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import org.slf4j.Logger;

public class GameRules {
    public static final int DEFAULT_RANDOM_TICK_SPEED = 3;
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Key<?>, Type<?>> GAME_RULE_TYPES = Maps.newTreeMap(Comparator.comparing(gamerules_gamerulekey -> gamerules_gamerulekey.id));
    public static final Key<BooleanValue> RULE_DOFIRETICK = GameRules.register("doFireTick", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_ALLOWFIRETICKAWAYFROMPLAYERS = GameRules.register("allowFireTicksAwayFromPlayer", Category.UPDATES, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_MOBGRIEFING = GameRules.register("mobGriefing", Category.MOBS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_KEEPINVENTORY = GameRules.register("keepInventory", Category.PLAYER, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DOMOBSPAWNING = GameRules.register("doMobSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOMOBLOOT = GameRules.register("doMobLoot", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_PROJECTILESCANBREAKBLOCKS = GameRules.register("projectilesCanBreakBlocks", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOBLOCKDROPS = GameRules.register("doTileDrops", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOENTITYDROPS = GameRules.register("doEntityDrops", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_COMMANDBLOCKOUTPUT = GameRules.register("commandBlockOutput", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_NATURAL_REGENERATION = GameRules.register("naturalRegeneration", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DAYLIGHT = GameRules.register("doDaylightCycle", Category.UPDATES, BooleanValue.create(!SharedConstants.DEBUG_WORLD_RECREATE));
    public static final Key<BooleanValue> RULE_LOGADMINCOMMANDS = GameRules.register("logAdminCommands", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_SHOWDEATHMESSAGES = GameRules.register("showDeathMessages", Category.CHAT, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_RANDOMTICKING = GameRules.register("randomTickSpeed", Category.UPDATES, IntegerValue.create(3));
    public static final Key<BooleanValue> RULE_SENDCOMMANDFEEDBACK = GameRules.register("sendCommandFeedback", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_REDUCEDDEBUGINFO = GameRules.register("reducedDebugInfo", Category.MISC, BooleanValue.create(false, (minecraftserver, gamerules_gameruleboolean) -> {
        byte b0 = (byte)(gamerules_gameruleboolean.get() ? 22 : 23);
        for (ServerPlayer entityplayer : minecraftserver.players()) {
            entityplayer.connection.send(new ClientboundEntityEventPacket(entityplayer, b0));
        }
    }));
    public static final Key<BooleanValue> RULE_SPECTATORSGENERATECHUNKS = GameRules.register("spectatorsGenerateChunks", Category.PLAYER, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_SPAWN_RADIUS = GameRules.register("spawnRadius", Category.PLAYER, IntegerValue.create(10));
    public static final Key<BooleanValue> RULE_DISABLE_PLAYER_MOVEMENT_CHECK = GameRules.register("disablePlayerMovementCheck", Category.PLAYER, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DISABLE_ELYTRA_MOVEMENT_CHECK = GameRules.register("disableElytraMovementCheck", Category.PLAYER, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_MAX_ENTITY_CRAMMING = GameRules.register("maxEntityCramming", Category.MOBS, IntegerValue.create(24));
    public static final Key<BooleanValue> RULE_WEATHER_CYCLE = GameRules.register("doWeatherCycle", Category.UPDATES, BooleanValue.create(!SharedConstants.DEBUG_WORLD_RECREATE));
    public static final Key<BooleanValue> RULE_LIMITED_CRAFTING = GameRules.register("doLimitedCrafting", Category.PLAYER, BooleanValue.create(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (ServerPlayer entityplayer : minecraftserver.players()) {
            entityplayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.LIMITED_CRAFTING, gamerules_gameruleboolean.get() ? 1.0f : 0.0f));
        }
    }));
    public static final Key<IntegerValue> RULE_MAX_COMMAND_CHAIN_LENGTH = GameRules.register("maxCommandChainLength", Category.MISC, IntegerValue.create(65536));
    public static final Key<IntegerValue> RULE_MAX_COMMAND_FORK_COUNT = GameRules.register("maxCommandForkCount", Category.MISC, IntegerValue.create(65536));
    public static final Key<IntegerValue> RULE_COMMAND_MODIFICATION_BLOCK_LIMIT = GameRules.register("commandModificationBlockLimit", Category.MISC, IntegerValue.create(32768));
    public static final Key<BooleanValue> RULE_ANNOUNCE_ADVANCEMENTS = GameRules.register("announceAdvancements", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DISABLE_RAIDS = GameRules.register("disableRaids", Category.MOBS, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DOINSOMNIA = GameRules.register("doInsomnia", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_IMMEDIATE_RESPAWN = GameRules.register("doImmediateRespawn", Category.PLAYER, BooleanValue.create(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (ServerPlayer entityplayer : minecraftserver.players()) {
            entityplayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.IMMEDIATE_RESPAWN, gamerules_gameruleboolean.get() ? 1.0f : 0.0f));
        }
    }));
    public static final Key<IntegerValue> RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY = GameRules.register("playersNetherPortalDefaultDelay", Category.PLAYER, IntegerValue.create(80));
    public static final Key<IntegerValue> RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY = GameRules.register("playersNetherPortalCreativeDelay", Category.PLAYER, IntegerValue.create(0));
    public static final Key<BooleanValue> RULE_DROWNING_DAMAGE = GameRules.register("drowningDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FALL_DAMAGE = GameRules.register("fallDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FIRE_DAMAGE = GameRules.register("fireDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FREEZE_DAMAGE = GameRules.register("freezeDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_PATROL_SPAWNING = GameRules.register("doPatrolSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_TRADER_SPAWNING = GameRules.register("doTraderSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_WARDEN_SPAWNING = GameRules.register("doWardenSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FORGIVE_DEAD_PLAYERS = GameRules.register("forgiveDeadPlayers", Category.MOBS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_UNIVERSAL_ANGER = GameRules.register("universalAnger", Category.MOBS, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_PLAYERS_SLEEPING_PERCENTAGE = GameRules.register("playersSleepingPercentage", Category.PLAYER, IntegerValue.create(100));
    public static final Key<BooleanValue> RULE_BLOCK_EXPLOSION_DROP_DECAY = GameRules.register("blockExplosionDropDecay", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_MOB_EXPLOSION_DROP_DECAY = GameRules.register("mobExplosionDropDecay", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_TNT_EXPLOSION_DROP_DECAY = GameRules.register("tntExplosionDropDecay", Category.DROPS, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_SNOW_ACCUMULATION_HEIGHT = GameRules.register("snowAccumulationHeight", Category.UPDATES, IntegerValue.create(1));
    public static final Key<BooleanValue> RULE_WATER_SOURCE_CONVERSION = GameRules.register("waterSourceConversion", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LAVA_SOURCE_CONVERSION = GameRules.register("lavaSourceConversion", Category.UPDATES, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_GLOBAL_SOUND_EVENTS = GameRules.register("globalSoundEvents", Category.MISC, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_VINES_SPREAD = GameRules.register("doVinesSpread", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_ENDER_PEARLS_VANISH_ON_DEATH = GameRules.register("enderPearlsVanishOnDeath", Category.PLAYER, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_MINECART_MAX_SPEED = GameRules.register("minecartMaxSpeed", Category.MISC, IntegerValue.create(8, 1, 1000, FeatureFlagSet.of(FeatureFlags.MINECART_IMPROVEMENTS), (minecraftserver, gamerules_gameruleint) -> {}));
    public static final Key<BooleanValue> RULE_TNT_EXPLODES = GameRules.register("tntExplodes", Category.MISC, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LOCATOR_BAR = GameRules.register("locatorBar", Category.PLAYER, BooleanValue.create(true, (worldserver, gamerules_gameruleboolean) -> {
        ServerWaypointManager serverwaypointmanager = worldserver.getWaypointManager();
        if (gamerules_gameruleboolean.get()) {
            List<ServerPlayer> list = worldserver.players();
            Objects.requireNonNull(serverwaypointmanager);
            list.forEach(serverwaypointmanager::updatePlayer);
        } else {
            serverwaypointmanager.breakAllConnections();
        }
    }));
    public static final Key<BooleanValue> RULE_PVP = GameRules.register("pvp", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_ALLOW_NETHER = GameRules.register("allowEnteringNetherUsingPortals", Category.MISC, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_SPAWN_MONSTERS = GameRules.register("spawnMonsters", Category.SPAWNING, BooleanValue.create(true, (minecraftserver, gamerules_gameruleboolean) -> minecraftserver.setSpawnSettings(MinecraftServer.isSpawningMonsters(minecraftserver))));
    public static final Key<BooleanValue> RULE_COMMAND_BLOCKS_ENABLED = GameRules.register("commandBlocksEnabled", Category.MISC, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_SPAWNER_BLOCKS_ENABLED = GameRules.register("spawnerBlocksEnabled", Category.MISC, BooleanValue.create(true));
    private final Map<Key<?>, Value<?>> rules;
    private final FeatureFlagSet enabledFeatures;

    public static <T extends Value<T>> Type<T> getType(Key<T> gamerules_gamerulekey) {
        return GAME_RULE_TYPES.get(gamerules_gamerulekey);
    }

    public static <T extends Value<T>> Codec<Key<T>> keyCodec(Class<T> oclass) {
        return Codec.STRING.comapFlatMap(s -> GAME_RULE_TYPES.entrySet().stream().filter(entry -> ((Type)entry.getValue()).valueClass == oclass).map(Map.Entry::getKey).filter(gamerules_gamerulekey -> gamerules_gamerulekey.getId().equals(s)).map(gamerules_gamerulekey -> gamerules_gamerulekey).findFirst().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Invalid game rule ID for type: " + s)), Key::getId);
    }

    private static <T extends Value<T>> Key<T> register(String s, Category gamerules_gamerulecategory, Type<T> gamerules_gameruledefinition) {
        Key gamerules_gamerulekey = new Key(s, gamerules_gamerulecategory);
        Type<T> gamerules_gameruledefinition1 = GAME_RULE_TYPES.put(gamerules_gamerulekey, gamerules_gameruledefinition);
        if (gamerules_gameruledefinition1 != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + s);
        }
        return gamerules_gamerulekey;
    }

    public GameRules(FeatureFlagSet featureflagset, DynamicLike<?> dynamiclike) {
        this(featureflagset);
        this.loadFromTag(dynamiclike);
    }

    public GameRules(FeatureFlagSet featureflagset) {
        this((Map)GameRules.availableRules(featureflagset).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Type)entry.getValue()).createRule())), featureflagset);
    }

    public static Stream<Map.Entry<Key<?>, Type<?>>> availableRules(FeatureFlagSet featureflagset) {
        return GAME_RULE_TYPES.entrySet().stream().filter(entry -> ((Type)entry.getValue()).requiredFeatures.isSubsetOf(featureflagset));
    }

    private GameRules(Map<Key<?>, Value<?>> map, FeatureFlagSet featureflagset) {
        this.rules = map;
        this.enabledFeatures = featureflagset;
    }

    public <T extends Value<T>> T getRule(Key<T> gamerules_gamerulekey) {
        Value<?> t0 = this.rules.get(gamerules_gamerulekey);
        if (t0 == null) {
            throw new IllegalArgumentException("Tried to access invalid game rule");
        }
        return (T)t0;
    }

    public CompoundTag createTag() {
        CompoundTag nbttagcompound = new CompoundTag();
        this.rules.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> nbttagcompound.putString(gamerules_gamerulekey.id, gamerules_gamerulevalue.serialize()));
        return nbttagcompound;
    }

    private void loadFromTag(DynamicLike<?> dynamiclike) {
        this.rules.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> {
            DataResult dataresult = dynamiclike.get(gamerules_gamerulekey.id).asString();
            Objects.requireNonNull(gamerules_gamerulevalue);
            dataresult.ifSuccess(gamerules_gamerulevalue::deserialize);
        });
    }

    public GameRules copy(FeatureFlagSet featureflagset) {
        return new GameRules((Map)GameRules.availableRules(featureflagset).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.rules.containsKey(entry.getKey()) ? this.rules.get(entry.getKey()).copy() : ((Type)entry.getValue()).createRule())), featureflagset);
    }

    public void visitGameRuleTypes(GameRuleTypeVisitor gamerules_gamerulevisitor) {
        GAME_RULE_TYPES.forEach((gamerules_gamerulekey, gamerules_gameruledefinition) -> this.callVisitorCap(gamerules_gamerulevisitor, (Key<?>)gamerules_gamerulekey, (Type<?>)gamerules_gameruledefinition));
    }

    private <T extends Value<T>> void callVisitorCap(GameRuleTypeVisitor gamerules_gamerulevisitor, Key<?> gamerules_gamerulekey, Type<?> gamerules_gameruledefinition) {
        if (gamerules_gameruledefinition.requiredFeatures.isSubsetOf(this.enabledFeatures)) {
            gamerules_gamerulevisitor.visit(gamerules_gamerulekey, gamerules_gameruledefinition);
            gamerules_gameruledefinition.callVisitor(gamerules_gamerulevisitor, gamerules_gamerulekey);
        }
    }

    public void assignFrom(GameRules gamerules, @Nullable ServerLevel minecraftserver) {
        gamerules.rules.keySet().forEach(gamerules_gamerulekey -> this.assignCap((Key)gamerules_gamerulekey, gamerules, minecraftserver));
    }

    private <T extends Value<T>> void assignCap(Key<T> gamerules_gamerulekey, GameRules gamerules, @Nullable ServerLevel minecraftserver) {
        T t0 = gamerules.getRule(gamerules_gamerulekey);
        ((Value)this.getRule(gamerules_gamerulekey)).setFrom(t0, minecraftserver);
    }

    public boolean getBoolean(Key<BooleanValue> gamerules_gamerulekey) {
        return this.getRule(gamerules_gamerulekey).get();
    }

    public int getInt(Key<IntegerValue> gamerules_gamerulekey) {
        return this.getRule(gamerules_gamerulekey).get();
    }

    public static class Type<T extends Value<T>> {
        final Supplier<ArgumentType<?>> argument;
        private final Function<Type<T>, T> constructor;
        final BiConsumer<ServerLevel, T> callback;
        private final VisitorCaller<T> visitorCaller;
        final Class<T> valueClass;
        final FeatureFlagSet requiredFeatures;

        Type(Supplier<ArgumentType<?>> supplier, Function<Type<T>, T> function, BiConsumer<ServerLevel, T> biconsumer, VisitorCaller<T> gamerules_h, Class<T> oclass, FeatureFlagSet featureflagset) {
            this.argument = supplier;
            this.constructor = function;
            this.callback = biconsumer;
            this.visitorCaller = gamerules_h;
            this.valueClass = oclass;
            this.requiredFeatures = featureflagset;
        }

        public RequiredArgumentBuilder<CommandSourceStack, ?> createArgument(String s) {
            return Commands.argument(s, this.argument.get());
        }

        public T createRule() {
            return (T)((Value)this.constructor.apply(this));
        }

        public void callVisitor(GameRuleTypeVisitor gamerules_gamerulevisitor, Key<T> gamerules_gamerulekey) {
            this.visitorCaller.call(gamerules_gamerulevisitor, gamerules_gamerulekey, this);
        }

        public FeatureFlagSet requiredFeatures() {
            return this.requiredFeatures;
        }
    }

    public static final class Key<T extends Value<T>> {
        final String id;
        private final Category category;

        public Key(String s, Category gamerules_gamerulecategory) {
            this.id = s;
            this.category = gamerules_gamerulecategory;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object object) {
            return this == object ? true : object instanceof Key && ((Key)object).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String getId() {
            return this.id;
        }

        public String getDescriptionId() {
            return "gamerule." + this.id;
        }

        public Category getCategory() {
            return this.category;
        }
    }

    public static enum Category {
        PLAYER("gamerule.category.player"),
        MOBS("gamerule.category.mobs"),
        SPAWNING("gamerule.category.spawning"),
        DROPS("gamerule.category.drops"),
        UPDATES("gamerule.category.updates"),
        CHAT("gamerule.category.chat"),
        MISC("gamerule.category.misc");

        private final String descriptionId;

        private Category(String s) {
            this.descriptionId = s;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }
    }

    public static abstract class Value<T extends Value<T>> {
        protected final Type<T> type;

        public Value(Type<T> gamerules_gameruledefinition) {
            this.type = gamerules_gameruledefinition;
        }

        protected abstract void updateFromArgument(CommandContext<CommandSourceStack> var1, String var2);

        public void setFromArgument(CommandContext<CommandSourceStack> commandcontext, String s) {
            this.updateFromArgument(commandcontext, s);
            this.onChanged(((CommandSourceStack)commandcontext.getSource()).getLevel());
        }

        public void onChanged(@Nullable ServerLevel minecraftserver) {
            if (minecraftserver != null) {
                this.type.callback.accept(minecraftserver, (ServerLevel)this.getSelf());
            }
        }

        public abstract void deserialize(String var1);

        public abstract String serialize();

        public String toString() {
            return this.serialize();
        }

        public abstract int getCommandResult();

        protected abstract T getSelf();

        protected abstract T copy();

        public abstract void setFrom(T var1, @Nullable ServerLevel var2);
    }

    public static interface GameRuleTypeVisitor {
        default public <T extends Value<T>> void visit(Key<T> gamerules_gamerulekey, Type<T> gamerules_gameruledefinition) {
        }

        default public void visitBoolean(Key<BooleanValue> gamerules_gamerulekey, Type<BooleanValue> gamerules_gameruledefinition) {
        }

        default public void visitInteger(Key<IntegerValue> gamerules_gamerulekey, Type<IntegerValue> gamerules_gameruledefinition) {
        }
    }

    public static class BooleanValue
    extends Value<BooleanValue> {
        private boolean value;

        private static Type<BooleanValue> create(boolean flag, BiConsumer<ServerLevel, BooleanValue> biconsumer, FeatureFlagSet featureflagset) {
            return new Type<BooleanValue>(BoolArgumentType::bool, gamerules_gameruledefinition -> new BooleanValue((Type<BooleanValue>)gamerules_gameruledefinition, flag), biconsumer, GameRuleTypeVisitor::visitBoolean, BooleanValue.class, featureflagset);
        }

        static Type<BooleanValue> create(boolean flag, BiConsumer<ServerLevel, BooleanValue> biconsumer) {
            return new Type<BooleanValue>(BoolArgumentType::bool, gamerules_gameruledefinition -> new BooleanValue((Type<BooleanValue>)gamerules_gameruledefinition, flag), biconsumer, GameRuleTypeVisitor::visitBoolean, BooleanValue.class, FeatureFlagSet.of());
        }

        public static Type<BooleanValue> create(boolean flag) {
            return BooleanValue.create(flag, (minecraftserver, gamerules_gameruleboolean) -> {});
        }

        public BooleanValue(Type<BooleanValue> gamerules_gameruledefinition, boolean flag) {
            super(gamerules_gameruledefinition);
            this.value = flag;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandSourceStack> commandcontext, String s) {
            this.value = BoolArgumentType.getBool(commandcontext, (String)s);
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean flag, @Nullable ServerLevel minecraftserver) {
            this.value = flag;
            this.onChanged(minecraftserver);
        }

        @Override
        public String serialize() {
            return Boolean.toString(this.value);
        }

        @Override
        public void deserialize(String s) {
            this.value = Boolean.parseBoolean(s);
        }

        @Override
        public int getCommandResult() {
            return this.value ? 1 : 0;
        }

        @Override
        protected BooleanValue getSelf() {
            return this;
        }

        @Override
        protected BooleanValue copy() {
            return new BooleanValue(this.type, this.value);
        }

        @Override
        public void setFrom(BooleanValue gamerules_gameruleboolean, @Nullable ServerLevel minecraftserver) {
            this.value = gamerules_gameruleboolean.value;
            this.onChanged(minecraftserver);
        }
    }

    public static class IntegerValue
    extends Value<IntegerValue> {
        private int value;

        private static Type<IntegerValue> create(int i, BiConsumer<ServerLevel, IntegerValue> biconsumer) {
            return new Type<IntegerValue>(IntegerArgumentType::integer, gamerules_gameruledefinition -> new IntegerValue((Type<IntegerValue>)gamerules_gameruledefinition, i), biconsumer, GameRuleTypeVisitor::visitInteger, IntegerValue.class, FeatureFlagSet.of());
        }

        static Type<IntegerValue> create(int i, int j, int k, FeatureFlagSet featureflagset, BiConsumer<ServerLevel, IntegerValue> biconsumer) {
            return new Type<IntegerValue>(() -> IntegerArgumentType.integer((int)j, (int)k), gamerules_gameruledefinition -> new IntegerValue((Type<IntegerValue>)gamerules_gameruledefinition, i), biconsumer, GameRuleTypeVisitor::visitInteger, IntegerValue.class, featureflagset);
        }

        public static Type<IntegerValue> create(int i) {
            return IntegerValue.create(i, (minecraftserver, gamerules_gameruleint) -> {});
        }

        public IntegerValue(Type<IntegerValue> gamerules_gameruledefinition, int i) {
            super(gamerules_gameruledefinition);
            this.value = i;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandSourceStack> commandcontext, String s) {
            this.value = IntegerArgumentType.getInteger(commandcontext, (String)s);
        }

        public int get() {
            return this.value;
        }

        public void set(int i, @Nullable ServerLevel minecraftserver) {
            this.value = i;
            this.onChanged(minecraftserver);
        }

        @Override
        public String serialize() {
            return Integer.toString(this.value);
        }

        @Override
        public void deserialize(String s) {
            this.value = IntegerValue.safeParse(s);
        }

        public boolean tryDeserialize(String s) {
            try {
                StringReader stringreader = new StringReader(s);
                this.value = (Integer)this.type.argument.get().parse(stringreader);
                return !stringreader.canRead();
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        }

        private static int safeParse(String s) {
            if (!s.isEmpty()) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException numberformatexception) {
                    LOGGER.warn("Failed to parse integer {}", (Object)s);
                }
            }
            return 0;
        }

        @Override
        public int getCommandResult() {
            return this.value;
        }

        @Override
        protected IntegerValue getSelf() {
            return this;
        }

        @Override
        protected IntegerValue copy() {
            return new IntegerValue(this.type, this.value);
        }

        @Override
        public void setFrom(IntegerValue gamerules_gameruleint, @Nullable ServerLevel minecraftserver) {
            this.value = gamerules_gameruleint.value;
            this.onChanged(minecraftserver);
        }
    }

    private static interface VisitorCaller<T extends Value<T>> {
        public void call(GameRuleTypeVisitor var1, Key<T> var2, Type<T> var3);
    }
}

