/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;

public interface LevelAccessor
extends CommonLevelAccessor,
LevelTimeAccess,
ScheduledTickAccess {
    @Override
    default public long dayTime() {
        return this.getLevelData().getDayTime();
    }

    public long nextSubTickCount();

    @Override
    default public <T> ScheduledTick<T> createTick(BlockPos blockposition, T t0, int i, TickPriority ticklistpriority) {
        return new ScheduledTick<T>(t0, blockposition, this.getLevelData().getGameTime() + (long)i, ticklistpriority, this.nextSubTickCount());
    }

    @Override
    default public <T> ScheduledTick<T> createTick(BlockPos blockposition, T t0, int i) {
        return new ScheduledTick<T>(t0, blockposition, this.getLevelData().getGameTime() + (long)i, this.nextSubTickCount());
    }

    public LevelData getLevelData();

    public DifficultyInstance getCurrentDifficultyAt(BlockPos var1);

    @Nullable
    public MinecraftServer getServer();

    default public Difficulty getDifficulty() {
        return this.getLevelData().getDifficulty();
    }

    public ChunkSource getChunkSource();

    @Override
    default public boolean hasChunk(int i, int j) {
        return this.getChunkSource().hasChunk(i, j);
    }

    public RandomSource getRandom();

    default public void updateNeighborsAt(BlockPos blockposition, Block block) {
    }

    default public void neighborShapeChanged(Direction enumdirection, BlockPos blockposition, BlockPos blockposition1, BlockState iblockdata, int i, int j) {
        NeighborUpdater.executeShapeUpdate(this, enumdirection, blockposition, blockposition1, iblockdata, i, j - 1);
    }

    default public void playSound(@Nullable Entity entity, BlockPos blockposition, SoundEvent soundeffect, SoundSource soundcategory) {
        this.playSound(entity, blockposition, soundeffect, soundcategory, 1.0f, 1.0f);
    }

    public void playSound(@Nullable Entity var1, BlockPos var2, SoundEvent var3, SoundSource var4, float var5, float var6);

    public void addParticle(ParticleOptions var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public void levelEvent(@Nullable Entity var1, int var2, BlockPos var3, int var4);

    default public void levelEvent(int i, BlockPos blockposition, int j) {
        this.levelEvent(null, i, blockposition, j);
    }

    public void gameEvent(Holder<GameEvent> var1, Vec3 var2, GameEvent.Context var3);

    default public void gameEvent(@Nullable Entity entity, Holder<GameEvent> holder, Vec3 vec3d) {
        this.gameEvent(holder, vec3d, new GameEvent.Context(entity, null));
    }

    default public void gameEvent(@Nullable Entity entity, Holder<GameEvent> holder, BlockPos blockposition) {
        this.gameEvent(holder, blockposition, new GameEvent.Context(entity, null));
    }

    default public void gameEvent(Holder<GameEvent> holder, BlockPos blockposition, GameEvent.Context gameevent_a) {
        this.gameEvent(holder, Vec3.atCenterOf(blockposition), gameevent_a);
    }

    default public void gameEvent(ResourceKey<GameEvent> resourcekey, BlockPos blockposition, GameEvent.Context gameevent_a) {
        this.gameEvent((Holder<GameEvent>)this.registryAccess().lookupOrThrow(Registries.GAME_EVENT).getOrThrow(resourcekey), blockposition, gameevent_a);
    }

    public ServerLevel getMinecraftWorld();
}

