/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class SimpleExplosionDamageCalculator
extends ExplosionDamageCalculator {
    private final boolean explodesBlocks;
    private final boolean damagesEntities;
    private final Optional<Float> knockbackMultiplier;
    private final Optional<HolderSet<Block>> immuneBlocks;

    public SimpleExplosionDamageCalculator(boolean var0, boolean var1, Optional<Float> var2, Optional<HolderSet<Block>> var3) {
        this.explodesBlocks = var0;
        this.damagesEntities = var1;
        this.knockbackMultiplier = var2;
        this.immuneBlocks = var3;
    }

    @Override
    public Optional<Float> getBlockExplosionResistance(Explosion var0, BlockGetter var1, BlockPos var2, BlockState var3, FluidState var4) {
        if (this.immuneBlocks.isPresent()) {
            if (var3.is(this.immuneBlocks.get())) {
                return Optional.of(Float.valueOf(3600000.0f));
            }
            return Optional.empty();
        }
        return super.getBlockExplosionResistance(var0, var1, var2, var3, var4);
    }

    @Override
    public boolean shouldBlockExplode(Explosion var0, BlockGetter var1, BlockPos var2, BlockState var3, float var4) {
        return this.explodesBlocks;
    }

    @Override
    public boolean shouldDamageEntity(Explosion var0, Entity var1) {
        return this.damagesEntities;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float getKnockbackMultiplier(Entity var0) {
        boolean var1;
        if (var0 instanceof Player) {
            Player var2 = (Player)var0;
            if (var2.getAbilities().flying) {
                return 0.0f;
            }
        }
        boolean bl = var1 = false;
        if (var1) {
            return 0.0f;
        }
        float f = this.knockbackMultiplier.orElseGet(() -> Float.valueOf(super.getKnockbackMultiplier(var0))).floatValue();
        return f;
    }
}

